/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.servlet.ServletContext;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Valve;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.ApplicationParameter;
import org.apache.catalina.deploy.ContextEjb;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextLocalEjb;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.startup.SetAuthConstraint;
import org.apache.catalina.startup.SetDistributableAction;
import org.apache.catalina.startup.SetPublicIdAction;
import org.apache.catalina.startup.WrapperCreate;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.util.xml.XmlMapper;
import org.xml.sax.SAXParseException;

public final class ContextConfig
implements LifecycleListener {
    private static ResourceBundle authenticators = null;
    private Context context = null;
    private int debug = 0;
    private boolean ok = false;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        try {
            int contextDebug;
            this.context = (Context)((Object)event.getLifecycle());
            if (this.context instanceof StandardContext && (contextDebug = ((StandardContext)this.context).getDebug()) > this.debug) {
                this.debug = contextDebug;
            }
        }
        catch (ClassCastException e) {
            this.log(sm.getString("contextConfig.cce", event.getLifecycle()), e);
            return;
        }
        if (event.getType().equals("start")) {
            this.start();
        } else if (event.getType().equals("stop")) {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void applicationConfig(XmlMapper mapper) {
        block15: {
            InputStream stream = null;
            ServletContext servletContext = this.context.getServletContext();
            if (servletContext != null) {
                stream = servletContext.getResourceAsStream("/WEB-INF/web.xml");
            }
            if (stream == null) {
                this.log(sm.getString("contextConfig.applicationMissing"));
                return;
            }
            if (this.context instanceof StandardContext) {
                ((StandardContext)this.context).setReplaceWelcomeFiles(true);
            }
            mapper.readXml(stream, (Object)this.context);
            Object var8_4 = null;
            try {
                stream.close();
            }
            catch (IOException e2) {
                this.log(sm.getString("contextConfig.applicationClose"), e2);
            }
            break block15;
            {
                catch (InvocationTargetException e) {
                    this.log(sm.getString("contextConfig.applicationConfig"), e.getTargetException());
                    this.ok = false;
                    Object var8_5 = null;
                    try {
                        stream.close();
                    }
                    catch (IOException e2) {
                        this.log(sm.getString("contextConfig.applicationClose"), e2);
                    }
                    break block15;
                }
                catch (SAXParseException e) {
                    this.log(sm.getString("contextConfig.applicationParse"), e);
                    this.log(sm.getString("contextConfig.applicationPosition", "" + e.getLineNumber(), "" + e.getColumnNumber()));
                    this.ok = false;
                    Object var8_6 = null;
                    try {
                        stream.close();
                    }
                    catch (IOException e2) {
                        this.log(sm.getString("contextConfig.applicationClose"), e2);
                    }
                    break block15;
                }
                catch (Exception e) {
                    this.log(sm.getString("contextConfig.applicationParse"), e);
                    this.ok = false;
                    Object var8_7 = null;
                    try {
                        stream.close();
                    }
                    catch (IOException e2) {
                        this.log(sm.getString("contextConfig.applicationClose"), e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                try {
                    stream.close();
                }
                catch (IOException e2) {
                    this.log(sm.getString("contextConfig.applicationClose"), e2);
                }
                throw throwable;
            }
        }
    }

    private synchronized void authenticatorConfig() {
        SecurityConstraint[] constraints = this.context.findConstraints();
        if (constraints == null || constraints.length == 0) {
            return;
        }
        LoginConfig loginConfig = this.context.getLoginConfig();
        if (loginConfig == null) {
            loginConfig = new LoginConfig("NONE", null, null, null);
            this.context.setLoginConfig(loginConfig);
        }
        if (this.context instanceof Authenticator) {
            return;
        }
        if (this.context instanceof ContainerBase) {
            Pipeline pipeline = ((ContainerBase)((Object)this.context)).getPipeline();
            if (pipeline != null) {
                Valve basic = pipeline.getBasic();
                if (basic != null && basic instanceof Authenticator) {
                    return;
                }
                Valve[] valves = pipeline.getValves();
                int i = 0;
                while (i < valves.length) {
                    if (valves[i] instanceof Authenticator) {
                        return;
                    }
                    ++i;
                }
            }
        } else {
            return;
        }
        if (this.context.getRealm() == null) {
            this.log(sm.getString("contextConfig.missingRealm"));
            this.ok = false;
            return;
        }
        if (authenticators == null) {
            try {
                authenticators = ResourceBundle.getBundle("org.apache.catalina.startup.Authenticators");
            }
            catch (MissingResourceException e) {
                this.log(sm.getString("contextConfig.authenticatorResources"), e);
                this.ok = false;
                return;
            }
        }
        String authenticatorName = null;
        try {
            authenticatorName = authenticators.getString(loginConfig.getAuthMethod());
        }
        catch (MissingResourceException e) {
            authenticatorName = null;
        }
        if (authenticatorName == null) {
            this.log(sm.getString("contextConfig.authenticatorMissing", loginConfig.getAuthMethod()));
            this.ok = false;
            return;
        }
        Valve authenticator = null;
        try {
            Pipeline pipeline;
            Class<?> authenticatorClass = Class.forName(authenticatorName);
            authenticator = (Valve)authenticatorClass.newInstance();
            if (this.context instanceof ContainerBase && (pipeline = ((ContainerBase)((Object)this.context)).getPipeline()) != null) {
                pipeline.addValve(authenticator);
                this.log(sm.getString("contextConfig.authenticatorConfigured", loginConfig.getAuthMethod()));
            }
        }
        catch (Throwable t) {
            this.log(sm.getString("contextConfig.authenticatorInstantiate", authenticatorName), t);
            this.ok = false;
        }
    }

    private void certificatesConfig() {
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass("javax.net.ssl.SSLSocket");
            if (clazz == null) {
                return;
            }
        }
        catch (Throwable t) {
            return;
        }
        Valve certificates = null;
        try {
            Class<?> clazz = Class.forName("org.apache.catalina.valves.CertificatesValve");
            certificates = (Valve)clazz.newInstance();
        }
        catch (Throwable t) {
            return;
        }
        try {
            Pipeline pipeline;
            if (this.context instanceof ContainerBase && (pipeline = ((ContainerBase)((Object)this.context)).getPipeline()) != null) {
                pipeline.addValve(certificates);
                this.log(sm.getString("contextConfig.certificatesConfig.added"));
            }
        }
        catch (Throwable t) {
            this.log(sm.getString("contextConfig.certificatesConfig.error"), t);
            this.ok = false;
        }
    }

    private XmlMapper createTldMapper() {
        XmlMapper mapper = new XmlMapper();
        if (this.debug > 0) {
            mapper.setDebug(3);
        }
        mapper.setValidating(true);
        mapper.registerDTDRes("-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN", "/javax/servlet/jsp/resources/web-jsptaglibrary_1_1.dtd");
        mapper.registerDTDRes("-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN", "/javax/servlet/jsp/resources/web-jsptaglibrary_1_2.dtd");
        mapper.addRule("taglib/listener/listener-class", mapper.methodSetter("addApplicationListener", 0));
        return mapper;
    }

    private XmlMapper createWebMapper() {
        XmlMapper mapper = new XmlMapper();
        if (this.debug > 0) {
            mapper.setDebug(3);
        }
        mapper.setValidating(true);
        mapper.registerDTDRes("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", "/javax/servlet/resources/web-app_2_2.dtd");
        mapper.registerDTDRes("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", "/javax/servlet/resources/web-app_2_3.dtd");
        mapper.addRule("web-app", new SetPublicIdAction("setPublicId"));
        mapper.addRule("web-app/context-param", mapper.methodSetter("addParameter", 2));
        mapper.addRule("web-app/context-param/param-name", mapper.methodParam(0));
        mapper.addRule("web-app/context-param/param-value", mapper.methodParam(1));
        mapper.addRule("web-app/display-name", mapper.methodSetter("setDisplayName", 0));
        mapper.addRule("web-app/distributable", new SetDistributableAction());
        mapper.addRule("web-app/ejb-local-ref", mapper.objectCreate("org.apache.catalina.deploy.ContextLocalEjb"));
        mapper.addRule("web-app/ejb-local-ref", mapper.addChild("addLocalEjb", "org.apache.catalina.deploy.ContextLocalEjb"));
        mapper.addRule("web-app/ejb-local-ref/description", mapper.methodSetter("setDescription", 0));
        mapper.addRule("web-app/ejb-local-ref/ejb-ref-name", mapper.methodSetter("setName", 0));
        mapper.addRule("web-app/ejb-local-ref/ejb-ref-type", mapper.methodSetter("setType", 0));
        mapper.addRule("web-app/ejb-local-ref/local-home", mapper.methodSetter("setHome", 0));
        mapper.addRule("web-app/ejb-local-ref/local", mapper.methodSetter("setLocal", 0));
        mapper.addRule("web-app/ejb-local-ref/ejb-link", mapper.methodSetter("setLink", 0));
        mapper.addRule("web-app/ejb-ref", mapper.objectCreate("org.apache.catalina.deploy.ContextEjb"));
        mapper.addRule("web-app/ejb-ref", mapper.addChild("addEjb", "org.apache.catalina.deploy.ContextEjb"));
        mapper.addRule("web-app/ejb-ref/description", mapper.methodSetter("setDescription", 0));
        mapper.addRule("web-app/ejb-ref/ejb-ref-name", mapper.methodSetter("setName", 0));
        mapper.addRule("web-app/ejb-ref/ejb-ref-type", mapper.methodSetter("setType", 0));
        mapper.addRule("web-app/ejb-ref/home", mapper.methodSetter("setHome", 0));
        mapper.addRule("web-app/ejb-ref/remote", mapper.methodSetter("setRemote", 0));
        mapper.addRule("web-app/ejb-ref/ejb-link", mapper.methodSetter("setLink", 0));
        mapper.addRule("web-app/env-entry", mapper.objectCreate("org.apache.catalina.deploy.ContextEnvironment"));
        mapper.addRule("web-app/env-entry", mapper.addChild("addEnvironment", "org.apache.catalina.deploy.ContextEnvironment"));
        mapper.addRule("web-app/env-entry/env-entry-description", mapper.methodSetter("setDescription", 0));
        mapper.addRule("web-app/env-entry/env-entry-name", mapper.methodSetter("setName", 0));
        mapper.addRule("web-app/env-entry/env-entry-type", mapper.methodSetter("setType", 0));
        mapper.addRule("web-app/env-entry/env-entry-value", mapper.methodSetter("setValue", 0));
        mapper.addRule("web-app/error-page", mapper.objectCreate("org.apache.catalina.deploy.ErrorPage"));
        mapper.addRule("web-app/error-page", mapper.addChild("addErrorPage", "org.apache.catalina.deploy.ErrorPage"));
        mapper.addRule("web-app/error-page/error-code", mapper.methodSetter("setErrorCode", 0));
        mapper.addRule("web-app/error-page/exception-type", mapper.methodSetter("setExceptionType", 0));
        mapper.addRule("web-app/error-page/location", mapper.methodSetter("setLocation", 0));
        mapper.addRule("web-app/filter", mapper.objectCreate("org.apache.catalina.deploy.FilterDef"));
        mapper.addRule("web-app/filter", mapper.addChild("addFilterDef", "org.apache.catalina.deploy.FilterDef"));
        mapper.addRule("web-app/filter/description", mapper.methodSetter("setDescription", 0));
        mapper.addRule("web-app/filter/display-name", mapper.methodSetter("setDisplayName", 0));
        mapper.addRule("web-app/filter/filter-class", mapper.methodSetter("setFilterClass", 0));
        mapper.addRule("web-app/filter/filter-name", mapper.methodSetter("setFilterName", 0));
        mapper.addRule("web-app/filter/icon/large-icon", mapper.methodSetter("setLargeIcon", 0));
        mapper.addRule("web-app/filter/icon/small-icon", mapper.methodSetter("setSmallIcon", 0));
        mapper.addRule("web-app/filter/init-param", mapper.methodSetter("addInitParameter", 2));
        mapper.addRule("web-app/filter/init-param/param-name", mapper.methodParam(0));
        mapper.addRule("web-app/filter/init-param/param-value", mapper.methodParam(1));
        mapper.addRule("web-app/filter-mapping", mapper.objectCreate("org.apache.catalina.deploy.FilterMap"));
        mapper.addRule("web-app/filter-mapping", mapper.addChild("addFilterMap", "org.apache.catalina.deploy.FilterMap"));
        mapper.addRule("web-app/filter-mapping/filter-name", mapper.methodSetter("setFilterName", 0));
        mapper.addRule("web-app/filter-mapping/servlet-name", mapper.methodSetter("setServletName", 0));
        mapper.addRule("web-app/filter-mapping/url-pattern", mapper.methodSetter("setURLPattern", 0));
        mapper.addRule("web-app/listener/listener-class", mapper.methodSetter("addApplicationListener", 0));
        mapper.addRule("web-app/login-config", mapper.objectCreate("org.apache.catalina.deploy.LoginConfig"));
        mapper.addRule("web-app/login-config", mapper.addChild("setLoginConfig", "org.apache.catalina.deploy.LoginConfig"));
        mapper.addRule("web-app/login-config/auth-method", mapper.methodSetter("setAuthMethod", 0));
        mapper.addRule("web-app/login-config/realm-name", mapper.methodSetter("setRealmName", 0));
        mapper.addRule("web-app/login-config/form-login-config/form-login-page", mapper.methodSetter("setLoginPage", 0));
        mapper.addRule("web-app/login-config/form-login-config/form-error-page", mapper.methodSetter("setErrorPage", 0));
        mapper.addRule("web-app/mime-mapping", mapper.methodSetter("addMimeMapping", 2));
        mapper.addRule("web-app/mime-mapping/extension", mapper.methodParam(0));
        mapper.addRule("web-app/mime-mapping/mime-type", mapper.methodParam(1));
        mapper.addRule("web-app/resource-env-ref", mapper.methodSetter("addResourceEnvRef", 2));
        mapper.addRule("web-app/resource-env-ref/resource-env-ref-name", mapper.methodParam(0));
        mapper.addRule("web-app/resource-env-ref/resource-env-ref-type", mapper.methodParam(1));
        mapper.addRule("web-app/resource-ref", mapper.objectCreate("org.apache.catalina.deploy.ContextResource"));
        mapper.addRule("web-app/resource-ref", mapper.addChild("addResource", "org.apache.catalina.deploy.ContextResource"));
        mapper.addRule("web-app/resource-ref/description", mapper.methodSetter("setDescription", 0));
        mapper.addRule("web-app/resource-ref/res-auth", mapper.methodSetter("setAuth", 0));
        mapper.addRule("web-app/resource-ref/res-ref-name", mapper.methodSetter("setName", 0));
        mapper.addRule("web-app/resource-ref/res-sharing-scope", mapper.methodSetter("setScope", 0));
        mapper.addRule("web-app/resource-ref/res-type", mapper.methodSetter("setType", 0));
        mapper.addRule("web-app/security-constraint", mapper.objectCreate("org.apache.catalina.deploy.SecurityConstraint"));
        mapper.addRule("web-app/security-constraint", mapper.addChild("addConstraint", "org.apache.catalina.deploy.SecurityConstraint"));
        mapper.addRule("web-app/security-constraint/auth-constraint", new SetAuthConstraint());
        mapper.addRule("web-app/security-constraint/auth-constraint/role-name", mapper.methodSetter("addAuthRole", 0));
        mapper.addRule("web-app/security-constraint/display-name", mapper.methodSetter("setDisplayName", 0));
        mapper.addRule("web-app/security-constraint/user-data-constraint/transport-guarantee", mapper.methodSetter("setUserConstraint", 0));
        mapper.addRule("web-app/security-constraint/web-resource-collection", mapper.objectCreate("org.apache.catalina.deploy.SecurityCollection"));
        mapper.addRule("web-app/security-constraint/web-resource-collection", mapper.addChild("addCollection", "org.apache.catalina.deploy.SecurityCollection"));
        mapper.addRule("web-app/security-constraint/web-resource-collection/http-method", mapper.methodSetter("addMethod", 0));
        mapper.addRule("web-app/security-constraint/web-resource-collection/url-pattern", mapper.methodSetter("addPattern", 0));
        mapper.addRule("web-app/security-constraint/web-resource-collection/web-resource-name", mapper.methodSetter("setName", 0));
        mapper.addRule("web-app/security-role", mapper.methodSetter("addSecurityRole", 1));
        mapper.addRule("web-app/security-role/role-name", mapper.methodParam(0));
        mapper.addRule("web-app/servlet", new WrapperCreate(this.context));
        mapper.addRule("web-app/servlet", mapper.addChild("addChild", "org.apache.catalina.Container"));
        mapper.addRule("web-app/servlet/init-param", mapper.methodSetter("addInitParameter", 2));
        mapper.addRule("web-app/servlet/init-param/param-name", mapper.methodParam(0));
        mapper.addRule("web-app/servlet/init-param/param-value", mapper.methodParam(1));
        mapper.addRule("web-app/servlet/jsp-file", mapper.methodSetter("setJspFile", 0));
        mapper.addRule("web-app/servlet/load-on-startup", mapper.methodSetter("setLoadOnStartupString", 0));
        mapper.addRule("web-app/servlet/run-as/role-name", mapper.methodSetter("setRunAs", 0));
        mapper.addRule("web-app/servlet/security-role-ref", mapper.methodSetter("addSecurityReference", 2));
        mapper.addRule("web-app/servlet/security-role-ref/role-link", mapper.methodParam(1));
        mapper.addRule("web-app/servlet/security-role-ref/role-name", mapper.methodParam(0));
        mapper.addRule("web-app/servlet/servlet-class", mapper.methodSetter("setServletClass", 0));
        mapper.addRule("web-app/servlet/servlet-name", mapper.methodSetter("setName", 0));
        mapper.addRule("web-app/servlet-mapping", mapper.methodSetter("addServletMapping", 2));
        mapper.addRule("web-app/servlet-mapping/servlet-name", mapper.methodParam(1));
        mapper.addRule("web-app/servlet-mapping/url-pattern", mapper.methodParam(0));
        mapper.addRule("web-app/session-config", mapper.methodSetter("setSessionTimeout", 1, new String[]{"int"}));
        mapper.addRule("web-app/session-config/session-timeout", mapper.methodParam(0));
        mapper.addRule("web-app/taglib", mapper.methodSetter("addTaglib", 2));
        mapper.addRule("web-app/taglib/taglib-location", mapper.methodParam(1));
        mapper.addRule("web-app/taglib/taglib-uri", mapper.methodParam(0));
        mapper.addRule("web-app/welcome-file-list/welcome-file", mapper.methodSetter("addWelcomeFile", 0));
        return mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void defaultConfig(XmlMapper mapper) {
        block17: {
            File file = new File("conf/web.xml");
            if (!file.isAbsolute()) {
                file = new File(System.getProperty("catalina.base"), "conf/web.xml");
            }
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(file.getCanonicalPath());
            }
            catch (FileNotFoundException e) {
                this.log(sm.getString("contextConfig.defaultMissing"));
                return;
            }
            catch (IOException e) {
                this.log(sm.getString("contextConfig.defaultMissing"), e);
                return;
            }
            if (this.context instanceof StandardContext) {
                ((StandardContext)this.context).setReplaceWelcomeFiles(true);
            }
            mapper.readXml(stream, (Object)this.context);
            Object var8_8 = null;
            try {
                stream.close();
            }
            catch (IOException e2) {
                this.log(sm.getString("contextConfig.defaultClose"), e2);
            }
            break block17;
            {
                catch (InvocationTargetException e) {
                    this.log(sm.getString("contextConfig.defaultConfig"), e.getTargetException());
                    this.ok = false;
                    Object var8_9 = null;
                    try {
                        stream.close();
                    }
                    catch (IOException e2) {
                        this.log(sm.getString("contextConfig.defaultClose"), e2);
                    }
                    break block17;
                }
                catch (SAXParseException e) {
                    this.log(sm.getString("contextConfig.defaultParse"), e);
                    this.log(sm.getString("contextConfig.defaultPosition", "" + e.getLineNumber(), "" + e.getColumnNumber()));
                    this.ok = false;
                    Object var8_10 = null;
                    try {
                        stream.close();
                    }
                    catch (IOException e2) {
                        this.log(sm.getString("contextConfig.defaultClose"), e2);
                    }
                    break block17;
                }
                catch (Exception e) {
                    this.log(sm.getString("contextConfig.defaultParse"), e);
                    this.ok = false;
                    Object var8_11 = null;
                    try {
                        stream.close();
                    }
                    catch (IOException e2) {
                        this.log(sm.getString("contextConfig.defaultClose"), e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                try {
                    stream.close();
                }
                catch (IOException e2) {
                    this.log(sm.getString("contextConfig.defaultClose"), e2);
                }
                throw throwable;
            }
        }
    }

    private void log(String message) {
        Logger logger = null;
        if (this.context != null) {
            logger = this.context.getLogger();
        }
        if (logger != null) {
            logger.log("ContextConfig[" + this.context.getName() + "]: " + message);
        } else {
            System.out.println("ContextConfig[" + this.context.getName() + "]: " + message);
        }
    }

    private void log(String message, Throwable throwable) {
        Logger logger = null;
        if (this.context != null) {
            logger = this.context.getLogger();
        }
        if (logger != null) {
            logger.log("ContextConfig[" + this.context.getName() + "] " + message, throwable);
        } else {
            System.out.println("ContextConfig[" + this.context.getName() + "]: " + message);
            System.out.println("" + throwable);
            throwable.printStackTrace(System.out);
        }
    }

    private synchronized void start() {
        if (this.debug > 0) {
            this.log(sm.getString("contextConfig.start"));
        }
        this.context.setConfigured(false);
        this.ok = true;
        Container container = this.context.getParent();
        if (!this.context.getOverride()) {
            if (container instanceof Host) {
                ((Host)container).importDefaultContext(this.context);
                container = container.getParent();
            }
            if (container instanceof Engine) {
                ((Engine)container).importDefaultContext(this.context);
            }
        }
        XmlMapper mapper = this.createWebMapper();
        this.defaultConfig(mapper);
        this.applicationConfig(mapper);
        if (this.ok) {
            this.tldConfig();
        }
        if (this.ok) {
            this.certificatesConfig();
        }
        if (this.ok) {
            this.authenticatorConfig();
        }
        if (this.debug >= 1 && this.context instanceof ContainerBase) {
            this.log("Pipline Configuration:");
            Pipeline pipeline = ((ContainerBase)((Object)this.context)).getPipeline();
            Valve[] valves = null;
            if (pipeline != null) {
                valves = pipeline.getValves();
            }
            if (valves != null) {
                int i = 0;
                while (i < valves.length) {
                    this.log("  " + valves[i].getInfo());
                    ++i;
                }
            }
            this.log("======================");
        }
        if (this.ok) {
            this.context.setConfigured(true);
        } else {
            this.log(sm.getString("contextConfig.unavailable"));
            this.context.setConfigured(false);
        }
    }

    private synchronized void stop() {
        if (this.debug > 0) {
            this.log(sm.getString("contextConfig.stop"));
        }
        Container[] children = this.context.findChildren();
        int i = 0;
        while (i < children.length) {
            this.context.removeChild(children[i]);
            ++i;
        }
        String[] applicationListeners = this.context.findApplicationListeners();
        i = 0;
        while (i < applicationListeners.length) {
            this.context.removeApplicationListener(applicationListeners[i]);
            ++i;
        }
        ApplicationParameter[] applicationParameters = this.context.findApplicationParameters();
        i = 0;
        while (i < applicationParameters.length) {
            this.context.removeApplicationParameter(applicationParameters[i].getName());
            ++i;
        }
        SecurityConstraint[] securityConstraints = this.context.findConstraints();
        i = 0;
        while (i < securityConstraints.length) {
            this.context.removeConstraint(securityConstraints[i]);
            ++i;
        }
        ContextEjb[] contextEjbs = this.context.findEjbs();
        i = 0;
        while (i < contextEjbs.length) {
            this.context.removeEjb(contextEjbs[i].getName());
            ++i;
        }
        ContextEnvironment[] contextEnvironments = this.context.findEnvironments();
        i = 0;
        while (i < contextEnvironments.length) {
            this.context.removeEnvironment(contextEnvironments[i].getName());
            ++i;
        }
        ErrorPage[] errorPages = this.context.findErrorPages();
        i = 0;
        while (i < errorPages.length) {
            this.context.removeErrorPage(errorPages[i]);
            ++i;
        }
        FilterDef[] filterDefs = this.context.findFilterDefs();
        i = 0;
        while (i < filterDefs.length) {
            this.context.removeFilterDef(filterDefs[i]);
            ++i;
        }
        FilterMap[] filterMaps = this.context.findFilterMaps();
        i = 0;
        while (i < filterMaps.length) {
            this.context.removeFilterMap(filterMaps[i]);
            ++i;
        }
        String[] instanceListeners = this.context.findInstanceListeners();
        i = 0;
        while (i < instanceListeners.length) {
            this.context.removeInstanceListener(instanceListeners[i]);
            ++i;
        }
        ContextLocalEjb[] contextLocalEjbs = this.context.findLocalEjbs();
        i = 0;
        while (i < contextLocalEjbs.length) {
            this.context.removeLocalEjb(contextLocalEjbs[i].getName());
            ++i;
        }
        String[] mimeMappings = this.context.findMimeMappings();
        i = 0;
        while (i < mimeMappings.length) {
            this.context.removeMimeMapping(mimeMappings[i]);
            ++i;
        }
        String[] parameters = this.context.findParameters();
        i = 0;
        while (i < parameters.length) {
            this.context.removeParameter(parameters[i]);
            ++i;
        }
        String[] resourceEnvRefs = this.context.findResourceEnvRefs();
        i = 0;
        while (i < resourceEnvRefs.length) {
            this.context.removeResourceEnvRef(resourceEnvRefs[i]);
            ++i;
        }
        ContextResource[] contextResources = this.context.findResources();
        i = 0;
        while (i < contextResources.length) {
            this.context.removeResource(contextResources[i].getName());
            ++i;
        }
        String[] securityRoles = this.context.findSecurityRoles();
        i = 0;
        while (i < securityRoles.length) {
            this.context.removeSecurityRole(securityRoles[i]);
            ++i;
        }
        String[] servletMappings = this.context.findServletMappings();
        i = 0;
        while (i < servletMappings.length) {
            this.context.removeServletMapping(servletMappings[i]);
            ++i;
        }
        String[] taglibs = this.context.findTaglibs();
        i = 0;
        while (i < taglibs.length) {
            this.context.removeTaglib(taglibs[i]);
            ++i;
        }
        String[] welcomeFiles = this.context.findWelcomeFiles();
        i = 0;
        while (i < welcomeFiles.length) {
            this.context.removeWelcomeFile(welcomeFiles[i]);
            ++i;
        }
        String[] wrapperLifecycles = this.context.findWrapperLifecycles();
        i = 0;
        while (i < wrapperLifecycles.length) {
            this.context.removeWrapperLifecycle(wrapperLifecycles[i]);
            ++i;
        }
        String[] wrapperListeners = this.context.findWrapperListeners();
        i = 0;
        while (i < wrapperListeners.length) {
            this.context.removeWrapperListener(wrapperListeners[i]);
            ++i;
        }
        this.ok = true;
    }

    private void tldConfig() {
        XmlMapper mapper = this.createTldMapper();
        if (this.debug >= 1) {
            this.log("Scanning web.xml tag libraries");
        }
        ArrayList<String> resourcePaths = new ArrayList<String>();
        String[] taglibs = this.context.findTaglibs();
        int i = 0;
        while (i < taglibs.length) {
            String resourcePath = this.context.findTaglib(taglibs[i]);
            if (!resourcePath.startsWith("/")) {
                resourcePath = "/WEB-INF/web.xml/../" + resourcePath;
            }
            if (this.debug >= 2) {
                this.log("  URI='" + taglibs[i] + "', ResourcePath='" + resourcePath + "'");
            }
            if (resourcePaths.contains(resourcePath)) {
                if (this.debug >= 2) {
                    this.log("    Already processed");
                }
            } else {
                resourcePaths.add(resourcePath);
                if (!this.tldConfigJar(resourcePath, mapper)) {
                    this.tldConfigTld(resourcePath, mapper);
                }
            }
            ++i;
        }
        DirContext resources = this.context.getResources();
        if (this.debug >= 1) {
            this.log("Scanning TLD files in /WEB-INF");
        }
        String webinfName = "/WEB-INF";
        try {
            NamingEnumeration<NameClassPair> namingEnumeration = resources.list(webinfName);
            while (namingEnumeration.hasMoreElements()) {
                NameClassPair ncPair = (NameClassPair)namingEnumeration.nextElement();
                String filename = webinfName + "/" + ncPair.getName();
                if (!filename.endsWith(".tld")) continue;
                this.tldConfigTld(filename, mapper);
            }
        }
        catch (NamingException e) {
            // empty catch block
        }
        if (this.debug >= 1) {
            this.log("Scanning library JAR files");
        }
        String libName = "/WEB-INF/lib";
        try {
            NamingEnumeration<NameClassPair> namingEnumeration = resources.list(libName);
            while (namingEnumeration.hasMoreElements()) {
                NameClassPair ncPair = (NameClassPair)namingEnumeration.nextElement();
                String filename = libName + "/" + ncPair.getName();
                if (!filename.endsWith(".jar")) continue;
                this.tldConfigJar(filename, mapper);
            }
        }
        catch (NamingException e) {}
    }

    private boolean tldConfigJar(String resourcePath, XmlMapper mapper) {
        ZipFile jarFile = null;
        InputStream stream = null;
        try {
            URL url = this.context.getServletContext().getResource(resourcePath);
            if (url == null) {
                return false;
            }
            url = new URL("jar:" + url.toString() + "!/");
            JarURLConnection conn = (JarURLConnection)url.openConnection();
            jarFile = conn.getJarFile();
            boolean found = false;
            Enumeration<JarEntry> entries = ((JarFile)jarFile).entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith("META-INF/") || !name.endsWith(".tld")) continue;
                if (this.debug >= 2) {
                    this.log("    tldConfigJar(" + resourcePath + "): Processing entry '" + name + "'");
                }
                stream = ((JarFile)jarFile).getInputStream(entry);
                mapper.readXml(stream, (Object)this.context);
                stream.close();
                found = true;
            }
            return found;
        }
        catch (Exception e) {
            block11: {
                if (this.debug >= 2) {
                    this.log("    tldConfigJar(" + resourcePath + "): " + e);
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                if (jarFile == null) break block11;
                try {
                    jarFile.close();
                }
                catch (Throwable t) {}
            }
            return false;
        }
    }

    private boolean tldConfigTld(String resourcePath, XmlMapper mapper) {
        InputStream stream = null;
        try {
            stream = this.context.getServletContext().getResourceAsStream(resourcePath);
            if (stream == null) {
                return false;
            }
            mapper.readXml(stream, (Object)this.context);
            stream.close();
            return true;
        }
        catch (Exception e) {
            block6: {
                if (this.debug >= 2) {
                    this.log("    tldConfigTld(" + resourcePath + "): " + e);
                }
                if (stream == null) break block6;
                try {
                    stream.close();
                }
                catch (Throwable t) {}
            }
            return false;
        }
    }
}

