/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.ValveContext;
import org.apache.catalina.core.ApplicationFilterChain;
import org.apache.catalina.core.ApplicationFilterConfig;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;

final class StandardWrapperValve
extends ValveBase {
    private int debug = 0;
    private FilterDef filterDef = null;
    private static final String info = "org.apache.catalina.core.StandardWrapperValve/1.0";
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");

    StandardWrapperValve() {
    }

    public String getInfo() {
        return info;
    }

    public void invoke(Request request, Response response, ValveContext valveContext) throws IOException, ServletException {
        block30: {
            Servlet servlet;
            StandardWrapper wrapper;
            Throwable throwable;
            block29: {
                block28: {
                    boolean unavailable = false;
                    throwable = null;
                    wrapper = (StandardWrapper)this.getContainer();
                    ServletRequest sreq = request.getRequest();
                    ServletResponse sres = response.getResponse();
                    servlet = null;
                    HttpServletRequest hreq = null;
                    if (sreq instanceof HttpServletRequest) {
                        hreq = (HttpServletRequest)sreq;
                    }
                    HttpServletResponse hres = null;
                    if (sres instanceof HttpServletResponse) {
                        hres = (HttpServletResponse)sres;
                    }
                    if (!((Context)wrapper.getParent()).getAvailable()) {
                        hres.sendError(503, sm.getString("standardContext.isUnavailable"));
                        unavailable = true;
                    }
                    if (!unavailable && wrapper.isUnavailable()) {
                        this.log(sm.getString("standardWrapper.isUnavailable", wrapper.getName()));
                        if (hres != null) {
                            long available = wrapper.getAvailable();
                            if (available > 0L && available < Long.MAX_VALUE) {
                                hres.setDateHeader("Retry-After", available);
                            }
                            hres.sendError(503, sm.getString("standardWrapper.isUnavailable", wrapper.getName()));
                        }
                        unavailable = true;
                    }
                    try {
                        if (!unavailable) {
                            servlet = wrapper.allocate();
                        }
                    }
                    catch (ServletException e) {
                        this.log(sm.getString("standardWrapper.allocateException", wrapper.getName()), e);
                        throwable = e;
                        this.exception(request, response, e);
                        servlet = null;
                    }
                    catch (Throwable e) {
                        this.log(sm.getString("standardWrapper.allocateException", wrapper.getName()), e);
                        throwable = e;
                        this.exception(request, response, e);
                        servlet = null;
                    }
                    ApplicationFilterChain filterChain = this.createFilterChain(request, servlet);
                    try {
                        String jspFile = wrapper.getJspFile();
                        if (jspFile != null) {
                            sreq.setAttribute("org.apache.catalina.jsp_file", (Object)jspFile);
                        } else {
                            sreq.removeAttribute("org.apache.catalina.jsp_file");
                        }
                        if (servlet != null && filterChain != null) {
                            filterChain.doFilter(sreq, sres);
                        }
                        sreq.removeAttribute("org.apache.catalina.jsp_file");
                    }
                    catch (IOException e) {
                        sreq.removeAttribute("org.apache.catalina.jsp_file");
                        this.log(sm.getString("standardWrapper.serviceException", wrapper.getName()), e);
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    catch (UnavailableException e) {
                        sreq.removeAttribute("org.apache.catalina.jsp_file");
                        this.log(sm.getString("standardWrapper.serviceException", wrapper.getName()), e);
                        wrapper.unavailable(e);
                        long available = wrapper.getAvailable();
                        if (available > 0L && available < Long.MAX_VALUE) {
                            hres.setDateHeader("Retry-After", available);
                        }
                        hres.sendError(503, sm.getString("standardWrapper.isUnavailable", wrapper.getName()));
                    }
                    catch (ServletException e) {
                        sreq.removeAttribute("org.apache.catalina.jsp_file");
                        this.log(sm.getString("standardWrapper.serviceException", wrapper.getName()), e);
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    catch (Throwable e) {
                        sreq.removeAttribute("org.apache.catalina.jsp_file");
                        this.log(sm.getString("standardWrapper.serviceException", wrapper.getName()), e);
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    try {
                        if (filterChain != null) {
                            filterChain.release();
                        }
                    }
                    catch (Throwable e) {
                        this.log(sm.getString("standardWrapper.releaseFilters", wrapper.getName()), e);
                        if (throwable != null) break block28;
                        throwable = e;
                        this.exception(request, response, e);
                    }
                }
                try {
                    if (servlet != null) {
                        wrapper.deallocate(servlet);
                    }
                }
                catch (Throwable e) {
                    this.log(sm.getString("standardWrapper.deallocateException", wrapper.getName()), e);
                    if (throwable != null) break block29;
                    throwable = e;
                    this.exception(request, response, e);
                }
            }
            try {
                if (servlet != null && wrapper.getAvailable() == Long.MAX_VALUE) {
                    wrapper.unload();
                }
            }
            catch (Throwable e) {
                this.log(sm.getString("standardWrapper.unloadException", wrapper.getName()), e);
                if (throwable != null) break block30;
                throwable = e;
                this.exception(request, response, e);
            }
        }
    }

    private ApplicationFilterChain createFilterChain(Request request, Servlet servlet) {
        if (servlet == null) {
            return null;
        }
        ApplicationFilterChain filterChain = new ApplicationFilterChain();
        filterChain.setServlet(servlet);
        StandardWrapper wrapper = (StandardWrapper)this.getContainer();
        filterChain.setSupport(wrapper.getInstanceSupport());
        StandardContext context = (StandardContext)wrapper.getParent();
        FilterMap[] filterMaps = context.findFilterMaps();
        if (filterMaps == null || filterMaps.length == 0) {
            return filterChain;
        }
        String requestPath = null;
        if (request instanceof HttpRequest) {
            String requestURI;
            HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
            String contextPath = hreq.getContextPath();
            if (contextPath == null) {
                contextPath = "";
            }
            if ((requestURI = hreq.getRequestURI()).length() >= contextPath.length()) {
                requestPath = requestURI.substring(contextPath.length());
            }
        }
        String servletName = wrapper.getName();
        int n = 0;
        int i = 0;
        while (i < filterMaps.length) {
            ApplicationFilterConfig filterConfig;
            if (this.matchFiltersURL(filterMaps[i], requestPath) && (filterConfig = (ApplicationFilterConfig)context.findFilterConfig(filterMaps[i].getFilterName())) != null) {
                filterChain.addFilter(filterConfig);
                ++n;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < filterMaps.length) {
            ApplicationFilterConfig filterConfig;
            if (this.matchFiltersServlet(filterMaps[i2], servletName) && (filterConfig = (ApplicationFilterConfig)context.findFilterConfig(filterMaps[i2].getFilterName())) != null) {
                filterChain.addFilter(filterConfig);
                ++n;
            }
            ++i2;
        }
        return filterChain;
    }

    private void exception(Request request, Response response, Throwable exception) {
        ServletRequest sreq = request.getRequest();
        sreq.setAttribute("javax.servlet.error.exception", (Object)exception);
        ServletResponse sresponse = response.getResponse();
        if (sresponse instanceof HttpServletResponse) {
            ((HttpServletResponse)sresponse).setStatus(500);
        }
    }

    private void log(String message) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        if (logger != null) {
            logger.log("StandardWrapperValve[" + this.container.getName() + "]: " + message);
        } else {
            String containerName = null;
            if (this.container != null) {
                containerName = this.container.getName();
            }
            System.out.println("StandardWrapperValve[" + containerName + "]: " + message);
        }
    }

    private void log(String message, Throwable throwable) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        if (logger != null) {
            logger.log("StandardWrapperValve[" + this.container.getName() + "]: " + message, throwable);
        } else {
            String containerName = null;
            if (this.container != null) {
                containerName = this.container.getName();
            }
            System.out.println("StandardWrapperValve[" + containerName + "]: " + message);
            System.out.println("" + throwable);
            throwable.printStackTrace(System.out);
        }
    }

    private boolean matchFiltersServlet(FilterMap filterMap, String servletName) {
        if (servletName == null) {
            return false;
        }
        return servletName.equals(filterMap.getServletName());
    }

    private boolean matchFiltersURL(FilterMap filterMap, String requestPath) {
        if (requestPath == null) {
            return false;
        }
        String testPath = filterMap.getURLPattern();
        if (testPath == null) {
            return false;
        }
        if (testPath.equals(requestPath)) {
            return true;
        }
        if (testPath.equals("/*")) {
            return true;
        }
        if (testPath.endsWith("/*")) {
            String comparePath = requestPath;
            while (true) {
                if (testPath.equals(comparePath + "/*")) {
                    return true;
                }
                int slash = comparePath.lastIndexOf(47);
                if (slash < 0) break;
                comparePath = comparePath.substring(0, slash);
            }
            return false;
        }
        if (testPath.startsWith("*.")) {
            int slash = requestPath.lastIndexOf(47);
            int period = requestPath.lastIndexOf(46);
            if (slash >= 0 && period > slash) {
                return testPath.equals("*." + requestPath.substring(period + 1));
            }
        }
        return false;
    }
}

