/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.core.ApplicationFilterConfig;
import org.apache.catalina.util.InstanceSupport;
import org.apache.catalina.util.StringManager;

final class ApplicationFilterChain
implements FilterChain {
    private ArrayList filters = new ArrayList();
    private Iterator iterator = null;
    private Servlet servlet = null;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private InstanceSupport support = null;

    public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (System.getSecurityManager() != null) {
            final ServletRequest req = request;
            final ServletResponse res = response;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ServletException, IOException {
                        ApplicationFilterChain.this.internalDoFilter(req, res);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pe) {
                Exception e = pe.getException();
                if (e instanceof ServletException) {
                    throw (ServletException)((Object)e);
                }
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
        } else {
            this.internalDoFilter(request, response);
        }
    }

    private void internalDoFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (this.iterator == null) {
            this.iterator = this.filters.iterator();
        }
        if (this.iterator.hasNext()) {
            ApplicationFilterConfig filterConfig = (ApplicationFilterConfig)this.iterator.next();
            Filter filter = null;
            try {
                filter = filterConfig.getFilter();
                this.support.fireInstanceEvent("beforeFilter", filter, request, response);
                filter.doFilter(request, response, (FilterChain)this);
                this.support.fireInstanceEvent("afterFilter", filter, request, response);
            }
            catch (IOException e) {
                if (filter != null) {
                    this.support.fireInstanceEvent("afterFilter", filter, request, response, (Throwable)e);
                }
                throw e;
            }
            catch (ServletException e) {
                if (filter != null) {
                    this.support.fireInstanceEvent("afterFilter", filter, request, response, (Throwable)e);
                }
                throw e;
            }
            catch (RuntimeException e) {
                if (filter != null) {
                    this.support.fireInstanceEvent("afterFilter", filter, request, response, (Throwable)e);
                }
                throw e;
            }
            catch (Throwable e) {
                if (filter != null) {
                    this.support.fireInstanceEvent("afterFilter", filter, request, response, e);
                }
                throw new ServletException(sm.getString("filterChain.filter"), e);
            }
            return;
        }
        try {
            this.support.fireInstanceEvent("beforeService", this.servlet, request, response);
            if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
                this.servlet.service((ServletRequest)((HttpServletRequest)request), (ServletResponse)((HttpServletResponse)response));
            } else {
                this.servlet.service(request, response);
            }
            this.support.fireInstanceEvent("afterService", this.servlet, request, response);
        }
        catch (IOException e) {
            this.support.fireInstanceEvent("afterService", this.servlet, request, response, (Throwable)e);
            throw e;
        }
        catch (ServletException e) {
            this.support.fireInstanceEvent("afterService", this.servlet, request, response, (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            this.support.fireInstanceEvent("afterService", this.servlet, request, response, (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            this.support.fireInstanceEvent("afterService", this.servlet, request, response, e);
            throw new ServletException(sm.getString("filterChain.servlet"), e);
        }
    }

    void addFilter(ApplicationFilterConfig filterConfig) {
        this.filters.add(filterConfig);
    }

    void release() {
        this.filters.clear();
        this.iterator = this.iterator;
        this.servlet = null;
    }

    void setServlet(Servlet servlet) {
        this.servlet = servlet;
    }

    void setSupport(InstanceSupport support) {
        this.support = support;
    }
}

