/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.jsp.tagext.PageData;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.servlet.jsp.tagext.TagLibraryValidator;
import javax.servlet.jsp.tagext.TagVariableInfo;
import javax.servlet.jsp.tagext.ValidationMessage;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.TldLocationsCache;
import org.apache.jasper.parser.ParserUtils;
import org.apache.jasper.parser.TreeNode;

public class TagLibraryInfoImpl
extends TagLibraryInfo {
    private static final String TAGLIB_TLD = "META-INF/taglib.tld";
    private static final String WEB_XML = "/WEB-INF/web.xml";
    Hashtable jarEntries;
    JspCompilationContext ctxt;
    protected TagLibraryValidator tagLibraryValidator;
    static /* synthetic */ Class class$java$net$URLClassLoader;

    private final void print(String name, String value, PrintWriter w) {
        if (value != null) {
            w.print(name + " = {\n\t");
            w.print(value);
            w.print("\n}\n");
        }
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        this.print("tlibversion", this.tlibversion, out);
        this.print("jspversion", this.jspversion, out);
        this.print("shortname", this.shortname, out);
        this.print("urn", this.urn, out);
        this.print("info", this.info, out);
        this.print("uri", this.uri, out);
        this.print("tagLibraryValidator", this.tagLibraryValidator.toString(), out);
        int i = 0;
        while (i < this.tags.length) {
            out.println(this.tags[i].toString());
            ++i;
        }
        return sw.toString();
    }

    private InputStream getResourceAsStream(String uri) throws FileNotFoundException {
        try {
            String real = this.ctxt.getRealPath(uri);
            if (real == null) {
                return this.ctxt.getResourceAsStream(uri);
            }
            return new FileInputStream(real);
        }
        catch (FileNotFoundException ex) {
            return this.ctxt.getResourceAsStream(uri);
        }
    }

    public TagLibraryInfoImpl(JspCompilationContext ctxt, String prefix, String uriIn) throws JasperException {
        this(ctxt, prefix, uriIn, null);
    }

    public TagLibraryInfoImpl(JspCompilationContext ctxt, String prefix, String uriIn, String[] location) throws JasperException {
        block18: {
            super(prefix, uriIn);
            this.ctxt = ctxt;
            InputStream in = null;
            URL url = null;
            boolean relativeURL = false;
            if (location == null) {
                int uriType = TldLocationsCache.uriType(this.uri);
                if (uriType == 0) {
                    throw new JasperException(Constants.getString((String)"jsp.error.taglibDirective.absUriCannotBeResolved", (Object[])new Object[]{this.uri}));
                }
                if (uriType == 2) {
                    this.uri = ctxt.resolveRelativeUri(this.uri);
                }
                location = new String[2];
                location[0] = this.uri;
                if (this.uri.endsWith("jar")) {
                    location[1] = TAGLIB_TLD;
                }
            }
            if (!location[0].endsWith("jar")) {
                try {
                    in = this.getResourceAsStream(location[0]);
                    if (in == null) {
                        throw new FileNotFoundException(location[0]);
                    }
                }
                catch (FileNotFoundException ex) {
                    throw new JasperException(Constants.getString((String)"jsp.error.file.not.found", (Object[])new Object[]{location[0]}));
                }
                this.parseTLD(ctxt, location[0], in);
            } else {
                ZipFile jarFile = null;
                ZipEntry jarEntry = null;
                InputStream stream = null;
                try {
                    String path = location[0];
                    if (ctxt.getClassLoader() != null && (class$java$net$URLClassLoader == null ? (class$java$net$URLClassLoader = TagLibraryInfoImpl.class$("java.net.URLClassLoader")) : class$java$net$URLClassLoader).equals(ctxt.getClassLoader().getClass()) && path.startsWith("/")) {
                        path = path.substring(1, path.length());
                    }
                    if ((url = ctxt.getResource(path)) == null) {
                        return;
                    }
                    url = new URL("jar:" + url.toString() + "!/");
                    JarURLConnection conn = (JarURLConnection)url.openConnection();
                    conn.connect();
                    jarFile = conn.getJarFile();
                    jarEntry = ((JarFile)jarFile).getEntry(location[1]);
                    stream = ((JarFile)jarFile).getInputStream(jarEntry);
                    this.parseTLD(ctxt, location[0], stream);
                }
                catch (Exception ex) {
                    Constants.message((String)"jsp.error.taglib.jarFileException", (Object[])new Object[]{url.toString(), ex.getMessage()}, (int)1);
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    if (jarFile == null) break block18;
                    try {
                        jarFile.close();
                    }
                    catch (Throwable t) {}
                }
            }
        }
    }

    private boolean isRelativeURI(String uri) {
        return uri.indexOf(58) == -1;
    }

    private void parseTLD(JspCompilationContext ctxt, String uri, InputStream in) throws JasperException {
        Vector<TagInfo> tagVector = new Vector<TagInfo>();
        ClassLoader cl = ctxt.getClassLoader();
        ParserUtils pu = ParserUtils.createParserUtils(cl);
        TreeNode tld = pu.parseXMLDocument(uri, in);
        Iterator list = tld.findChildren();
        while (list.hasNext()) {
            TreeNode element = (TreeNode)list.next();
            String tname = element.getName();
            if ("tlibversion".equals(tname) || "tlib-version".equals(tname)) {
                this.tlibversion = element.getBody();
                continue;
            }
            if ("jspversion".equals(tname) || "jsp-version".equals(tname)) {
                this.jspversion = element.getBody();
                continue;
            }
            if ("shortname".equals(tname) || "short-name".equals(tname)) {
                this.shortname = element.getBody();
                continue;
            }
            if ("uri".equals(tname)) {
                this.urn = element.getBody();
                continue;
            }
            if ("info".equals(tname) || "description".equals(tname)) {
                this.info = element.getBody();
                continue;
            }
            if ("validator".equals(tname)) {
                this.tagLibraryValidator = this.createValidator(element);
                continue;
            }
            if ("tag".equals(tname)) {
                tagVector.addElement(this.createTagInfo(element));
                continue;
            }
            if ("display-name".equals(tname) || "small-icon".equals(tname) || "large-icon".equals(tname) || "listener".equals(tname)) continue;
            Constants.message((String)"jsp.warning.unknown.element.in.TLD", (Object[])new Object[]{tname}, (int)2);
        }
        this.tags = new TagInfo[tagVector.size()];
        tagVector.copyInto(this.tags);
    }

    private TagInfo createTagInfo(TreeNode elem) throws JasperException {
        String name = null;
        String tagclass = null;
        String teiclass = null;
        String bodycontent = "JSP";
        String info = null;
        String displayName = null;
        String smallIcon = null;
        String largeIcon = null;
        Vector<TagAttributeInfo> attributeVector = new Vector<TagAttributeInfo>();
        Vector<TagVariableInfo> variableVector = new Vector<TagVariableInfo>();
        Iterator list = elem.findChildren();
        while (list.hasNext()) {
            TreeNode element = (TreeNode)list.next();
            String tname = element.getName();
            if ("name".equals(tname)) {
                name = element.getBody();
                continue;
            }
            if ("tagclass".equals(tname) || "tag-class".equals(tname)) {
                tagclass = element.getBody();
                continue;
            }
            if ("teiclass".equals(tname) || "tei-class".equals(tname)) {
                teiclass = element.getBody();
                continue;
            }
            if ("bodycontent".equals(tname) || "body-content".equals(tname)) {
                bodycontent = element.getBody();
                continue;
            }
            if ("display-name".equals(tname)) {
                displayName = element.getBody();
                continue;
            }
            if ("small-icon".equals(tname)) {
                smallIcon = element.getBody();
                continue;
            }
            if ("large-icon".equals(tname)) {
                largeIcon = element.getBody();
                continue;
            }
            if ("info".equals(tname) || "description".equals(tname)) {
                info = element.getBody();
                continue;
            }
            if ("variable".equals(tname)) {
                variableVector.addElement(this.createVariable(element));
                continue;
            }
            if ("attribute".equals(tname)) {
                attributeVector.addElement(this.createAttribute(element));
                continue;
            }
            if ("example".equals(tname)) continue;
            Constants.message((String)"jsp.warning.unknown.element.in.tag", (Object[])new Object[]{tname}, (int)2);
        }
        Object[] tagAttributeInfo = new TagAttributeInfo[attributeVector.size()];
        attributeVector.copyInto(tagAttributeInfo);
        Object[] tagVariableInfos = new TagVariableInfo[variableVector.size()];
        variableVector.copyInto(tagVariableInfos);
        TagExtraInfo tei = null;
        if (teiclass != null && !teiclass.equals("")) {
            try {
                Class<?> teiClass = this.ctxt.getClassLoader().loadClass(teiclass);
                tei = (TagExtraInfo)teiClass.newInstance();
            }
            catch (ClassNotFoundException cex) {
                Constants.message((String)"jsp.warning.teiclass.is.null", (Object[])new Object[]{teiclass, cex.getMessage()}, (int)2);
            }
            catch (IllegalAccessException iae) {
                Constants.message((String)"jsp.warning.teiclass.is.null", (Object[])new Object[]{teiclass, iae.getMessage()}, (int)2);
            }
            catch (InstantiationException ie) {
                Constants.message((String)"jsp.warning.teiclass.is.null", (Object[])new Object[]{teiclass, ie.getMessage()}, (int)2);
            }
        }
        if (tei != null && variableVector.size() != 0) {
            throw new JasperException(Constants.getString((String)"jsp.warning.teiclass.is.nonnull", (Object[])new Object[]{teiclass}));
        }
        TagInfo taginfo = new TagInfo(name, tagclass, bodycontent, info, (TagLibraryInfo)this, tei, (TagAttributeInfo[])tagAttributeInfo, displayName, smallIcon, largeIcon, (TagVariableInfo[])tagVariableInfos);
        return taginfo;
    }

    TagAttributeInfo createAttribute(TreeNode elem) {
        String name = null;
        boolean required = false;
        boolean rtexprvalue = false;
        boolean reqTime = false;
        String type = null;
        Iterator list = elem.findChildren();
        while (list.hasNext()) {
            String s;
            TreeNode element = (TreeNode)list.next();
            String tname = element.getName();
            if ("name".equals(tname)) {
                name = element.getBody();
                continue;
            }
            if ("required".equals(tname)) {
                s = element.getBody();
                if (s == null) continue;
                required = JspUtil.booleanValue(s);
                continue;
            }
            if ("rtexprvalue".equals(tname)) {
                s = element.getBody();
                if (s == null) continue;
                rtexprvalue = JspUtil.booleanValue(s);
                continue;
            }
            if ("type".equals(tname)) {
                type = element.getBody();
                continue;
            }
            if ("description".equals(tname)) continue;
            Constants.message((String)"jsp.warning.unknown.element.in.attribute", (Object[])new Object[]{tname}, (int)2);
        }
        return new TagAttributeInfo(name, required, type, rtexprvalue);
    }

    TagVariableInfo createVariable(TreeNode elem) {
        String nameGiven = null;
        String nameFromAttribute = null;
        String className = "java.lang.String";
        boolean declare = true;
        int scope = 0;
        Iterator list = elem.findChildren();
        while (list.hasNext()) {
            String s;
            TreeNode element = (TreeNode)list.next();
            String tname = element.getName();
            if ("name-given".equals(tname)) {
                nameGiven = element.getBody();
                continue;
            }
            if ("name-from-attribute".equals(tname)) {
                nameFromAttribute = element.getBody();
                continue;
            }
            if ("variable-class".equals(tname)) {
                className = element.getBody();
                continue;
            }
            if ("declare".equals(tname)) {
                s = element.getBody();
                if (s == null) continue;
                declare = JspUtil.booleanValue(s);
                continue;
            }
            if ("scope".equals(tname)) {
                s = element.getBody();
                if (s == null) continue;
                if ("NESTED".equals(s)) {
                    scope = 0;
                    continue;
                }
                if ("AT_BEGIN".equals(s)) {
                    scope = 1;
                    continue;
                }
                if (!"AT_END".equals(s)) continue;
                scope = 2;
                continue;
            }
            if ("description".equals(tname)) continue;
            Constants.message((String)"jsp.warning.unknown.element.in.variable", (Object[])new Object[]{tname}, (int)2);
        }
        return new TagVariableInfo(nameGiven, nameFromAttribute, className, declare, scope);
    }

    private TagLibraryValidator createValidator(TreeNode elem) {
        String validatorClass = null;
        Hashtable<String, String> initParams = new Hashtable<String, String>();
        Iterator list = elem.findChildren();
        while (list.hasNext()) {
            TreeNode element = (TreeNode)list.next();
            String tname = element.getName();
            if ("validator-class".equals(tname)) {
                validatorClass = element.getBody();
                continue;
            }
            if ("init-param".equals(tname)) {
                String[] initParam = this.createInitParam(element);
                initParams.put(initParam[0], initParam[1]);
                continue;
            }
            if ("description".equals(tname)) continue;
            Constants.message((String)"jsp.warning.unknown.element.in.validator", (Object[])new Object[]{tname}, (int)2);
        }
        TagLibraryValidator tlv = null;
        if (validatorClass != null && !validatorClass.equals("")) {
            try {
                Class<?> tlvClass = this.ctxt.getClassLoader().loadClass(validatorClass);
                tlv = (TagLibraryValidator)tlvClass.newInstance();
            }
            catch (Exception ex) {
                Constants.message((String)"jsp.warning.tlvclass.is.null", (Object[])new Object[]{validatorClass, "EXCEPTION: " + ex.getMessage()}, (int)1);
            }
        }
        if (tlv != null) {
            tlv.setInitParameters(initParams);
        }
        return tlv;
    }

    String[] createInitParam(TreeNode elem) {
        String[] initParam = new String[2];
        Iterator list = elem.findChildren();
        while (list.hasNext()) {
            TreeNode element = (TreeNode)list.next();
            String tname = element.getName();
            if ("param-name".equals(tname)) {
                initParam[0] = element.getBody();
                continue;
            }
            if ("param-value".equals(tname)) {
                initParam[1] = element.getBody();
                continue;
            }
            if ("description".equals(tname)) continue;
            Constants.message((String)"jsp.warning.unknown.element.in.initParam", (Object[])new Object[]{tname}, (int)2);
        }
        return initParam;
    }

    /*
     * WARNING - void declaration
     */
    static void copy(InputStream in, String fileName) throws IOException, FileNotFoundException {
        int nRead;
        byte[] buf = new byte[1024];
        FileOutputStream out = new FileOutputStream(fileName);
        while ((nRead = in.read(buf, 0, buf.length)) != -1) {
            void var4_4;
            out.write(buf, 0, (int)var4_4);
        }
    }

    public TagLibraryValidator getTagLibraryValidator() {
        return this.tagLibraryValidator;
    }

    public ValidationMessage[] validate(PageData thePage) {
        TagLibraryValidator tlv = this.getTagLibraryValidator();
        if (tlv == null) {
            return null;
        }
        return tlv.validate(this.getPrefixString(), this.getURI(), thePage);
    }

    private void p(String s) {
        System.out.println("[TagLibraryInfoImpl] " + s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

