/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.deploy;

import org.apache.catalina.util.RequestUtil;

public final class SecurityCollection {
    private String description = null;
    private String[] methods = new String[0];
    private String name = null;
    private String[] patterns = new String[0];

    public SecurityCollection() {
        this(null, null);
    }

    public SecurityCollection(String name) {
        this(name, null);
    }

    public SecurityCollection(String name, String description) {
        this.setName(name);
        this.setDescription(description);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addMethod(String method) {
        if (method == null) {
            return;
        }
        String[] results = new String[this.methods.length + 1];
        int i = 0;
        while (i < this.methods.length) {
            results[i] = this.methods[i];
            ++i;
        }
        results[this.methods.length] = method;
        this.methods = results;
    }

    public void addPattern(String pattern) {
        if (pattern == null) {
            return;
        }
        pattern = RequestUtil.URLDecode(pattern);
        String[] results = new String[this.patterns.length + 1];
        int i = 0;
        while (i < this.patterns.length) {
            results[i] = this.patterns[i];
            ++i;
        }
        results[this.patterns.length] = pattern;
        this.patterns = results;
    }

    public boolean findMethod(String method) {
        if (this.methods.length == 0) {
            return true;
        }
        int i = 0;
        while (i < this.methods.length) {
            if (this.methods[i].equals(method)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String[] findMethods() {
        return this.methods;
    }

    public boolean findPattern(String pattern) {
        int i = 0;
        while (i < this.patterns.length) {
            if (this.patterns[i].equals(pattern)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String[] findPatterns() {
        return this.patterns;
    }

    public void removeMethod(String method) {
        if (method == null) {
            return;
        }
        int n = -1;
        int i = 0;
        while (i < this.methods.length) {
            if (this.methods[i].equals(method)) {
                n = i;
                break;
            }
            ++i;
        }
        if (n >= 0) {
            int j = 0;
            String[] results = new String[this.methods.length - 1];
            int i2 = 0;
            while (i2 < this.methods.length) {
                if (i2 != n) {
                    results[j++] = this.methods[i2];
                }
                ++i2;
            }
            this.methods = results;
        }
    }

    public void removePattern(String pattern) {
        if (pattern == null) {
            return;
        }
        int n = -1;
        int i = 0;
        while (i < this.patterns.length) {
            if (this.patterns[i].equals(pattern)) {
                n = i;
                break;
            }
            ++i;
        }
        if (n >= 0) {
            int j = 0;
            String[] results = new String[this.patterns.length - 1];
            int i2 = 0;
            while (i2 < this.patterns.length) {
                if (i2 != n) {
                    results[j++] = this.patterns[i2];
                }
                ++i2;
            }
            this.patterns = results;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SecurityCollection[");
        sb.append(this.name);
        if (this.description != null) {
            sb.append(", ");
            sb.append(this.description);
        }
        sb.append("]");
        return sb.toString();
    }
}

