/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Service;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.DefaultContext;
import org.apache.catalina.core.StandardEngineValve;

public class StandardEngine
extends ContainerBase
implements Engine {
    private String defaultHost = null;
    private static final String info = "org.apache.catalina.core.StandardEngine/1.0";
    private String mapperClass = "org.apache.catalina.core.StandardEngineMapper";
    private Service service = null;
    private DefaultContext defaultContext;
    private String jvmRouteId;

    public StandardEngine() {
        this.pipeline.setBasic(new StandardEngineValve());
    }

    public String getDefaultHost() {
        return this.defaultHost;
    }

    public void setDefaultHost(String host) {
        String oldDefaultHost = this.defaultHost;
        this.defaultHost = host.toLowerCase();
        this.support.firePropertyChange("defaultHost", oldDefaultHost, this.defaultHost);
    }

    public void addDefaultContext(DefaultContext defaultContext) {
        DefaultContext oldDefaultContext = this.defaultContext;
        this.defaultContext = defaultContext;
        this.support.firePropertyChange("defaultContext", oldDefaultContext, this.defaultContext);
    }

    public void setJvmRoute(String jvmRouteId) {
        String oldJvmRouteId = this.jvmRouteId;
        this.jvmRouteId = jvmRouteId;
        this.support.firePropertyChange("jvmRouteId", oldJvmRouteId, this.jvmRouteId);
    }

    public String getJvmRoute() {
        return this.jvmRouteId;
    }

    public String getMapperClass() {
        return this.mapperClass;
    }

    public void setMapperClass(String mapperClass) {
        String oldMapperClass = this.mapperClass;
        this.mapperClass = mapperClass;
        this.support.firePropertyChange("mapperClass", oldMapperClass, this.mapperClass);
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public void importDefaultContext(Context context) {
        if (this.defaultContext != null) {
            this.defaultContext.importDefaultContext(context);
        }
    }

    public void addChild(Container child) {
        if (!(child instanceof Host)) {
            throw new IllegalArgumentException(ContainerBase.sm.getString("standardEngine.notHost"));
        }
        super.addChild(child);
    }

    public String getInfo() {
        return info;
    }

    public void setParent(Container container) {
        throw new IllegalArgumentException(ContainerBase.sm.getString("standardEngine.notParent"));
    }

    public void start() throws LifecycleException {
        System.out.println("Apache Tomcat/4.0.5");
        super.start();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("StandardEngine[");
        sb.append(this.getName());
        sb.append("]");
        return sb.toString();
    }

    protected void addDefaultMapper(String mapperClass) {
        super.addDefaultMapper(this.mapperClass);
    }

    static {
        info = info;
    }
}

