/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUtils;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Logger;
import org.apache.catalina.connector.HttpResponseFacade;
import org.apache.catalina.connector.ResponseBase;
import org.apache.catalina.util.CookieTools;
import org.apache.catalina.util.URL;

public class HttpResponseBase
extends ResponseBase
implements HttpResponse,
HttpServletResponse {
    protected ArrayList cookies = new ArrayList();
    protected final SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    protected HttpResponseFacade facade = new HttpResponseFacade(this);
    protected HashMap headers = new HashMap();
    protected static final String info = "org.apache.catalina.connector.HttpResponseBase/1.0";
    protected String message = this.getStatusMessage(200);
    protected int status = 200;
    protected static final TimeZone zone;

    public HttpResponseBase() {
        this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public ServletResponse getResponse() {
        return this.facade;
    }

    public void finishResponse() throws IOException {
        if (!this.isCommitted() && this.stream == null && this.writer == null && this.status >= 400 && this.contentType == null && this.contentCount == 0) {
            try {
                this.setContentType("text/html");
                PrintWriter writer = this.getWriter();
                writer.println("<html>");
                writer.println("<head>");
                writer.println("<title>Tomcat Error Report</title>");
                writer.println("<br><br>");
                writer.println("<h1>HTTP Status ");
                writer.print(this.status);
                writer.print(" - ");
                if (this.message != null) {
                    writer.print(this.message);
                } else {
                    writer.print(this.getStatusMessage(this.status));
                }
                writer.println("</h1>");
                writer.println("</body>");
                writer.println("</html>");
            }
            catch (IOException e) {
                throw e;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.sendHeaders();
        super.finishResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cookie[] getCookies() {
        ArrayList arrayList = this.cookies;
        synchronized (arrayList) {
            Cookie[] cookieArray = this.cookies.toArray(new Cookie[this.cookies.size()]);
            return cookieArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHeader(String name) {
        ArrayList values = null;
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            values = (ArrayList)this.headers.get(name);
        }
        if (values != null) {
            return (String)values.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getHeaderNames() {
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            String[] results = new String[this.headers.size()];
            String[] stringArray = this.headers.keySet().toArray(results);
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getHeaderValues(String name) {
        ArrayList values = null;
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            values = (ArrayList)this.headers.get(name);
        }
        if (values == null) {
            return new String[0];
        }
        String[] results = new String[values.size()];
        return values.toArray(results);
    }

    public String getMessage() {
        return this.message;
    }

    public int getStatus() {
        return this.status;
    }

    public void recycle() {
        super.recycle();
        this.cookies.clear();
        this.headers.clear();
        this.message = this.getStatusMessage(200);
        this.status = 200;
    }

    public void reset(int status, String message) {
        this.reset();
        this.setStatus(status, message);
    }

    protected String getStatusMessage(int status) {
        switch (status) {
            case 200: {
                return "OK";
            }
            case 202: {
                return "Accepted";
            }
            case 502: {
                return "Bad Gateway";
            }
            case 400: {
                return "Bad Request";
            }
            case 409: {
                return "Conflict";
            }
            case 100: {
                return "Continue";
            }
            case 201: {
                return "Created";
            }
            case 417: {
                return "Expectation Failed";
            }
            case 403: {
                return "Forbidden";
            }
            case 504: {
                return "Gateway Timeout";
            }
            case 410: {
                return "Gone";
            }
            case 505: {
                return "HTTP Version Not Supported";
            }
            case 500: {
                return "Internal Server Error";
            }
            case 411: {
                return "Length Required";
            }
            case 405: {
                return "Method Not Allowed";
            }
            case 301: {
                return "Moved Permanently";
            }
            case 302: {
                return "Moved Temporarily";
            }
            case 300: {
                return "Multiple Choices";
            }
            case 204: {
                return "No Content";
            }
            case 203: {
                return "Non-Authoritative Information";
            }
            case 406: {
                return "Not Acceptable";
            }
            case 404: {
                return "Not Found";
            }
            case 501: {
                return "Not Implemented";
            }
            case 304: {
                return "Not Modified";
            }
            case 206: {
                return "Partial Content";
            }
            case 402: {
                return "Payment Required";
            }
            case 412: {
                return "Precondition Failed";
            }
            case 407: {
                return "Proxy Authentication Required";
            }
            case 413: {
                return "Request Entity Too Large";
            }
            case 408: {
                return "Request Timeout";
            }
            case 414: {
                return "Request URI Too Long";
            }
            case 416: {
                return "Requested Range Not Satisfiable";
            }
            case 205: {
                return "Reset Content";
            }
            case 303: {
                return "See Other";
            }
            case 503: {
                return "Service Unavailable";
            }
            case 101: {
                return "Switching Protocols";
            }
            case 401: {
                return "Unauthorized";
            }
            case 415: {
                return "Unsupported Media Type";
            }
            case 305: {
                return "Use Proxy";
            }
            case 207: {
                return "Multi-Status";
            }
            case 422: {
                return "Unprocessable Entity";
            }
            case 423: {
                return "Locked";
            }
            case 507: {
                return "Insufficient Storage";
            }
        }
        return "HTTP Response Status " + status;
    }

    private boolean isEncodeable(String location) {
        int urlPort;
        if (location == null) {
            return false;
        }
        if (location.startsWith("#")) {
            return false;
        }
        HttpServletRequest hreq = (HttpServletRequest)this.request.getRequest();
        HttpSession session = hreq.getSession(false);
        if (session == null) {
            return false;
        }
        if (hreq.isRequestedSessionIdFromCookie()) {
            return false;
        }
        URL url = null;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException e) {
            return false;
        }
        if (!hreq.getScheme().equalsIgnoreCase(url.getProtocol())) {
            return false;
        }
        if (!hreq.getServerName().equalsIgnoreCase(url.getHost())) {
            return false;
        }
        int serverPort = hreq.getServerPort();
        if (serverPort == -1) {
            serverPort = "https".equals(hreq.getScheme()) ? 443 : 80;
        }
        if ((urlPort = url.getPort()) == -1) {
            urlPort = "https".equals(url.getProtocol()) ? 443 : 80;
        }
        if (serverPort != urlPort) {
            return false;
        }
        String contextPath = this.getContext().getPath();
        if (contextPath != null && contextPath.length() > 0) {
            String file = url.getFile();
            if (file == null || !file.startsWith(contextPath)) {
                return false;
            }
            if (file.indexOf(";jsessionid=" + session.getId()) >= 0) {
                return false;
            }
        }
        return true;
    }

    private void log(String message) {
        Logger logger = this.context.getLogger();
        logger.log(message);
    }

    private void log(String message, Throwable throwable) {
        Logger logger = this.context.getLogger();
        logger.log(message, throwable);
    }

    protected String getProtocol() {
        return this.request.getRequest().getProtocol();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendHeaders() throws IOException {
        Iterator items;
        if (this.isCommitted()) {
            return;
        }
        if ("HTTP/0.9".equals(this.request.getRequest().getProtocol())) {
            this.committed = true;
            return;
        }
        OutputStreamWriter osr = null;
        try {
            osr = new OutputStreamWriter(this.getStream(), this.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException e) {
            osr = new OutputStreamWriter(this.getStream());
        }
        PrintWriter outputWriter = new PrintWriter(osr);
        outputWriter.print(this.getProtocol());
        outputWriter.print(" ");
        outputWriter.print(this.status);
        if (this.message != null) {
            outputWriter.print(" ");
            outputWriter.print(this.message);
        }
        outputWriter.print("\r\n");
        if (this.getContentType() != null) {
            outputWriter.print("Content-Type: " + this.getContentType() + "\r\n");
        }
        if (this.getContentLength() >= 0) {
            outputWriter.print("Content-Length: " + this.getContentLength() + "\r\n");
        }
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            Iterator names = this.headers.keySet().iterator();
            while (names.hasNext()) {
                String name = (String)names.next();
                ArrayList values = (ArrayList)this.headers.get(name);
                items = values.iterator();
                while (items.hasNext()) {
                    String value = (String)items.next();
                    outputWriter.print(name);
                    outputWriter.print(": ");
                    outputWriter.print(value);
                    outputWriter.print("\r\n");
                }
            }
        }
        HttpServletRequest hreq = (HttpServletRequest)this.request.getRequest();
        HttpSession session = hreq.getSession(false);
        if (session != null && session.isNew() && this.getContext() != null && this.getContext().getCookies()) {
            Cookie cookie = new Cookie("JSESSIONID", session.getId());
            cookie.setMaxAge(-1);
            String contextPath = null;
            if (this.context != null) {
                contextPath = this.context.getPath();
            }
            if (contextPath != null && contextPath.length() > 0) {
                cookie.setPath(contextPath);
            } else {
                cookie.setPath("/");
            }
            if (hreq.isSecure()) {
                cookie.setSecure(true);
            }
            this.addCookie(cookie);
        }
        ArrayList arrayList = this.cookies;
        synchronized (arrayList) {
            items = this.cookies.iterator();
            while (items.hasNext()) {
                Cookie cookie = (Cookie)items.next();
                outputWriter.print(CookieTools.getCookieHeaderName(cookie));
                outputWriter.print(": ");
                outputWriter.print(CookieTools.getCookieHeaderValue(cookie));
                outputWriter.print("\r\n");
            }
        }
        outputWriter.print("\r\n");
        outputWriter.flush();
        this.committed = true;
    }

    private String toAbsolute(String location) {
        if (location == null) {
            return location;
        }
        URL url = null;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException e1) {
            HttpServletRequest hreq = (HttpServletRequest)this.request.getRequest();
            String requrl = HttpUtils.getRequestURL((HttpServletRequest)hreq).toString();
            try {
                url = new URL(new URL(requrl), location);
            }
            catch (MalformedURLException e2) {
                throw new IllegalArgumentException(location);
            }
        }
        return url.toExternalForm();
    }

    private String toEncoded(String url, String sessionId) {
        StringBuffer sb;
        int pound;
        if (url == null || sessionId == null) {
            return url;
        }
        String path = url;
        String query = "";
        String anchor = "";
        int question = url.indexOf(63);
        if (question >= 0) {
            path = url.substring(0, question);
            query = url.substring(question);
        }
        if ((pound = path.indexOf(35)) >= 0) {
            anchor = path.substring(pound);
            path = path.substring(0, pound);
        }
        if ((sb = new StringBuffer(path)).length() > 0) {
            sb.append(";jsessionid=");
            sb.append(sessionId);
        }
        sb.append(anchor);
        sb.append(query);
        return sb.toString();
    }

    public void flushBuffer() throws IOException {
        if (!this.isCommitted()) {
            this.sendHeaders();
        }
        super.flushBuffer();
    }

    public void reset() {
        if (this.included) {
            return;
        }
        super.reset();
        this.cookies.clear();
        this.headers.clear();
        this.message = null;
        this.status = 200;
    }

    public void setContentLength(int length) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        super.setContentLength(length);
    }

    public void setContentType(String type) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        super.setContentType(type);
    }

    public void setLocale(Locale locale) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        super.setLocale(locale);
        String language = locale.getLanguage();
        if (language != null && language.length() > 0) {
            String country = locale.getCountry();
            StringBuffer value = new StringBuffer(language);
            if (country != null && country.length() > 0) {
                value.append('-');
                value.append(country);
            }
            this.setHeader("Content-Language", value.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCookie(Cookie cookie) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        ArrayList arrayList = this.cookies;
        synchronized (arrayList) {
            this.cookies.add(cookie);
        }
    }

    public void addDateHeader(String name, long value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.addHeader(name, this.format.format(new Date(value)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHeader(String name, String value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            ArrayList<String> values = (ArrayList<String>)this.headers.get(name);
            if (values == null) {
                values = new ArrayList<String>();
                this.headers.put(name, values);
            }
            values.add(value);
        }
    }

    public void addIntHeader(String name, int value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.addHeader(name, "" + value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsHeader(String name) {
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            boolean bl = this.headers.get(name) != null;
            return bl;
        }
    }

    public String encodeRedirectURL(String url) {
        if (this.isEncodeable(this.toAbsolute(url))) {
            HttpServletRequest hreq = (HttpServletRequest)this.request.getRequest();
            return this.toEncoded(url, hreq.getSession().getId());
        }
        return url;
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public String encodeURL(String url) {
        if (this.isEncodeable(this.toAbsolute(url))) {
            HttpServletRequest hreq = (HttpServletRequest)this.request.getRequest();
            return this.toEncoded(url, hreq.getSession().getId());
        }
        return url;
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public void sendError(int status) throws IOException {
        this.sendError(status, this.getStatusMessage(status));
    }

    public void sendError(int status, String message) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException(ResponseBase.sm.getString("httpResponseBase.sendError.ise"));
        }
        if (this.included) {
            return;
        }
        this.setError();
        this.status = status;
        this.message = message;
        this.resetBuffer();
        this.setSuspended(true);
    }

    public void sendRedirect(String location) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException(ResponseBase.sm.getString("httpResponseBase.sendRedirect.ise"));
        }
        if (this.included) {
            return;
        }
        this.resetBuffer();
        try {
            String absolute = this.toAbsolute(location);
            this.setStatus(302);
            this.setHeader("Location", absolute);
        }
        catch (IllegalArgumentException e) {
            this.setStatus(404);
        }
        this.setSuspended(true);
    }

    public void setDateHeader(String name, long value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.setHeader(name, this.format.format(new Date(value)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeader(String name, String value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            this.headers.put(name, values);
        }
        String match = name.toLowerCase();
        if (match.equals("content-length")) {
            int contentLength = -1;
            try {
                contentLength = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (contentLength >= 0) {
                this.setContentLength(contentLength);
            }
        } else if (match.equals("content-type")) {
            this.setContentType(value);
        }
    }

    public void setIntHeader(String name, int value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.setHeader(name, "" + value);
    }

    public void setStatus(int status) {
        this.setStatus(status, this.getStatusMessage(status));
    }

    public void setStatus(int status, String message) {
        if (this.included) {
            return;
        }
        this.status = status;
        this.message = message;
    }

    static {
        info = info;
        zone = TimeZone.getTimeZone("GMT");
    }
}

