/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming;

import javax.naming.Reference;
import javax.naming.StringRefAddr;

public class EjbRef
extends Reference {
    public static final String DEFAULT_FACTORY = "org.apache.naming.factory.EjbFactory";
    public static final String TYPE = "type";
    public static final String REMOTE = "remote";
    public static final String LINK = "link";

    public EjbRef(String ejbType, String home, String remote, String link) {
        this(ejbType, home, remote, link, null, null);
    }

    public EjbRef(String ejbType, String home, String remote, String link, String factory, String factoryLocation) {
        super(home, factory, factoryLocation);
        StringRefAddr refAddr = null;
        if (ejbType != null) {
            refAddr = new StringRefAddr(TYPE, ejbType);
            this.add(refAddr);
        }
        if (remote != null) {
            refAddr = new StringRefAddr(REMOTE, remote);
            this.add(refAddr);
        }
        if (link != null) {
            refAddr = new StringRefAddr(LINK, link);
            this.add(refAddr);
        }
    }

    public String getFactoryClassName() {
        String factory = super.getFactoryClassName();
        if (factory != null) {
            return factory;
        }
        factory = System.getProperty("java.naming.factory.object");
        if (factory != null) {
            return null;
        }
        return DEFAULT_FACTORY;
    }

    static {
        DEFAULT_FACTORY = DEFAULT_FACTORY;
        TYPE = TYPE;
        REMOTE = REMOTE;
        LINK = LINK;
    }
}

