/*
 * Decompiled with CFR 0.152.
 */
package tyrex.tm;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import tyrex.client.RemoteUserTransaction;
import tyrex.tm.TransactionDomain;
import tyrex.tm.TransactionImpl;

public class RemoteUserTransactionImpl
extends UnicastRemoteObject
implements RemoteUserTransaction {
    private TransactionDomain _txDomain;

    public RemoteUserTransactionImpl(TransactionDomain transactionDomain) throws RemoteException {
        if (transactionDomain == null) {
            throw new IllegalArgumentException("Argument 'txDomain' is null");
        }
        this._txDomain = transactionDomain;
    }

    public byte[] begin() throws SystemException {
        return this._txDomain.createTransaction(null, null).getXid().getGlobalTransactionId();
    }

    public void commit(byte[] byArray) throws RollbackException, HeuristicMixedException, HeuristicRollbackException, IllegalStateException, SystemException {
        TransactionImpl transactionImpl;
        try {
            transactionImpl = this._txDomain.getTransaction(byArray);
        }
        catch (InvalidTransactionException invalidTransactionException) {
            throw new SystemException(((RemoteException)((Object)invalidTransactionException)).getMessage());
        }
        this._txDomain.enlistThread(transactionImpl, Thread.currentThread());
        try {
            transactionImpl.commit();
        }
        finally {
            Object var4_5 = null;
            this._txDomain.delistThread(transactionImpl, Thread.currentThread());
        }
    }

    public int getStatus(byte[] byArray) throws SystemException {
        TransactionImpl transactionImpl;
        try {
            transactionImpl = this._txDomain.getTransaction(byArray);
        }
        catch (InvalidTransactionException invalidTransactionException) {
            throw new SystemException(((RemoteException)((Object)invalidTransactionException)).getMessage());
        }
        if (transactionImpl == null) {
            return 6;
        }
        return transactionImpl.getStatus();
    }

    public void rollback(byte[] byArray) throws IllegalStateException, SystemException {
        TransactionImpl transactionImpl;
        try {
            transactionImpl = this._txDomain.getTransaction(byArray);
        }
        catch (InvalidTransactionException invalidTransactionException) {
            throw new SystemException(((RemoteException)((Object)invalidTransactionException)).getMessage());
        }
        this._txDomain.enlistThread(transactionImpl, Thread.currentThread());
        try {
            transactionImpl.rollback();
        }
        finally {
            Object var4_5 = null;
            this._txDomain.delistThread(transactionImpl, Thread.currentThread());
        }
    }

    public void setRollbackOnly(byte[] byArray) throws IllegalStateException, SystemException {
        TransactionImpl transactionImpl;
        try {
            transactionImpl = this._txDomain.getTransaction(byArray);
        }
        catch (InvalidTransactionException invalidTransactionException) {
            throw new SystemException(((RemoteException)((Object)invalidTransactionException)).getMessage());
        }
        transactionImpl.setRollbackOnly();
    }

    public void setTransactionTimeout(byte[] byArray, int n) throws SystemException {
        TransactionImpl transactionImpl;
        try {
            transactionImpl = this._txDomain.getTransaction(byArray);
        }
        catch (InvalidTransactionException invalidTransactionException) {
            throw new SystemException(((RemoteException)((Object)invalidTransactionException)).getMessage());
        }
        if (transactionImpl != null) {
            this._txDomain.setTransactionTimeout(transactionImpl, n);
        }
    }
}

