/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.warp;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.catalina.connector.HttpResponseBase;
import org.apache.catalina.connector.warp.WarpConnection;
import org.apache.catalina.connector.warp.WarpPacket;
import org.apache.catalina.util.CookieTools;

public class WarpResponse
extends HttpResponseBase {
    private Stream localstream = new Stream(this);
    private WarpPacket packet;
    private WarpConnection connection;

    public WarpResponse() {
        this.setStream(this.localstream);
    }

    public void recycle() {
        super.recycle();
        this.localstream.recycle();
        this.setStream(this.localstream);
    }

    public void setPacket(WarpPacket packet) {
        this.packet = packet;
    }

    public WarpPacket getPacket() {
        return this.packet;
    }

    public void setConnection(WarpConnection connection) {
        this.connection = connection;
    }

    public WarpConnection getConnection() {
        return this.connection;
    }

    public void finishResponse() throws IOException {
        super.finishResponse();
        this.localstream.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendHeaders() throws IOException {
        Iterator items;
        if (this.isCommitted()) {
            return;
        }
        if ("HTTP/0.9".equals(this.request.getRequest().getProtocol())) {
            this.committed = true;
            return;
        }
        this.packet.reset();
        this.packet.setType(32);
        this.packet.writeUnsignedShort(this.status);
        this.packet.writeString(this.message);
        this.connection.send(this.packet);
        if (this.getContentType() != null) {
            this.packet.reset();
            this.packet.setType(33);
            this.packet.writeString("Content-Type");
            this.packet.writeString(this.getContentType());
            this.connection.send(this.packet);
        }
        if (this.getContentLength() >= 0) {
            this.packet.reset();
            this.packet.setType(33);
            this.packet.writeString("Content-Length");
            this.packet.writeString(Integer.toString(this.getContentLength()));
            this.connection.send(this.packet);
        }
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            Iterator names = this.headers.keySet().iterator();
            while (names.hasNext()) {
                String name = (String)names.next();
                ArrayList values = (ArrayList)this.headers.get(name);
                items = values.iterator();
                while (items.hasNext()) {
                    String value = (String)items.next();
                    this.packet.reset();
                    this.packet.setType(33);
                    this.packet.writeString(name);
                    this.packet.writeString(value);
                    this.connection.send(this.packet);
                }
            }
        }
        HttpServletRequest hreq = (HttpServletRequest)this.request.getRequest();
        HttpSession session = hreq.getSession(false);
        if (session != null && session.isNew() && this.getContext() != null && this.getContext().getCookies()) {
            Cookie cookie = new Cookie("JSESSIONID", session.getId());
            cookie.setMaxAge(-1);
            String contextPath = null;
            if (this.context != null) {
                contextPath = this.context.getPath();
            }
            if (contextPath != null && contextPath.length() > 0) {
                cookie.setPath(contextPath);
            } else {
                cookie.setPath("/");
            }
            if (hreq.isSecure()) {
                cookie.setSecure(true);
            }
            this.addCookie(cookie);
        }
        ArrayList arrayList = this.cookies;
        synchronized (arrayList) {
            items = this.cookies.iterator();
            while (items.hasNext()) {
                Cookie cookie = (Cookie)items.next();
                String name = CookieTools.getCookieHeaderName((Cookie)cookie);
                StringBuffer value = new StringBuffer();
                CookieTools.getCookieHeaderValue((Cookie)cookie, (StringBuffer)value);
                this.packet.reset();
                this.packet.setType(33);
                this.packet.writeString(name);
                this.packet.writeString(value.toString());
                this.connection.send(this.packet);
            }
        }
        this.packet.reset();
        this.packet.setType(47);
        this.connection.send(this.packet);
        this.committed = true;
    }

    protected class Stream
    extends OutputStream {
        private WarpResponse response = null;
        private WarpPacket packet = null;
        private boolean closed = false;

        protected Stream(WarpResponse response) {
            this.response = response;
            this.packet = new WarpPacket();
        }

        public void write(int b) throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            if (this.packet.size >= this.packet.buffer.length) {
                this.flush();
            }
            this.packet.buffer[this.packet.size++] = (byte)b;
        }

        public void flush() throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            this.packet.setType(48);
            this.response.getConnection().send(this.packet);
            this.packet.reset();
        }

        public void close() throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            this.flush();
            this.packet.setType(63);
            this.response.getConnection().send(this.packet);
            this.packet.reset();
        }

        public void finish() throws IOException {
            if (this.closed) {
                return;
            }
            this.close();
        }

        public void recycle() {
            this.packet.reset();
            this.closed = false;
        }
    }
}

