/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.warp;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeMap;
import javax.servlet.http.Cookie;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.connector.warp.WarpConnection;
import org.apache.catalina.connector.warp.WarpConnector;
import org.apache.catalina.connector.warp.WarpLogger;
import org.apache.catalina.connector.warp.WarpPacket;
import org.apache.catalina.connector.warp.WarpRequest;
import org.apache.catalina.connector.warp.WarpResponse;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.StringParser;

public class WarpRequestHandler {
    private StringParser parser = new StringParser();
    private static final String match = ";jsessionid=";

    public boolean handle(WarpConnection connection, WarpPacket packet) throws IOException {
        WarpLogger logger = new WarpLogger(this);
        WarpConnector connector = connection.getConnector();
        logger.setContainer(connector.getContainer());
        WarpRequest request = new WarpRequest();
        WarpResponse response = new WarpResponse();
        response.setRequest((Request)request);
        response.setConnection(connection);
        response.setPacket(packet);
        request.setConnection(connection);
        packet.reset();
        packet.setType(15);
        connection.send(packet);
        block12: while (true) {
            connection.recv(packet);
            switch (packet.getType()) {
                case 16: {
                    int id = packet.readInteger();
                    String meth = packet.readString();
                    String ruri = packet.readString();
                    String args = packet.readString();
                    String prot = packet.readString();
                    request.recycle();
                    response.recycle();
                    response.setRequest((Request)request);
                    response.setConnection(connection);
                    response.setPacket(packet);
                    request.setMethod(meth);
                    this.processUri(logger, request, ruri);
                    if (args.length() > 0) {
                        request.setQueryString(args);
                    } else {
                        request.setQueryString(null);
                    }
                    request.setProtocol(prot);
                    request.setConnection(connection);
                    Context ctx = connector.applicationContext(id);
                    if (ctx == null) continue block12;
                    request.setContext(ctx);
                    request.setContextPath(ctx.getPath());
                    request.setHost((Host)ctx.getParent());
                    continue block12;
                }
                case 17: {
                    String ctyp = packet.readString();
                    int clen = packet.readInteger();
                    if (ctyp.length() > 0) {
                        request.setContentType(ctyp);
                    }
                    if (clen <= 0) continue block12;
                    request.setContentLength(clen);
                    continue block12;
                }
                case 18: {
                    String schm = packet.readString();
                    request.setScheme(schm);
                    if (!schm.equals("https")) continue block12;
                    request.setSecure(true);
                    continue block12;
                }
                case 19: {
                    String user = packet.readString();
                    String auth = packet.readString();
                    request.setAuthType(auth);
                    if (user == null || auth == null || !auth.equals("Basic")) continue block12;
                    BasicPrincipal prin = new BasicPrincipal(user);
                    request.setUserPrincipal(prin);
                    continue block12;
                }
                case 20: {
                    String hnam = packet.readString();
                    String hval = packet.readString();
                    this.processHeader(logger, request, hnam, hval);
                    continue block12;
                }
                case 21: {
                    String host = packet.readString();
                    String addr = packet.readString();
                    int port = packet.readUnsignedShort();
                    request.setServerName(host);
                    request.setServerPort(port);
                    continue block12;
                }
                case 22: {
                    String host = packet.readString();
                    String addr = packet.readString();
                    int port = packet.readUnsignedShort();
                    request.setRemoteHost(host);
                    request.setRemoteAddr(addr);
                    continue block12;
                }
                case 31: {
                    try {
                        connector.getContainer().invoke((Request)request, (Response)response);
                    }
                    catch (Exception e) {
                        logger.log(e);
                    }
                    request.finishRequest();
                    response.finishResponse();
                    continue block12;
                }
            }
            break;
        }
        String msg = "Invalid packet " + packet.getType();
        logger.log(msg);
        packet.reset();
        packet.setType(255);
        packet.writeString(msg);
        connection.send(packet);
        return false;
    }

    private void processUri(WarpLogger logger, WarpRequest req, String uri) {
        int semicolon = uri.indexOf(match);
        if (semicolon >= 0) {
            String rest = uri.substring(semicolon + match.length());
            int semicolon2 = rest.indexOf(59);
            if (semicolon2 >= 0) {
                req.setRequestedSessionId(rest.substring(0, semicolon2));
                rest = rest.substring(semicolon2);
            } else {
                req.setRequestedSessionId(rest);
                rest = "";
            }
            req.setRequestedSessionURL(true);
            uri = uri.substring(0, semicolon) + rest;
        } else {
            req.setRequestedSessionId(null);
            req.setRequestedSessionURL(false);
        }
        req.setRequestURI(uri);
    }

    private void processHeader(WarpLogger logger, WarpRequest req, String name, String value) {
        if ("cookie".equalsIgnoreCase(name)) {
            Cookie[] cookies = RequestUtil.parseCookieHeader((String)value);
            int i = 0;
            while (i < cookies.length) {
                if (cookies[i].getName().equals("JSESSIONID") && !req.isRequestedSessionIdFromCookie()) {
                    req.setRequestedSessionId(cookies[i].getValue());
                    req.setRequestedSessionCookie(true);
                    req.setRequestedSessionURL(false);
                }
                req.addCookie(cookies[i]);
                ++i;
            }
        }
        if (name.equalsIgnoreCase("Accept-Language")) {
            this.parseAcceptLanguage(logger, req, value);
        }
        if (name.equalsIgnoreCase("Authorization")) {
            req.setAuthorization(value);
        }
        req.addHeader(name, value);
    }

    private void parseAcceptLanguage(WarpLogger logger, WarpRequest request, String value) {
        int start;
        TreeMap<Double, ArrayList<Locale>> locales = new TreeMap<Double, ArrayList<Locale>>();
        int white = value.indexOf(32);
        if (white < 0) {
            white = value.indexOf(9);
        }
        if (white >= 0) {
            StringBuffer sb = new StringBuffer();
            int len = value.length();
            int i = 0;
            while (i < len) {
                char ch = value.charAt(i);
                if (ch != ' ' && ch != '\t') {
                    sb.append(ch);
                }
                ++i;
            }
            value = sb.toString();
        }
        this.parser.setString(value);
        int length = this.parser.getLength();
        while ((start = this.parser.getIndex()) < length) {
            int end = this.parser.findChar(',');
            String entry = this.parser.extract(start, end).trim();
            this.parser.advance();
            double quality = 1.0;
            int semi = entry.indexOf(";q=");
            if (semi >= 0) {
                try {
                    quality = Double.parseDouble(entry.substring(semi + 3));
                }
                catch (NumberFormatException e) {
                    quality = 0.0;
                }
                entry = entry.substring(0, semi);
            }
            if (quality < 5.0E-5 || "*".equals(entry)) continue;
            String language = null;
            String country = null;
            int dash = entry.indexOf(45);
            if (dash < 0) {
                language = entry;
                country = "";
            } else {
                language = entry.substring(0, dash);
                country = entry.substring(dash + 1);
            }
            Locale locale = new Locale(language, country);
            Double key = new Double(-quality);
            ArrayList<Locale> values = (ArrayList<Locale>)locales.get(key);
            if (values == null) {
                values = new ArrayList<Locale>();
                locales.put(key, values);
            }
            values.add(locale);
        }
        Iterator keys = locales.keySet().iterator();
        while (keys.hasNext()) {
            Double key = (Double)keys.next();
            ArrayList list = (ArrayList)locales.get(key);
            Iterator values = list.iterator();
            while (values.hasNext()) {
                Locale locale = (Locale)values.next();
                request.addLocale(locale);
            }
        }
    }

    static {
        match = match;
    }

    class BasicPrincipal
    implements Principal {
        private String user;

        BasicPrincipal(String user) {
            this.user = user;
        }

        public boolean equals(Object another) {
            return another instanceof Principal && ((Principal)another).getName().equals(this.user);
        }

        public String getName() {
            return this.user;
        }

        public String toString() {
            return this.getName();
        }
    }
}

