/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.warp;

import java.io.IOException;
import java.io.InputStream;
import org.apache.catalina.Host;
import org.apache.catalina.connector.HttpRequestBase;
import org.apache.catalina.connector.warp.WarpCertificates;
import org.apache.catalina.connector.warp.WarpConnection;
import org.apache.catalina.connector.warp.WarpPacket;
import org.apache.catalina.connector.warp.WarpSSLData;

public class WarpRequest
extends HttpRequestBase {
    private Stream localstream = new Stream(this);
    private WarpConnection connection;
    private Host host = null;

    public WarpRequest() {
        this.setStream(this.localstream);
    }

    public Object getAttribute(String name) {
        Object object = super.getAttribute(name);
        if (object != null) {
            return object;
        }
        if (!this.localstream.request.isSecure()) {
            return null;
        }
        if (name.equals("javax.servlet.request.X509Certificate")) {
            WarpCertificates cert = null;
            try {
                cert = new WarpCertificates(this.localstream.getX509Certificates());
            }
            catch (IOException e) {
                return null;
            }
            super.setAttribute("javax.servlet.request.X509Certificate", (Object)cert.getCertificates());
        }
        if (name.equals("javax.servlet.request.cipher_suite") || name.equals("javax.servlet.request.key_size") || name.equals("javax.servlet.request.ssl_session")) {
            WarpSSLData ssldata = null;
            try {
                ssldata = this.localstream.getSSL();
            }
            catch (IOException e) {
                return null;
            }
            if (ssldata == null) {
                return null;
            }
            super.setAttribute("javax.servlet.request.cipher_suite", (Object)ssldata.ciph);
            if (ssldata.size != 0) {
                super.setAttribute("javax.servlet.request.key_size", (Object)new Integer(ssldata.size));
            }
            super.setAttribute("javax.servlet.request.ssl_session", (Object)ssldata.sess);
        }
        return super.getAttribute(name);
    }

    public void setHost(Host host) {
        this.host = host;
    }

    public Host getHost() {
        return this.host;
    }

    public void recycle() {
        super.recycle();
        this.localstream.recycle();
        this.setStream(this.localstream);
    }

    public void setConnection(WarpConnection connection) {
        this.connection = connection;
    }

    public WarpConnection getConnection() {
        return this.connection;
    }

    protected class Stream
    extends InputStream {
        private WarpRequest request = null;
        private WarpPacket packet = null;
        private boolean closed = false;

        protected Stream(WarpRequest request) {
            this.request = request;
            this.packet = new WarpPacket();
            this.packet.setType(65);
        }

        public int read() throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            if (this.packet.pointer < this.packet.size) {
                return this.packet.buffer[this.packet.pointer++] & 0xFF;
            }
            this.packet.reset();
            this.packet.setType(64);
            this.packet.writeUnsignedShort(65535);
            this.request.getConnection().send(this.packet);
            this.packet.reset();
            this.request.getConnection().recv(this.packet);
            if (this.packet.getType() == 66) {
                return -1;
            }
            if (this.packet.getType() != 65) {
                throw new IOException("Invalid WARP packet type for body");
            }
            return this.read();
        }

        public String getX509Certificates() throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            this.packet.reset();
            this.packet.setType(68);
            this.request.getConnection().send(this.packet);
            this.packet.reset();
            this.request.getConnection().recv(this.packet);
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            if (this.packet.getType() == 95) {
                return null;
            }
            if (this.packet.getType() != 82) {
                throw new IOException("Invalid WARP packet type for CC");
            }
            return this.packet.readString();
        }

        public WarpSSLData getSSL() throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            this.packet.reset();
            this.packet.setType(67);
            this.request.getConnection().send(this.packet);
            this.packet.reset();
            this.request.getConnection().recv(this.packet);
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            if (this.packet.getType() == 95) {
                return null;
            }
            if (this.packet.getType() != 83) {
                throw new IOException("Invalid WARP packet type for SSL data");
            }
            WarpSSLData ssldata = new WarpSSLData();
            ssldata.ciph = this.packet.readString();
            ssldata.sess = this.packet.readString();
            ssldata.size = this.packet.readInteger();
            return ssldata;
        }

        public void close() throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            this.packet.reset();
            this.packet.setType(66);
            this.closed = true;
        }

        public void recycle() {
            this.packet.reset();
            this.packet.setType(65);
            this.closed = false;
        }
    }
}

