/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.warp;

import java.io.UnsupportedEncodingException;

public class WarpPacket {
    protected byte[] buffer = new byte[65535];
    protected int size = 0;
    protected int pointer = 0;
    private int type = -1;
    private static final int MAX_LENGTH = 65535;

    public WarpPacket() {
        this.reset();
    }

    public void reset() {
        this.pointer = 0;
        this.size = 0;
        this.type = -1;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void writeUnsignedShort(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Negative unsigned short");
        }
        if (value > 65535) {
            throw new IllegalArgumentException("Unsigned short is too big");
        }
        if (this.size + 2 >= 65535) {
            throw new ArrayIndexOutOfBoundsException("Too much data");
        }
        this.buffer[this.size++] = (byte)(value >> 8 & 0xFF);
        this.buffer[this.size++] = (byte)(value >> 0 & 0xFF);
    }

    public void writeInteger(int value) {
        if (this.size + 4 >= 65535) {
            throw new ArrayIndexOutOfBoundsException("Too much data");
        }
        this.buffer[this.size++] = (byte)(value >> 24 & 0xFF);
        this.buffer[this.size++] = (byte)(value >> 16 & 0xFF);
        this.buffer[this.size++] = (byte)(value >> 8 & 0xFF);
        this.buffer[this.size++] = (byte)(value >> 0 & 0xFF);
    }

    public void writeString(String string) {
        try {
            byte[] temp;
            if (string == null) {
                string = "";
            }
            if (this.size + (temp = string.getBytes("UTF-8")).length + 2 > 65535) {
                throw new ArrayIndexOutOfBoundsException("Too much data");
            }
            this.writeUnsignedShort(temp.length);
            System.arraycopy(temp, 0, this.buffer, this.size, temp.length);
            this.size += temp.length;
        }
        catch (UnsupportedEncodingException s) {
            throw new RuntimeException("Unsupported encoding UTF-8");
        }
    }

    public int readUnsignedShort() {
        if (this.pointer + 2 > this.size) {
            throw new ArrayIndexOutOfBoundsException("No data available");
        }
        int k = this.buffer[this.pointer++] & 0xFF;
        k = (k << 8) + (this.buffer[this.pointer++] & 0xFF);
        return k;
    }

    public int readInteger() {
        if (this.pointer + 4 > this.size) {
            throw new ArrayIndexOutOfBoundsException("No data available");
        }
        int k = this.buffer[this.pointer++] & 0xFF;
        k = (k << 8) + (this.buffer[this.pointer++] & 0xFF);
        k = (k << 8) + (this.buffer[this.pointer++] & 0xFF);
        k = (k << 8) + (this.buffer[this.pointer++] & 0xFF);
        return k;
    }

    public String readString() {
        int length = this.readUnsignedShort();
        try {
            String ret = new String(this.buffer, this.pointer, length, "UTF-8");
            this.pointer += length;
            return ret;
        }
        catch (UnsupportedEncodingException s) {
            throw new RuntimeException("Unsupported encoding UTF-8");
        }
    }

    public String dump() {
        StringBuffer buf = new StringBuffer("DATA=");
        int x = 0;
        while (x < this.size) {
            if (this.buffer[x] > 32 && this.buffer[x] < 127) {
                buf.append((char)this.buffer[x]);
            } else {
                buf.append("0x");
                String digit = Integer.toHexString(this.buffer[x]);
                if (digit.length() < 2) {
                    buf.append('0');
                }
                if (digit.length() > 2) {
                    digit = digit.substring(digit.length() - 2);
                }
                buf.append(digit);
            }
            buf.append(" ");
            ++x;
        }
        return buf.toString();
    }

    static {
        MAX_LENGTH = 65535;
    }
}

