/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.collections;

public final class SimplePool {
    private Object[] pool;
    private int max;
    private int last;
    private int current = -1;
    private Object lock;
    public static final int DEFAULT_SIZE = 32;
    static final int debug = 0;

    public SimplePool() {
        this(32, 32);
    }

    public SimplePool(int size) {
        this(size, size);
    }

    public SimplePool(int size, int max) {
        this.max = max;
        this.pool = new Object[size];
        this.last = size - 1;
        this.lock = new Object();
    }

    public void set(Object o) {
        this.put(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object o) {
        Object object = this.lock;
        synchronized (object) {
            if (this.current < this.last) {
                ++this.current;
                this.pool[this.current] = o;
            } else if (this.current < this.max) {
                int newSize = this.pool.length * 2;
                if (newSize > this.max) {
                    newSize = this.max + 1;
                }
                Object[] tmp = new Object[newSize];
                this.last = newSize - 1;
                System.arraycopy(this.pool, 0, tmp, 0, this.pool.length);
                this.pool = tmp;
                ++this.current;
                this.pool[this.current] = o;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get() {
        Object item = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.current >= 0) {
                item = this.pool[this.current];
                this.pool[this.current] = null;
                --this.current;
            }
        }
        return item;
    }

    public int getMax() {
        return this.max;
    }

    public int getCount() {
        return this.current + 1;
    }

    public void shutdown() {
    }

    private void log(String s) {
        System.out.println("SimplePool: " + s);
    }

    static {
        DEFAULT_SIZE = 32;
        debug = 0;
    }
}

