/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ajp.tomcat4.config;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import org.apache.ajp.tomcat4.config.BaseJkConfig;
import org.apache.catalina.Context;

public class IISConfig
extends BaseJkConfig {
    public static final String WORKERS_CONFIG = "/conf/jk/workers.properties";
    public static final String URI_WORKERS_MAP_CONFIG = "/conf/auto/uriworkermap.properties";
    public static final String ISAPI_LOG_LOCATION = "/logs/iis_redirect.log";
    public static final String ISAPI_REG_FILE = "/conf/auto/iis_redirect.reg";
    private File regConfig = null;
    private File uriConfig = null;

    protected boolean addMapping(String fullPath, PrintWriter uri_worker) {
        if (this.debug > 0) {
            this.log("Adding map for " + fullPath);
        }
        uri_worker.println(String.valueOf(fullPath) + "=$(default.worker)");
        return true;
    }

    protected boolean addMapping(String ctxPath, String ext, PrintWriter uri_worker) {
        if (this.debug > 0) {
            this.log("Adding extension map for " + ctxPath + "/*." + ext);
        }
        if (!ext.startsWith("/")) {
            ext = "/" + ext;
        }
        if (ext.length() > 1) {
            uri_worker.println(String.valueOf(ctxPath) + "/*." + ext + "=$(default.worker)");
        }
        return true;
    }

    private String dubleSlash(String in) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < in.length()) {
            char ch = in.charAt(i);
            if (ch == '\\') {
                sb.append("\\\\");
            } else {
                sb.append(ch);
            }
            ++i;
        }
        return sb.toString();
    }

    protected void generateContextMappings(Context context, PrintWriter uri_worker) {
        String loginPage;
        String nPath;
        String ctxPath = context.getPath();
        String string = nPath = "".equals(ctxPath) ? "/" : ctxPath;
        if (this.noRoot && "".equals(ctxPath)) {
            this.log("Ignoring root context in forward-all mode  ");
            return;
        }
        uri_worker.println();
        uri_worker.println("#########################################################");
        uri_worker.println("# Auto configuration for the " + nPath + " context.");
        uri_worker.println("#########################################################");
        uri_worker.println();
        if (context.getLoginConfig() != null && (loginPage = context.getLoginConfig().getLoginPage()) != null) {
            int lpos = loginPage.lastIndexOf("/");
            String jscurl = String.valueOf(loginPage.substring(0, lpos + 1)) + "j_security_check";
            this.addMapping(ctxPath, jscurl, uri_worker);
        }
        String[] servletMaps = context.findServletMappings();
        int ii = 0;
        while (ii < servletMaps.length) {
            this.addMapping(ctxPath, servletMaps[ii], uri_worker);
            ++ii;
        }
    }

    protected boolean generateJkHead(PrintWriter mod_jk) {
        try {
            PrintWriter regfile = new PrintWriter(new FileWriter(this.regConfig));
            this.log("Generating IIS registry file = " + this.regConfig);
            this.generateRegistrySettings(regfile);
            regfile.close();
        }
        catch (IOException iOException) {
            this.log("Unable to generate registry file " + this.regConfig);
            return false;
        }
        this.log("Generating IIS URI worker map file = " + this.uriConfig);
        this.generateUriWorkerHeader(mod_jk);
        return true;
    }

    private void generateRegistrySettings(PrintWriter regfile) {
        regfile.println("REGEDIT4");
        regfile.println();
        regfile.println("[HKEY_LOCAL_MACHINE\\SOFTWARE\\Apache Software Foundation\\Jakarta Isapi Redirector\\1.0]");
        regfile.println("\"extension_uri\"=\"/jakarta/isapi_redirect.dll\"");
        regfile.println("\"log_file\"=\"" + this.dubleSlash(this.jkLog.toString()) + "\"");
        regfile.println("\"log_level\"=\"" + this.jkDebug + "\"");
        regfile.println("\"worker_file\"=\"" + this.dubleSlash(this.workersConfig.toString()) + "\"");
        regfile.println("\"worker_mount_file\"=\"" + this.dubleSlash(this.uriConfig.toString()) + "\"");
    }

    protected void generateStupidMappings(Context context, PrintWriter uri_worker) {
        String nPath;
        String ctxPath = context.getPath();
        String string = nPath = "".equals(ctxPath) ? "/" : ctxPath;
        if (this.noRoot && "".equals(ctxPath)) {
            this.log("Ignoring root context in forward-all mode  ");
            return;
        }
        uri_worker.println(String.valueOf(nPath) + "=$(default.worker)");
        if ("".equals(ctxPath)) {
            uri_worker.println(String.valueOf(nPath) + "*=$(default.worker)");
            uri_worker.println("# Note: To correctly serve the Tomcat's root context, IIS's Home Directory must");
            uri_worker.println("# must be set to: \"" + this.getAbsoluteDocBase(context) + "\"");
        } else {
            uri_worker.println(String.valueOf(nPath) + "/*=$(default.worker)");
        }
    }

    private void generateUriWorkerHeader(PrintWriter uri_worker) {
        uri_worker.println("###################################################################");
        uri_worker.println("# Auto generated configuration. Dated: " + new Date());
        uri_worker.println("###################################################################");
        uri_worker.println();
        uri_worker.println("#");
        uri_worker.println("# Default worker to be used through our mappings");
        uri_worker.println("#");
        uri_worker.println("default.worker=" + this.jkWorker);
        uri_worker.println();
    }

    protected PrintWriter getWriter() throws IOException {
        String abUriConfig = this.uriConfig.getAbsolutePath();
        return new PrintWriter(new FileWriter(abUriConfig, this.append));
    }

    protected void initProperties() {
        super.initProperties();
        this.regConfig = BaseJkConfig.getConfigFile(this.regConfig, this.configHome, ISAPI_REG_FILE);
        this.workersConfig = BaseJkConfig.getConfigFile(this.workersConfig, this.configHome, WORKERS_CONFIG);
        this.uriConfig = BaseJkConfig.getConfigFile(this.uriConfig, this.configHome, URI_WORKERS_MAP_CONFIG);
        this.jkLog = BaseJkConfig.getConfigFile(this.jkLog, this.configHome, ISAPI_LOG_LOCATION);
    }

    public void setRegConfig(String path) {
        this.regConfig = path == null ? null : new File(path);
    }

    public void setUriConfig(String path) {
        this.uriConfig = path == null ? null : new File(path);
    }
}

