/*
 * Decompiled with CFR 0.152.
 */
package tyrex.naming;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.spi.NamingManager;
import tyrex.naming.MemoryBinding;
import tyrex.naming.MemoryBindingEnumeration;
import tyrex.naming.MemoryContextFactory;

public class MemoryContext
implements Context {
    public static final String ReadOnly = "readOnly";
    public static final String NameSeparator = "/";
    public static final NameParser DefaultNameParser = new NameParser(){

        public Name parse(String string) throws NamingException {
            return new CompositeName(string);
        }
    };
    private final MemoryBinding _bindings;
    private final Hashtable _env = new Hashtable();
    private boolean _readOnly;

    public MemoryContext(Hashtable hashtable) throws NamingException {
        if (hashtable != null) {
            this._bindings = hashtable.get("java.naming.provider.url") != null ? MemoryContextFactory.getBindings(hashtable.get("java.naming.provider.url").toString()) : new MemoryBinding();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.addToEnvironment(string, hashtable.get(string));
            }
        } else {
            this._bindings = new MemoryBinding();
        }
    }

    MemoryContext(MemoryBinding memoryBinding, Hashtable hashtable) throws NamingException {
        this._bindings = memoryBinding;
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.addToEnvironment(string, hashtable.get(string));
            }
        }
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        if (string.equals(ReadOnly)) {
            boolean bl = object.toString().equalsIgnoreCase("true");
            if (this._readOnly && !bl) {
                throw new OperationNotSupportedException("Context is read-only");
            }
            this._readOnly = bl;
        }
        return this._env.put(string, object);
    }

    public void bind(String string, Object object) throws NamingException {
        this.bind(new CompositeName(string), object);
    }

    public void bind(Name name, Object object) throws NamingException {
        if (this._readOnly) {
            throw new OperationNotSupportedException("Context is read-only");
        }
        if (object instanceof MemoryContext) {
            object = ((MemoryContext)object)._bindings;
        }
        while (!name.isEmpty() && name.get(0).length() == 0) {
            name = name.getSuffix(1);
        }
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        String string = name.get(0);
        MemoryBinding memoryBinding = this._bindings;
        while (name.size() > 1) {
            Object object2 = memoryBinding.get(string);
            if (object2 instanceof Context) {
                ((Context)object2).bind(name.getSuffix(1), object);
                return;
            }
            if (!(object2 instanceof MemoryBinding)) {
                throw new NotContextException(String.valueOf(string) + " is not a subcontext");
            }
            memoryBinding = (MemoryBinding)object2;
            name = name.getSuffix(1);
            string = name.get(0);
        }
        MemoryBinding memoryBinding2 = memoryBinding;
        synchronized (memoryBinding2) {
            if (memoryBinding.get(string) != null) {
                throw new NameAlreadyBoundException(String.valueOf(string) + " already bound, use rebind instead");
            }
            if (object instanceof Referenceable) {
                object = ((Referenceable)object).getReference();
            }
            memoryBinding.put(string, object);
        }
    }

    public void close() {
        this._env.clear();
    }

    public String composeName(String string, String string2) {
        return String.valueOf(string2) + NameSeparator + string;
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        name2 = (Name)name2.clone();
        return name2.addAll(name);
    }

    public Context createSubcontext(String string) throws NamingException {
        return this.createSubcontext(new CompositeName(string));
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Context createSubcontext(Name var1_1) throws NamingException {
        if (!this._readOnly) ** GOTO lbl4
        throw new OperationNotSupportedException("Context is read-only");
lbl-1000:
        // 1 sources

        {
            var1_1 = var1_1.getSuffix(1);
lbl4:
            // 2 sources

            ** while (!var1_1.isEmpty() && var1_1.get((int)0).length() == 0)
        }
lbl5:
        // 1 sources

        if (var1_1.isEmpty()) {
            throw new InvalidNameException("Subcontext name is empty");
        }
        var3_2 = var1_1.get(0);
        var4_3 = this._bindings;
        while (var1_1.size() > 1) {
            var2_4 = var4_3.get(var3_2);
            if (var2_4 instanceof Context) {
                return ((Context)var2_4).createSubcontext(var1_1.getSuffix(1));
            }
            if (var2_4 instanceof MemoryBinding == false) throw new NotContextException(String.valueOf(var3_2) + " is not a subcontext");
            var4_3 = (MemoryBinding)var2_4;
            var1_1 = var1_1.getSuffix(1);
            var3_2 = var1_1.get(0);
        }
        var7_5 = var4_3;
        synchronized (var7_5) {
            var2_4 = var4_3.get(var3_2);
            if (var2_4 != null) {
                if (var2_4 instanceof Context) {
                    return (Context)((Context)var2_4).lookup("");
                }
                if (var2_4 instanceof MemoryBinding == false) throw new NameAlreadyBoundException(String.valueOf(var3_2) + " already bound");
                return new MemoryContext((MemoryBinding)var2_4, this._env);
            }
            var5_12 = new MemoryBinding();
            var4_3.put(var3_2, var5_12);
            return new MemoryContext(var5_12, this._env);
        }
    }

    void debug(PrintWriter printWriter) {
        this._bindings.debug(printWriter);
    }

    public void destroySubcontext(String string) throws NamingException {
        this.destroySubcontext(new CompositeName(string));
    }

    /*
     * Unable to fully structure code
     */
    public void destroySubcontext(Name var1_1) throws NamingException {
        if (!this._readOnly) ** GOTO lbl4
        throw new OperationNotSupportedException("Context is read-only");
lbl-1000:
        // 1 sources

        {
            var1_1 = var1_1.getSuffix(1);
lbl4:
            // 2 sources

            ** while (!var1_1.isEmpty() && var1_1.get((int)0).length() == 0)
        }
lbl5:
        // 1 sources

        if (var1_1.isEmpty()) {
            throw new InvalidNameException("Subcontext name is empty");
        }
        var3_2 = var1_1.get(0);
        var4_3 = this._bindings;
        while (var1_1.size() > 1) {
            var2_4 = var4_3.get(var3_2);
            if (var2_4 instanceof Context) {
                ((Context)var2_4).destroySubcontext(var1_1.getSuffix(1));
                return;
            }
            if (!(var2_4 instanceof MemoryBinding)) {
                throw new NotContextException(String.valueOf(var3_2) + " is not a subcontext");
            }
            var4_3 = (MemoryBinding)var2_4;
            var1_1 = var1_1.getSuffix(1);
            var3_2 = var1_1.get(0);
        }
        var5_5 = var4_3;
        synchronized (var5_5) {
            var2_4 = var4_3.get(var3_2);
            if (var2_4 == null) {
                var6_6 = null;
                return;
            }
            if (var2_4 instanceof MemoryBinding) {
                if (!((MemoryBinding)var2_4).isEmpty()) {
                    throw new ContextNotEmptyException(String.valueOf(var3_2) + " is not empty, cannot destroy");
                }
                ((MemoryBinding)var2_4).destroy();
                var4_3.remove(var3_2);
            } else if (var2_4 instanceof Context) {
                ((Context)var2_4).close();
                var4_3.remove(var3_2);
            } else {
                throw new NotContextException(String.valueOf(var3_2) + " is not a subcontext");
            }
        }
    }

    MemoryBinding getBindings() {
        return this._bindings;
    }

    public Hashtable getEnvironment() {
        return this._env;
    }

    public String getNameInNamespace() throws NamingException {
        return this._bindings.getName();
    }

    public NameParser getNameParser(String string) throws NamingException {
        if (string.length() == 0) {
            return DefaultNameParser;
        }
        return this.getNameParser(new CompositeName(string));
    }

    public NameParser getNameParser(Name name) throws NamingException {
        while (!name.isEmpty() && name.get(0).length() == 0) {
            name = name.getSuffix(1);
        }
        if (name.isEmpty()) {
            return DefaultNameParser;
        }
        String string = name.get(0);
        MemoryBinding memoryBinding = this._bindings;
        while (name.size() > 1) {
            Object object = memoryBinding.get(string);
            if (object instanceof Context) {
                return ((Context)object).getNameParser(name.getSuffix(1));
            }
            if (!(object instanceof MemoryBinding)) {
                throw new NotContextException(String.valueOf(string) + " is not a subcontext");
            }
            memoryBinding = (MemoryBinding)object;
            name = name.getSuffix(1);
            string = name.get(0);
        }
        return DefaultNameParser;
    }

    private Object internalLookup(Name name, boolean bl) throws NamingException {
        Object object;
        MemoryBinding memoryBinding;
        block11: {
            String string;
            memoryBinding = this._bindings;
            while (true) {
                if (!name.isEmpty() && name.get(0).length() == 0) {
                    name = name.getSuffix(1);
                    continue;
                }
                if (name.isEmpty()) {
                    return new MemoryContext(memoryBinding, this._env);
                }
                String string2 = name.get(0);
                if (name.size() > 1) {
                    object = memoryBinding.get(string2);
                    if (object instanceof Context) {
                        return ((Context)object).lookup(name.getSuffix(1));
                    }
                    if (!(object instanceof MemoryBinding)) {
                        throw new NotContextException(String.valueOf(string2) + " is not a subcontext");
                    }
                    memoryBinding = (MemoryBinding)object;
                    name = name.getSuffix(1);
                    continue;
                }
                object = memoryBinding.get(string2);
                if (object == null) {
                    throw new NameNotFoundException(String.valueOf(string2) + " not found");
                }
                if (!(object instanceof LinkRef) || !bl) break block11;
                string = ((LinkRef)object).getLinkName();
                if (!string.startsWith(".")) break;
                name = new CompositeName(string.substring(1));
            }
            return NamingManager.getInitialContext(this._env).lookup(string);
        }
        if (object instanceof MemoryBinding) {
            return new MemoryContext((MemoryBinding)object, this._env);
        }
        if (object instanceof Reference) {
            try {
                return NamingManager.getObjectInstance(object, name, new MemoryContext(memoryBinding, this._env), this._env);
            }
            catch (Exception exception) {
                throw new NamingException(exception.getMessage());
            }
        }
        return object;
    }

    public NamingEnumeration list(String string) throws NamingException {
        if (string.length() == 0) {
            return new MemoryBindingEnumeration(this._bindings, true, this);
        }
        return this.list(new CompositeName(string));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        Object object;
        while (!name.isEmpty() && name.get(0).length() == 0) {
            name = name.getSuffix(1);
        }
        if (name.isEmpty()) {
            return new MemoryBindingEnumeration(this._bindings, true, this);
        }
        String string = name.get(0);
        MemoryBinding memoryBinding = this._bindings;
        while (name.size() > 1) {
            object = memoryBinding.get(string);
            if (object instanceof Context) {
                return ((Context)object).list(name.getSuffix(1));
            }
            if (!(object instanceof MemoryBinding)) {
                throw new NotContextException(String.valueOf(string) + " is not a subcontext");
            }
            memoryBinding = (MemoryBinding)object;
            name = name.getSuffix(1);
            string = name.get(0);
        }
        if (string.length() == 0) {
            return new MemoryBindingEnumeration(memoryBinding, true, this);
        }
        object = memoryBinding.get(string);
        if (object instanceof Context) {
            return ((Context)object).list("");
        }
        if (object instanceof MemoryBinding) {
            return new MemoryBindingEnumeration((MemoryBinding)object, true, this);
        }
        throw new NotContextException(String.valueOf(string) + " is not a subcontext");
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        if (string.length() == 0) {
            return new MemoryBindingEnumeration(this._bindings, false, this);
        }
        return this.listBindings(new CompositeName(string));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        Object object;
        while (!name.isEmpty() && name.get(0).length() == 0) {
            name = name.getSuffix(1);
        }
        if (name.isEmpty()) {
            return new MemoryBindingEnumeration(this._bindings, false, this);
        }
        String string = name.get(0);
        MemoryBinding memoryBinding = this._bindings;
        while (name.size() > 1) {
            object = memoryBinding.get(string);
            if (object instanceof Context) {
                return ((Context)object).listBindings(name.getSuffix(1));
            }
            if (!(object instanceof MemoryBinding)) {
                throw new NotContextException(String.valueOf(string) + " is not a subcontext");
            }
            memoryBinding = (MemoryBinding)object;
            name = name.getSuffix(1);
            string = name.get(0);
        }
        if (string.length() == 0) {
            return new MemoryBindingEnumeration(memoryBinding, false, this);
        }
        object = memoryBinding.get(string);
        if (object instanceof Context) {
            return ((Context)object).listBindings("");
        }
        if (object instanceof MemoryBinding) {
            return new MemoryBindingEnumeration((MemoryBinding)object, false, this);
        }
        throw new NotContextException(String.valueOf(string) + " is not a subcontext");
    }

    public Object lookup(String string) throws NamingException {
        Object object = this._bindings.get(string);
        if (object != null) {
            if (object instanceof LinkRef) {
                String string2 = ((LinkRef)object).getLinkName();
                if (string2.startsWith(".")) {
                    return this.lookup(string2.substring(1));
                }
                return NamingManager.getInitialContext(this._env).lookup(string2);
            }
            if (object instanceof MemoryBinding) {
                return new MemoryContext((MemoryBinding)object, this._env);
            }
            if (object instanceof Reference) {
                try {
                    return NamingManager.getObjectInstance(object, new CompositeName(string), this, this._env);
                }
                catch (Exception exception) {
                    throw new NamingException(exception.toString());
                }
            }
            return object;
        }
        return this.internalLookup(new CompositeName(string), true);
    }

    public Object lookup(Name name) throws NamingException {
        return this.internalLookup(name, true);
    }

    public Object lookupLink(String string) throws NamingException {
        return this.internalLookup(new CompositeName(string), false);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.internalLookup(name, false);
    }

    public void rebind(String string, Object object) throws NamingException {
        this.rebind(new CompositeName(string), object);
    }

    public void rebind(Name name, Object object) throws NamingException {
        if (this._readOnly) {
            throw new OperationNotSupportedException("Context is read-only");
        }
        if (object instanceof MemoryContext) {
            object = ((MemoryContext)object)._bindings;
        }
        while (!name.isEmpty() && name.get(0).length() == 0) {
            name = name.getSuffix(1);
        }
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot rebind empty name");
        }
        String string = name.get(0);
        MemoryBinding memoryBinding = this._bindings;
        while (name.size() > 1) {
            Object object2 = memoryBinding.get(string);
            if (object2 instanceof Context) {
                ((Context)object2).rebind(name.getSuffix(1), object);
                return;
            }
            if (!(object2 instanceof MemoryBinding)) {
                throw new NotContextException(String.valueOf(string) + " is not a subcontext");
            }
            memoryBinding = (MemoryBinding)object2;
            name = name.getSuffix(1);
            string = name.get(0);
        }
        MemoryBinding memoryBinding2 = memoryBinding;
        synchronized (memoryBinding2) {
            if (object instanceof Referenceable) {
                object = ((Referenceable)object).getReference();
            }
            memoryBinding.put(string, object);
        }
    }

    public Object removeFromEnvironment(String string) {
        return this._env.remove(string);
    }

    public void rename(String string, String string2) throws NamingException {
        this.rename(new CompositeName(string), new CompositeName(string2));
    }

    /*
     * Unable to fully structure code
     */
    public void rename(Name var1_1, Name var2_2) throws NamingException {
        if (!this._readOnly) ** GOTO lbl4
        throw new OperationNotSupportedException("Context is read-only");
lbl-1000:
        // 1 sources

        {
            var1_1 = var1_1.getSuffix(1);
lbl4:
            // 2 sources

            ** while (!var1_1.isEmpty() && var1_1.get((int)0).length() == 0)
        }
lbl5:
        // 2 sources

        while (!var2_2.isEmpty() && var2_2.get(0).length() == 0) {
            var2_2 = var2_2.getSuffix(1);
        }
        if (var1_1.isEmpty() || var2_2.isEmpty()) {
            throw new InvalidNameException("Cannot rename empty name");
        }
        var3_3 = var2_2.get(0);
        var4_4 = this._bindings;
        while (var2_2.size() > 1) {
            var5_5 = var4_4.get(var3_3);
            if (var5_5 instanceof Context) {
                ((Context)var5_5).rename(var2_2.getSuffix(1), var1_1);
                return;
            }
            if (!(var5_5 instanceof MemoryBinding)) {
                throw new NotContextException(String.valueOf(var3_3) + " is not a subcontext");
            }
            var4_4 = (MemoryBinding)var5_5;
            var2_2 = var2_2.getSuffix(1);
            var3_3 = var2_2.get(0);
        }
        var6_6 = var4_4;
        synchronized (var6_6) {
            if (var4_4.get(var3_3) != null) {
                throw new NameAlreadyBoundException(String.valueOf(var3_3) + " already bound, use rebind to override");
            }
            if (var1_1.size() == 1) {
                var5_5 = var4_4.remove(var1_1.get(0));
                if (var5_5 == null) {
                    throw new NameNotFoundException(String.valueOf(var1_1.get(0)) + " not found");
                }
            } else {
                var5_5 = this.lookup(var1_1);
                this.unbind(var1_1);
            }
            var4_4.put(var3_3, var5_5);
        }
    }

    public String toString() {
        if (this._readOnly) {
            return String.valueOf(this._bindings.getName()) + " (read-only)";
        }
        return this._bindings.getName();
    }

    public void unbind(String string) throws NamingException {
        this.unbind(new CompositeName(string));
    }

    /*
     * Unable to fully structure code
     */
    public void unbind(Name var1_1) throws NamingException {
        if (!this._readOnly) ** GOTO lbl4
        throw new OperationNotSupportedException("Context is read-only");
lbl-1000:
        // 1 sources

        {
            var1_1 = var1_1.getSuffix(1);
lbl4:
            // 2 sources

            ** while (!var1_1.isEmpty() && var1_1.get((int)0).length() == 0)
        }
lbl5:
        // 1 sources

        if (var1_1.isEmpty()) {
            throw new InvalidNameException("Cannot unbind empty name");
        }
        var3_2 = var1_1.get(0);
        var4_3 = this._bindings;
        while (var1_1.size() > 1) {
            var2_4 = var4_3.get(var3_2);
            if (var2_4 instanceof Context) {
                ((Context)var2_4).unbind(var1_1.getSuffix(1));
                return;
            }
            if (!(var2_4 instanceof MemoryBinding)) {
                throw new NotContextException(String.valueOf(var3_2) + " is not a subcontext");
            }
            var4_3 = (MemoryBinding)var2_4;
            var1_1 = var1_1.getSuffix(1);
            var3_2 = var1_1.get(0);
        }
        var5_5 = var4_3;
        synchronized (var5_5) {
            var4_3.remove(var3_2);
        }
    }
}

