/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.factory;

import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.sql.XADataSource;
import org.apache.naming.ResourceRef;
import tyrex.jdbc.ServerDataSource;
import tyrex.jdbc.xa.EnabledDataSource;

public class TyrexDataSourceFactory
implements ObjectFactory {
    public static final String LOGIN_TIMEOUT = "loginTimeout";
    public static final String DESCRIPTION = "description";
    public static final String DATA_SOURCE = "dataSource";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String DRIVER_NAME = "driverName";
    public static final String DRIVER_CLASS_NAME = "driverClassName";
    public static final String DEFAULT_DRIVER_NAME = "jdbc:HypersonicSQL:.";
    public static final String DEFAULT_DRIVER_CLASS_NAME = "org.hsql.jdbcDriver";
    public static final String DEFAULT_USER = "sa";
    public static final String DEFAULT_PASSWORD = "";

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws NamingException {
        if (obj instanceof ResourceRef) {
            Reference ref = (Reference)obj;
            if (ref.getClassName().equals("javax.sql.DataSource") || ref.getClassName().equals("tyrex.jdbc.ServerDataSource") || ref.getClassName().equals("tyrex.jdbc.xa.EnabledDataSource")) {
                try {
                    EnabledDataSource ds = new EnabledDataSource();
                    RefAddr currentRefAddr = null;
                    currentRefAddr = ref.get(DESCRIPTION);
                    if (currentRefAddr != null) {
                        ds.setDescription(currentRefAddr.getContent().toString());
                    }
                    if ((currentRefAddr = ref.get(LOGIN_TIMEOUT)) != null) {
                        ds.setLoginTimeout(Integer.parseInt(currentRefAddr.getContent().toString()));
                    }
                    if ((currentRefAddr = ref.get(USER)) != null) {
                        ds.setUser(currentRefAddr.getContent().toString());
                    } else {
                        ds.setUser(DEFAULT_USER);
                    }
                    currentRefAddr = ref.get(PASSWORD);
                    if (currentRefAddr != null) {
                        ds.setPassword(currentRefAddr.getContent().toString());
                    } else {
                        ds.setPassword(DEFAULT_PASSWORD);
                    }
                    currentRefAddr = ref.get(DRIVER_NAME);
                    if (currentRefAddr != null) {
                        ds.setDriverName(currentRefAddr.getContent().toString());
                    } else {
                        ds.setDriverName(DEFAULT_DRIVER_NAME);
                    }
                    currentRefAddr = ref.get(DRIVER_CLASS_NAME);
                    String driverClassName = null;
                    driverClassName = currentRefAddr != null ? currentRefAddr.getContent().toString() : DEFAULT_DRIVER_CLASS_NAME;
                    ds.setDriverClassName(driverClassName);
                    Class<?> driverClass = Class.forName(driverClassName);
                    Driver databaseDriver = (Driver)driverClass.newInstance();
                    DriverManager.registerDriver(databaseDriver);
                    if (ref.getClassName().equals("tyrex.jdbc.ServerDataSource")) {
                        ServerDataSource sds = new ServerDataSource((XADataSource)ds);
                        currentRefAddr = ref.get(DESCRIPTION);
                        if (currentRefAddr != null) {
                            sds.setDescription(currentRefAddr.getContent().toString());
                        }
                        return sds;
                    }
                    return ds;
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
            return null;
        }
        return null;
    }
}

