/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.warp;

import java.io.IOException;
import java.io.InputStream;
import org.apache.catalina.Host;
import org.apache.catalina.connector.HttpRequestBase;
import org.apache.catalina.connector.warp.WarpConnection;
import org.apache.catalina.connector.warp.WarpPacket;

public class WarpRequest
extends HttpRequestBase {
    private Stream localstream = new Stream(this);
    private WarpConnection connection;
    private Host host = null;

    public WarpRequest() {
        this.setStream(this.localstream);
    }

    public WarpConnection getConnection() {
        return this.connection;
    }

    public Host getHost() {
        return this.host;
    }

    public void recycle() {
        super.recycle();
        this.localstream.recycle();
        this.setStream(this.localstream);
    }

    public void setConnection(WarpConnection connection) {
        this.connection = connection;
    }

    public void setHost(Host host) {
        this.host = host;
    }

    protected class Stream
    extends InputStream {
        private WarpRequest request = null;
        private WarpPacket packet = null;
        private boolean closed = false;

        protected Stream(WarpRequest request) {
            this.request = request;
            this.packet = new WarpPacket();
            this.packet.setType(65);
        }

        public void close() throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            this.packet.reset();
            this.packet.setType(66);
            this.closed = true;
        }

        public int read() throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            if (this.packet.getType() == 66) {
                return -1;
            }
            if (this.packet.getType() != 65) {
                throw new IOException("Invalid WARP packet type for body");
            }
            if (this.packet.pointer < this.packet.size) {
                return this.packet.buffer[this.packet.pointer++];
            }
            this.packet.reset();
            this.packet.setType(64);
            this.packet.writeUnsignedShort(65535);
            this.request.getConnection().send(this.packet);
            this.packet.reset();
            this.request.getConnection().recv(this.packet);
            return this.read();
        }

        public void recycle() {
            this.packet.reset();
            this.packet.setType(65);
            this.closed = false;
        }
    }
}

