/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessControlException;
import java.util.Random;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.ServerFactory;
import org.apache.catalina.Service;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;

public final class StandardServer
implements Lifecycle,
Server {
    private static final String info = "org.apache.catalina.core.StandardServer/1.0";
    private LifecycleSupport lifecycle = new LifecycleSupport(this);
    private int port = 8005;
    private Random random = null;
    private Service[] services = new Service[0];
    private String shutdown = "SHUTDOWN";
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private boolean started = false;
    private boolean initialized = false;

    public StandardServer() {
        ServerFactory.setServer(this);
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public void addService(Service service) {
        Service[] serviceArray = this.services;
        synchronized (serviceArray) {
            Service[] results = new Service[this.services.length + 1];
            System.arraycopy(this.services, 0, results, 0, this.services.length);
            results[this.services.length] = service;
            this.services = results;
            if (this.initialized) {
                try {
                    service.initialize();
                }
                catch (LifecycleException e) {
                    e.printStackTrace(System.err);
                }
            }
            if (this.started && service instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)service)).start();
                }
                catch (LifecycleException lifecycleException) {}
            }
        }
    }

    public void await() {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(this.port, 1, InetAddress.getByName("127.0.0.1"));
        }
        catch (IOException e) {
            System.err.println("StandardServer.await: create: " + e);
            e.printStackTrace();
            System.exit(1);
        }
        while (true) {
            Socket socket = null;
            InputStream stream = null;
            try {
                socket = serverSocket.accept();
                socket.setSoTimeout(10000);
                stream = socket.getInputStream();
            }
            catch (AccessControlException ace) {
                System.err.println("StandardServer.accept security exception: " + ace.getMessage());
                continue;
            }
            catch (IOException e) {
                System.err.println("StandardServer.await: accept: " + e);
                e.printStackTrace();
                System.exit(1);
            }
            StringBuffer command = new StringBuffer();
            int expected = 1024;
            while (expected < this.shutdown.length()) {
                if (this.random == null) {
                    this.random = new Random(System.currentTimeMillis());
                }
                expected += this.random.nextInt() % 1024;
            }
            while (expected > 0) {
                int ch = -1;
                try {
                    ch = stream.read();
                }
                catch (IOException e) {
                    System.err.println("StandardServer.await: read: " + e);
                    e.printStackTrace();
                    ch = -1;
                }
                if (ch < 32) break;
                command.append((char)ch);
                --expected;
            }
            try {
                socket.close();
            }
            catch (IOException iOException) {}
            boolean match = command.toString().equals(this.shutdown);
            if (match) break;
            System.err.println("StandardServer.await: Invalid command '" + command.toString() + "' received");
        }
        try {
            serverSocket.close();
        }
        catch (IOException iOException) {}
    }

    public Service[] findServices() {
        return this.services;
    }

    public String getInfo() {
        return info;
    }

    public int getPort() {
        return this.port;
    }

    public String getShutdown() {
        return this.shutdown;
    }

    public void initialize() throws LifecycleException {
        if (this.initialized) {
            throw new LifecycleException(sm.getString("standardServer.initialize.initialized"));
        }
        this.initialized = true;
        int i = 0;
        while (i < this.services.length) {
            this.services[i].initialize();
            ++i;
        }
    }

    private boolean isSameAddress(InetAddress server, InetAddress client) {
        byte[] clientAddr;
        byte[] serverAddr = server.getAddress();
        if (serverAddr.length != (clientAddr = client.getAddress()).length) {
            return false;
        }
        boolean match = true;
        int i = 0;
        while (i < serverAddr.length) {
            if (serverAddr[i] != clientAddr[i]) {
                match = false;
                break;
            }
            ++i;
        }
        if (match) {
            return true;
        }
        int i2 = 0;
        while (i2 < serverAddr.length) {
            if (serverAddr[i2] != clientAddr[serverAddr.length - 1 - i2]) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void removeService(Service service) {
        Service[] serviceArray = this.services;
        synchronized (serviceArray) {
            int j = -1;
            int i = 0;
            while (i < this.services.length) {
                if (service == this.services[i]) {
                    j = i;
                    break;
                }
                ++i;
            }
            if (j < 0) {
                Object var3_5 = null;
                return;
            }
            if (this.services[j] instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)this.services[j])).stop();
                }
                catch (LifecycleException lifecycleException) {}
            }
            int k = 0;
            Service[] results = new Service[this.services.length - 1];
            int i2 = 0;
            while (i2 < this.services.length) {
                if (i2 != j) {
                    results[k++] = this.services[i2];
                }
                ++i2;
            }
            this.services = results;
        }
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setShutdown(String shutdown) {
        this.shutdown = shutdown;
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString("standardServer.start.started"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        Service[] serviceArray = this.services;
        synchronized (serviceArray) {
            int i = 0;
            while (i < this.services.length) {
                if (this.services[i] instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.services[i])).start();
                }
                ++i;
            }
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("standardServer.stop.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        int i = 0;
        while (i < this.services.length) {
            if (this.services[i] instanceof Lifecycle) {
                ((Lifecycle)((Object)this.services[i])).stop();
            }
            ++i;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("StandardServer[");
        sb.append(this.getPort());
        sb.append("]");
        return sb.toString();
    }
}

