/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import org.apache.catalina.Response;

public class ResponseFacade
implements ServletResponse {
    protected ServletResponse response = null;
    protected Response resp = null;

    public ResponseFacade(Response response) {
        this.resp = response;
        this.response = (ServletResponse)response;
    }

    public void finish() {
        this.resp.setSuspended(true);
    }

    public void flushBuffer() throws IOException {
        if (this.isFinished()) {
            throw new IllegalStateException();
        }
        this.resp.setAppCommitted(true);
        this.response.flushBuffer();
    }

    public int getBufferSize() {
        return this.response.getBufferSize();
    }

    public String getCharacterEncoding() {
        return this.response.getCharacterEncoding();
    }

    public Locale getLocale() {
        return this.response.getLocale();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.isFinished()) {
            throw new IllegalStateException();
        }
        return this.response.getOutputStream();
    }

    public PrintWriter getWriter() throws IOException {
        if (this.isFinished()) {
            throw new IllegalStateException();
        }
        return this.response.getWriter();
    }

    public boolean isCommitted() {
        return this.resp.isAppCommitted();
    }

    public boolean isFinished() {
        return this.resp.isSuspended();
    }

    public void reset() {
        if (this.isCommitted()) {
            throw new IllegalStateException();
        }
        this.response.reset();
    }

    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException();
        }
        this.response.resetBuffer();
    }

    public void setBufferSize(int size) {
        if (this.isCommitted()) {
            throw new IllegalStateException();
        }
        this.response.setBufferSize(size);
    }

    public void setContentLength(int len) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setContentLength(len);
    }

    public void setContentType(String type) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setContentType(type);
    }

    public void setLocale(Locale loc) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setLocale(loc);
    }
}

