/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.Vector;
import org.apache.catalina.cluster.ClusterReceiver;
import org.apache.catalina.cluster.ClusterSessionBase;
import org.apache.catalina.cluster.ReplicationWrapper;

public final class MulticastReceiver
extends ClusterSessionBase
implements ClusterReceiver {
    private static String senderId = null;
    private MulticastSocket multicastSocket = null;
    private String threadName = "MulticastReceiver";
    private String receiverName = "MulticastReceiver";
    private static Vector stack = new Vector();
    private boolean started = false;
    private Thread thread = null;
    protected boolean threadDone = false;
    private int checkInterval = 5;

    MulticastReceiver(String senderId, MulticastSocket multicastSocket, InetAddress multicastAddress, int multicastPort) {
        this.multicastSocket = multicastSocket;
        MulticastReceiver.senderId = senderId;
    }

    public int getCheckInterval() {
        return this.checkInterval;
    }

    public String getName() {
        return this.receiverName;
    }

    public Object[] getObjects() {
        Object[] objs = stack.toArray();
        stack.removeAllElements();
        return objs;
    }

    private void receive() {
        try {
            byte[] buf = new byte[5000];
            DatagramPacket recv = new DatagramPacket(buf, buf.length);
            ByteArrayInputStream ips = null;
            ObjectInputStream ois = null;
            this.multicastSocket.receive(recv);
            ips = new ByteArrayInputStream(buf, 0, buf.length);
            ois = new ObjectInputStream(ips);
            ReplicationWrapper obj = (ReplicationWrapper)ois.readObject();
            if (obj.getSenderId().equals(senderId)) {
                stack.add(obj);
            }
        }
        catch (IOException e) {
            this.log("An error occured when trying to replicate: " + e.toString());
        }
        catch (ClassNotFoundException e) {
            this.log("An error occured when trying to replicate: " + e.toString());
        }
    }

    public void run() {
        while (!this.threadDone) {
            this.receive();
            this.threadSleep();
        }
    }

    public void setCheckInterval(int checkInterval) {
        this.checkInterval = checkInterval;
    }

    public void start() {
        this.started = true;
        this.threadStart();
    }

    public void stop() {
        this.started = false;
        this.threadStop();
    }

    private void threadSleep() {
        try {
            Thread.sleep((long)this.checkInterval * 1000L);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void threadStart() {
        if (this.thread != null) {
            return;
        }
        this.threadDone = false;
        this.threadName = String.valueOf(this.threadName) + "[" + senderId + "]";
        this.thread = new Thread((Runnable)this, this.threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private void threadStop() {
        if (this.thread == null) {
            return;
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {}
        this.thread = null;
    }
}

