/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ajp.test;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.ajp.Ajp13Packet;
import org.apache.ajp.test.Ajp13Server;

public class TestAjp13
extends TestCase {
    Ajp13Server server = null;
    static /* synthetic */ Class class$org$apache$ajp$test$TestAjp13;

    public TestAjp13(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(class$org$apache$ajp$test$TestAjp13 == null ? (class$org$apache$ajp$test$TestAjp13 = TestAjp13.class$("org.apache.ajp.test.TestAjp13")) : class$org$apache$ajp$test$TestAjp13);
    }

    protected void setUp() {
        TestAjp13.println("setup...");
        this.server = new Ajp13Server();
        this.server.start();
    }

    protected void tearDown() {
        TestAjp13.println("tear down...");
        this.server.shutdown();
    }

    public void test1() throws Exception {
        TestAjp13.println("running test1");
        Socket s = new Socket("localhost", 8009);
        Ajp13Packet p = new Ajp13Packet(8192);
        p.appendInt(4660);
        p.appendInt(0);
        p.setByteOff(4);
        p.appendByte((byte)2);
        p.appendByte((byte)2);
        p.appendString("http");
        p.appendString("/test_uri");
        p.appendString("remote_addr");
        p.appendString("remote_host");
        p.appendString("server_name");
        p.appendInt(80);
        p.appendBool(false);
        p.appendInt(3);
        p.appendString("my header");
        p.appendString("my header value");
        p.appendInt(40965);
        p.appendString("some auth string");
        p.appendInt(40974);
        p.appendString("TestAjp13 User Agent");
        p.appendByte((byte)-1);
        int len = p.getByteOff() - 4;
        p.setByteOff(2);
        p.appendInt(len);
        OutputStream os = s.getOutputStream();
        os.write(p.getBuff(), 0, len + 4);
        InputStream is = s.getInputStream();
        TestAjp13.println("decoding response...");
        boolean done = false;
        while (!done) {
            int b1 = is.read();
            Assert.assertTrue((String)("byte 1 was " + (char)b1), (b1 == 65 ? 1 : 0) != 0);
            int b2 = is.read();
            Assert.assertTrue((String)("byte 2 was " + (char)b2), (b2 == 66 ? 1 : 0) != 0);
            TestAjp13.println("b1 = " + (char)b1 + "; b2 = " + (char)b2);
            b1 = is.read();
            b2 = is.read();
            int l = ((b1 &= 0xFF) << 8) + (b2 &= 0xFF);
            TestAjp13.println("length = " + l);
            byte[] buf = new byte[l];
            int n = 0;
            int off = 0;
            int total = 0;
            while ((n = is.read(buf, off, l - off)) != -1 && l - off != 0) {
                total += n;
                off += n;
            }
            TestAjp13.println("read " + total);
            Assert.assertTrue((String)("total read was " + total + ", should have been " + l), (total == l ? 1 : 0) != 0);
            byte code = buf[0];
            switch (code) {
                case 3: {
                    TestAjp13.println("AJP13_SEND_BODY_CHUNK ");
                    break;
                }
                case 4: {
                    TestAjp13.println("AJP13_SEND_HEADERS ");
                    break;
                }
                case 5: {
                    TestAjp13.println("AJP13_END_RESPONSE ");
                    done = true;
                    break;
                }
                case 6: {
                    TestAjp13.println("AJP13_GET_BODY_CHUNK ");
                    break;
                }
                default: {
                    Assert.assertTrue((String)("invalid prefix code:  " + code), (boolean)false);
                }
            }
        }
        TestAjp13.println("shutting down socket...");
        s.shutdownOutput();
        s.shutdownInput();
        s.close();
        TestAjp13.println("done test1...");
    }

    protected static void println(String msg) {
        System.out.println("[TestAjp13] " + msg);
    }

    public static void main(String[] args) throws Exception {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

