/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ajp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.ajp.Ajp14Packet;
import org.apache.ajp.AjpHandler;
import org.apache.ajp.NegociationHandler;
import org.apache.ajp.RequestHandler;
import org.apache.tomcat.util.http.BaseRequest;

public class Ajp14 {
    public static final int MAX_PACKET_SIZE = 8192;
    public static final int H_SIZE = 4;
    public static final int MAX_READ_SIZE = 8186;
    public static final int MAX_SEND_SIZE = 8184;
    OutputStream out;
    InputStream in;
    public Ajp14Packet outBuf = new Ajp14Packet(8192);
    Ajp14Packet inBuf = new Ajp14Packet(8192);
    Ajp14Packet hBuf = new Ajp14Packet(8192);
    byte[] bodyBuff = new byte[8186];
    int blen;
    int pos;
    public NegociationHandler negHandler = new NegociationHandler();
    public RequestHandler reqHandler = new RequestHandler();
    static final int MAX_HANDLERS = 32;
    static final int RESERVED = 16;
    AjpHandler[] handlers = new AjpHandler[32];
    String[] handlerName = new String[32];
    int currentId = 16;
    private static int debug = 10;

    public Ajp14() {
        this.setSeed("myveryrandomentropy");
        this.setPassword("myverysecretkey");
        this.negHandler.init(this);
        this.reqHandler.init(this);
    }

    public void initBuf() {
        this.outBuf = new Ajp14Packet(8192);
        this.inBuf = new Ajp14Packet(8192);
        this.hBuf = new Ajp14Packet(8192);
    }

    public void recycle() {
        if (debug > 0) {
            this.log("recycle()");
        }
        this.blen = 0;
        this.pos = 0;
    }

    public void setSocket(Socket socket) throws IOException {
        if (debug > 0) {
            this.log("setSocket()");
        }
        socket.setSoLinger(true, 100);
        this.out = socket.getOutputStream();
        this.in = socket.getInputStream();
        this.pos = 0;
    }

    public void setContainerSignature(String s) {
        this.negHandler.setContainerSignature(s);
    }

    public void setSeed(String pseed) {
        this.negHandler.setSeed(pseed);
    }

    public void setPassword(String ppwd) {
        this.negHandler.setPassword(ppwd);
    }

    public int registerMessageType(int id, String name, AjpHandler h, String[] sig) {
        if (id < 0) {
            int i = 0;
            while (i < this.handlerName.length) {
                if (name.equals(this.handlerName[i])) {
                    return i;
                }
                ++i;
            }
            this.handlerName[this.currentId] = name;
            this.handlers[this.currentId] = h;
            ++this.currentId;
            return this.currentId;
        }
        this.handlerName[id] = name;
        this.handlers[id] = h;
        return id;
    }

    public int receiveNextRequest(BaseRequest req) throws IOException {
        int err = this.receive(this.hBuf);
        if (err < 0) {
            if (debug > 0) {
                this.log("Error receiving message ");
            }
            return 500;
        }
        byte type = this.hBuf.getByte();
        if (type > this.handlers.length) {
            this.log("Invalid handler " + type);
            return 500;
        }
        if (debug > 0) {
            this.log("Received " + type + " " + this.handlerName[type]);
        }
        if (!this.negHandler.isLogged() && type != 16 && type != 18) {
            return 300;
        }
        AjpHandler handler = this.handlers[type];
        if (handler == null) {
            this.log("Unknown message " + type + this.handlerName[type]);
            return 200;
        }
        return handler.handleAjpMessage(type, this, this.hBuf, req);
    }

    public int receive(Ajp14Packet msg) throws IOException {
        int rd;
        byte[] b = msg.getBuff();
        if (debug > 5) {
            this.log("Reading head ");
        }
        if ((rd = this.in.read(b, 0, 4)) <= 0) {
            if (debug > 5) {
                this.log("Error reading " + rd);
            }
            return rd;
        }
        int len = msg.checkIn();
        if (debug > 5) {
            this.log("Received " + rd + " " + len + " " + b[0]);
        }
        int total_read = 0;
        while (total_read < len) {
            rd = this.in.read(b, 4 + total_read, len - total_read);
            if (rd == -1) {
                this.log("Incomplete read, deal with it " + len + " " + rd);
                break;
            }
            total_read += rd;
        }
        if (debug > 10) {
            this.log("Received total:  " + total_read);
        }
        return total_read;
    }

    public void send(Ajp14Packet msg) throws IOException {
        msg.end();
        byte[] b = msg.getBuff();
        int len = msg.getLen();
        if (debug > 5) {
            this.log("send() " + len + " " + b[0]);
        }
        this.out.write(b, 0, len);
    }

    public void close() throws IOException {
        if (debug > 0) {
            this.log("close()");
        }
        if (null != this.out) {
            this.out.close();
        }
        if (null != this.in) {
            this.in.close();
        }
        this.negHandler.setLogged(false);
    }

    void log(String s) {
        System.out.println("Ajp14: " + s);
    }
}

