/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ajp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.ajp.Ajp13Packet;
import org.apache.ajp.AjpRequest;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.HttpMessages;
import org.apache.tomcat.util.http.MimeHeaders;

public class Ajp13 {
    public static final int MAX_PACKET_SIZE = 8192;
    public static final int H_SIZE = 4;
    public static final int MAX_READ_SIZE = 8186;
    public static final int MAX_SEND_SIZE = 8184;
    public static final byte JK_AJP13_FORWARD_REQUEST = 2;
    public static final byte JK_AJP13_SHUTDOWN = 7;
    public static final byte JK_AJP13_SEND_BODY_CHUNK = 3;
    public static final byte JK_AJP13_SEND_HEADERS = 4;
    public static final byte JK_AJP13_END_RESPONSE = 5;
    public static final byte JK_AJP13_GET_BODY_CHUNK = 6;
    public static final int JK_AJP13_BAD_HEADER = -100;
    public static final int JK_AJP13_NO_HEADER = -101;
    public static final int JK_AJP13_COMM_CLOSED = -102;
    public static final int JK_AJP13_COMM_BROKEN = -103;
    public static final int JK_AJP13_BAD_BODY = -104;
    public static final int JK_AJP13_INCOMPLETE_BODY = -105;
    public static final int SC_RESP_CONTENT_TYPE = 40961;
    public static final int SC_RESP_CONTENT_LANGUAGE = 40962;
    public static final int SC_RESP_CONTENT_LENGTH = 40963;
    public static final int SC_RESP_DATE = 40964;
    public static final int SC_RESP_LAST_MODIFIED = 40965;
    public static final int SC_RESP_LOCATION = 40966;
    public static final int SC_RESP_SET_COOKIE = 40967;
    public static final int SC_RESP_SET_COOKIE2 = 40968;
    public static final int SC_RESP_SERVLET_ENGINE = 40969;
    public static final int SC_RESP_STATUS = 40970;
    public static final int SC_RESP_WWW_AUTHENTICATE = 40971;
    public static final byte SC_A_CONTEXT = 1;
    public static final byte SC_A_SERVLET_PATH = 2;
    public static final byte SC_A_REMOTE_USER = 3;
    public static final byte SC_A_AUTH_TYPE = 4;
    public static final byte SC_A_QUERY_STRING = 5;
    public static final byte SC_A_JVM_ROUTE = 6;
    public static final byte SC_A_SSL_CERT = 7;
    public static final byte SC_A_SSL_CIPHER = 8;
    public static final byte SC_A_SSL_SESSION = 9;
    public static final byte SC_A_SSL_KEYSIZE = 11;
    public static final byte SC_A_REQ_ATTRIBUTE = 10;
    public static final byte SC_A_ARE_DONE = -1;
    public static final String[] methodTransArray = new String[]{"OPTIONS", "GET", "HEAD", "POST", "PUT", "DELETE", "TRACE", "PROPFIND", "PROPPATCH", "MKCOL", "COPY", "MOVE", "LOCK", "UNLOCK", "ACL", "REPORT", "VERSION-CONTROL", "CHECKIN", "CHECKOUT", "UNCHECKOUT", "SEARCH"};
    public static final int SC_REQ_ACCEPT = 1;
    public static final int SC_REQ_ACCEPT_CHARSET = 2;
    public static final int SC_REQ_ACCEPT_ENCODING = 3;
    public static final int SC_REQ_ACCEPT_LANGUAGE = 4;
    public static final int SC_REQ_AUTHORIZATION = 5;
    public static final int SC_REQ_CONNECTION = 6;
    public static final int SC_REQ_CONTENT_TYPE = 7;
    public static final int SC_REQ_CONTENT_LENGTH = 8;
    public static final int SC_REQ_COOKIE = 9;
    public static final int SC_REQ_COOKIE2 = 10;
    public static final int SC_REQ_HOST = 11;
    public static final int SC_REQ_PRAGMA = 12;
    public static final int SC_REQ_REFERER = 13;
    public static final int SC_REQ_USER_AGENT = 14;
    public static final String[] headerTransArray = new String[]{"accept", "accept-charset", "accept-encoding", "accept-language", "authorization", "connection", "content-type", "content-length", "cookie", "cookie2", "host", "pragma", "referer", "user-agent"};
    OutputStream out;
    InputStream in;
    Ajp13Packet outBuf = new Ajp13Packet(8192);
    Ajp13Packet inBuf = new Ajp13Packet(8192);
    Ajp13Packet hBuf = new Ajp13Packet(8192);
    byte[] bodyBuff = new byte[8186];
    int blen;
    int pos;
    boolean end_of_stream;
    private int debug = 0;
    Logger logger = new Logger();

    public Ajp13() {
        this.initBuf();
    }

    public void initBuf() {
        this.outBuf = new Ajp13Packet(8192);
        this.inBuf = new Ajp13Packet(8192);
        this.hBuf = new Ajp13Packet(8192);
    }

    public void recycle() {
        if (this.debug > 0) {
            this.logger.log("recycle()");
        }
        this.blen = 0;
        this.pos = 0;
        this.end_of_stream = false;
    }

    public void setSocket(Socket socket) throws IOException {
        if (this.debug > 0) {
            this.logger.log("setSocket()");
        }
        socket.setSoLinger(true, 100);
        this.out = socket.getOutputStream();
        this.in = socket.getInputStream();
        this.pos = 0;
    }

    public int receiveNextRequest(AjpRequest req) throws IOException {
        if (this.debug > 0) {
            this.logger.log("receiveNextRequest()");
        }
        int err = 0;
        try {
            err = this.receive(this.hBuf);
        }
        catch (IOException ioe) {
            return -1;
        }
        if (err < 0) {
            return 500;
        }
        byte type = this.hBuf.getByte();
        switch (type) {
            case 2: {
                return this.decodeRequest(req, this.hBuf);
            }
            case 7: {
                return -2;
            }
        }
        return 200;
    }

    int decodeMoreHeaders(AjpRequest req, byte attribute, Ajp13Packet msg) {
        return 500;
    }

    protected int decodeRequest(AjpRequest req, Ajp13Packet msg) throws IOException {
        if (this.debug > 0) {
            this.logger.log("decodeRequest()");
        }
        boolean isSSL = false;
        byte methodCode = msg.getByte();
        req.method().setString(methodTransArray[methodCode - 1]);
        msg.getMessageBytes(req.protocol());
        msg.getMessageBytes(req.requestURI());
        msg.getMessageBytes(req.remoteAddr());
        msg.getMessageBytes(req.remoteHost());
        msg.getMessageBytes(req.serverName());
        req.setServerPort(msg.getInt());
        isSSL = msg.getBool();
        MimeHeaders headers = req.headers();
        int hCount = msg.getInt();
        int i = 0;
        while (i < hCount) {
            String hName = null;
            int isc = msg.peekInt();
            int hId = isc & 0xFF;
            MessageBytes vMB = null;
            if (40960 == (isc &= 0xFF00)) {
                msg.getInt();
                hName = headerTransArray[hId - 1];
                vMB = headers.addValue(hName);
            } else {
                vMB = msg.addHeader(headers);
                if (vMB == null) {
                    return 500;
                }
            }
            msg.getMessageBytes(vMB);
            if (hId == 8) {
                int contentLength = vMB == null ? -1 : vMB.getInt();
                req.setContentLength(contentLength);
            } else if (hId == 7) {
                ByteChunk bchunk = vMB.getByteChunk();
                req.contentType().setBytes(bchunk.getBytes(), bchunk.getOffset(), bchunk.getLength());
            }
            ++i;
        }
        byte attributeCode = msg.getByte();
        while (attributeCode != -1) {
            switch (attributeCode) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    msg.getMessageBytes(req.remoteUser());
                    break;
                }
                case 4: {
                    msg.getMessageBytes(req.authType());
                    break;
                }
                case 5: {
                    msg.getMessageBytes(req.queryString());
                    break;
                }
                case 6: {
                    msg.getMessageBytes(req.jvmRoute());
                    break;
                }
                case 7: {
                    isSSL = true;
                    String certString = msg.getString();
                    byte[] certData = certString.getBytes();
                    ByteArrayInputStream bais = new ByteArrayInputStream(certData);
                    X509Certificate[] jsseCerts = null;
                    try {
                        CertificateFactory cf = CertificateFactory.getInstance("X.509");
                        X509Certificate cert = (X509Certificate)cf.generateCertificate(bais);
                        jsseCerts = new X509Certificate[]{cert};
                    }
                    catch (CertificateException e) {
                        this.logger.log("Certificate convertion failed" + e);
                    }
                    req.setAttribute("javax.servlet.request.X509Certificate", jsseCerts);
                    break;
                }
                case 8: {
                    isSSL = true;
                    req.setAttribute("javax.servlet.request.cipher_suite", msg.getString());
                    break;
                }
                case 9: {
                    isSSL = true;
                    req.setAttribute("javax.servlet.request.ssl_session", msg.getString());
                    break;
                }
                case 10: {
                    req.setAttribute(msg.getString(), msg.getString());
                    break;
                }
                case 11: {
                    req.setAttribute("javax.servlet.request.key_size", new Integer(msg.getInt()));
                    break;
                }
                default: {
                    if (this.decodeMoreHeaders(req, attributeCode, msg) != 500) break;
                    return 500;
                }
            }
            attributeCode = msg.getByte();
        }
        if (isSSL) {
            req.setScheme("https");
            req.setSecure(true);
        }
        req.cookies().setHeaders(req.headers());
        if (req.getContentLength() != 0) {
            int err = this.receive(this.inBuf);
            if (err < 0) {
                return 500;
            }
            this.blen = this.inBuf.peekInt();
            this.pos = 0;
            this.inBuf.getBytes(this.bodyBuff);
        }
        if (this.debug > 5) {
            this.logger.log(req.toString());
        }
        return 200;
    }

    public int available() throws IOException {
        if (this.debug > 0) {
            this.logger.log("available()");
        }
        if (this.pos >= this.blen && !this.refillReadBuffer()) {
            return 0;
        }
        return this.blen - this.pos;
    }

    public int doRead() throws IOException {
        if (this.debug > 0) {
            this.logger.log("doRead()");
        }
        if (this.pos >= this.blen && !this.refillReadBuffer()) {
            return -1;
        }
        return (char)this.bodyBuff[this.pos++];
    }

    public int doRead(byte[] b, int off, int len) throws IOException {
        if (this.debug > 0) {
            this.logger.log("doRead(byte[], int, int)");
        }
        if (this.pos >= this.blen && !this.refillReadBuffer()) {
            return -1;
        }
        if (this.pos + len <= this.blen) {
            System.arraycopy(this.bodyBuff, this.pos, b, off, len);
            this.pos += len;
            return len;
        }
        int toCopy = len;
        while (toCopy > 0) {
            int bytesRemaining = this.blen - this.pos;
            if (bytesRemaining < 0) {
                bytesRemaining = 0;
            }
            int c = bytesRemaining < toCopy ? bytesRemaining : toCopy;
            System.arraycopy(this.bodyBuff, this.pos, b, off, c);
            off += c;
            this.pos += c;
            if ((toCopy -= c) > 0 && !this.refillReadBuffer()) break;
        }
        return len - toCopy;
    }

    private boolean refillReadBuffer() throws IOException {
        if (this.debug > 0) {
            this.logger.log("refillReadBuffer()");
        }
        if (this.end_of_stream) {
            return false;
        }
        this.inBuf.reset();
        this.inBuf.appendByte((byte)6);
        this.inBuf.appendInt(8186);
        this.send(this.inBuf);
        int err = this.receive(this.inBuf);
        if (err < 0) {
            throw new IOException();
        }
        if (this.inBuf.getLen() == 0) {
            this.pos = 0;
            this.blen = 0;
            this.end_of_stream = true;
            return false;
        }
        this.blen = this.inBuf.peekInt();
        this.pos = 0;
        this.inBuf.getBytes(this.bodyBuff);
        return this.blen > 0;
    }

    public void beginSendHeaders(int status, String statusMessage, int numHeaders) throws IOException {
        if (this.debug > 0) {
            this.logger.log("sendHeaders()");
        }
        this.outBuf.reset();
        this.outBuf.appendByte((byte)4);
        if (this.debug > 0) {
            this.logger.log("status is:  " + status + "(" + statusMessage + ")");
        }
        this.outBuf.appendInt(status);
        this.outBuf.appendString(statusMessage);
        this.outBuf.appendInt(numHeaders);
    }

    public void sendHeader(String name, String value) throws IOException {
        int sc = this.headerNameToSc(name);
        if (-1 != sc) {
            this.outBuf.appendInt(sc);
        } else {
            this.outBuf.appendString(name);
        }
        this.outBuf.appendString(value);
    }

    public void endSendHeaders() throws IOException {
        this.outBuf.end();
        this.send(this.outBuf);
    }

    public void sendHeaders(int status, MimeHeaders headers) throws IOException {
        this.sendHeaders(status, HttpMessages.getMessage((int)status), headers);
    }

    public void sendHeaders(int status, String statusMessage, MimeHeaders headers) throws IOException {
        this.outBuf.reset();
        this.outBuf.appendByte((byte)4);
        this.outBuf.appendInt(status);
        this.outBuf.appendString(statusMessage);
        int numHeaders = headers.size();
        this.outBuf.appendInt(numHeaders);
        int i = 0;
        while (i < numHeaders) {
            String headerName = headers.getName(i).toString();
            int sc = this.headerNameToSc(headerName);
            if (-1 != sc) {
                this.outBuf.appendInt(sc);
            } else {
                this.outBuf.appendString(headerName);
            }
            this.outBuf.appendString(headers.getValue(i).toString());
            ++i;
        }
        this.outBuf.end();
        this.send(this.outBuf);
    }

    protected int headerNameToSc(String name) {
        switch (name.charAt(0)) {
            case 'C': 
            case 'c': {
                if (name.equalsIgnoreCase("Content-Type")) {
                    return 40961;
                }
                if (name.equalsIgnoreCase("Content-Language")) {
                    return 40962;
                }
                if (!name.equalsIgnoreCase("Content-Length")) break;
                return 40963;
            }
            case 'D': 
            case 'd': {
                if (!name.equalsIgnoreCase("Date")) break;
                return 40964;
            }
            case 'L': 
            case 'l': {
                if (name.equalsIgnoreCase("Last-Modified")) {
                    return 40965;
                }
                if (!name.equalsIgnoreCase("Location")) break;
                return 40966;
            }
            case 'S': 
            case 's': {
                if (name.equalsIgnoreCase("Set-Cookie")) {
                    return 40967;
                }
                if (!name.equalsIgnoreCase("Set-Cookie2")) break;
                return 40968;
            }
            case 'W': 
            case 'w': {
                if (!name.equalsIgnoreCase("WWW-Authenticate")) break;
                return 40971;
            }
        }
        return -1;
    }

    public void finish() throws IOException {
        if (this.debug > 0) {
            this.logger.log("finish()");
        }
        this.outBuf.reset();
        this.outBuf.appendByte((byte)5);
        this.outBuf.appendBool(true);
        this.outBuf.end();
        this.send(this.outBuf);
    }

    public void doWrite(byte[] b, int off, int len) throws IOException {
        if (this.debug > 0) {
            this.logger.log("doWrite(byte[], " + off + ", " + len + ")");
        }
        int sent = 0;
        while (sent < len) {
            int to_send = len - sent;
            to_send = to_send > 8184 ? 8184 : to_send;
            this.outBuf.reset();
            this.outBuf.appendByte((byte)3);
            this.outBuf.appendBytes(b, off + sent, to_send);
            this.send(this.outBuf);
            sent += to_send;
        }
    }

    private int readN(InputStream in, byte[] b, int offset, int len) throws IOException {
        int pos = 0;
        while (pos < len) {
            int got = in.read(b, pos + offset, len - pos);
            if (this.debug > 10) {
                this.logger.log("read got # " + got);
            }
            if (got == 0) {
                return -102;
            }
            if (got < 0) {
                return -103;
            }
            pos += got;
        }
        return pos;
    }

    public int receive(Ajp13Packet msg) throws IOException {
        byte[] b;
        int rd;
        if (this.debug > 0) {
            this.logger.log("receive()");
        }
        if ((rd = this.readN(this.in, b = msg.getBuff(), 0, 4)) < 0) {
            this.logger.log("bad read: " + rd);
            return rd;
        }
        int len = msg.checkIn();
        if (this.debug > 0) {
            this.logger.log("receive:  len = " + len);
        }
        int total_read = 0;
        total_read = this.readN(this.in, b, 4, len);
        if (total_read < 0) {
            this.logger.log("can't read body, waited #" + len);
            return -104;
        }
        if (total_read != len) {
            this.logger.log("incomplete read, waited #" + len + " got only " + total_read);
            return -105;
        }
        if (this.debug > 0) {
            this.logger.log("receive:  total read = " + total_read);
        }
        return total_read;
    }

    private void send(Ajp13Packet msg) throws IOException {
        if (this.debug > 0) {
            this.logger.log("send()");
        }
        msg.end();
        byte[] b = msg.getBuff();
        int len = msg.getLen();
        if (this.debug > 0) {
            this.logger.log("sending msg, len = " + len);
        }
        this.out.write(b, 0, len);
    }

    public void close() throws IOException {
        if (this.debug > 0) {
            this.logger.log("close()");
        }
        if (null != this.out) {
            this.out.close();
        }
        if (null != this.in) {
            this.in.close();
        }
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    class Logger {
        Logger() {
        }

        void log(String msg) {
            System.out.println("[Ajp13] " + msg);
        }

        void log(String msg, Throwable t) {
            System.out.println("[Ajp13] " + msg);
            t.printStackTrace(System.out);
        }
    }
}

