/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import org.apache.jasper.CommandLineContext;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.Mangler;

public class CommandLineCompiler
extends Compiler
implements Mangler {
    String javaFileName;
    String classFileName;
    String packageName;
    String pkgName;
    String className;
    File jsp;
    String outputDir;
    public static String[] keywords = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};

    public CommandLineCompiler(CommandLineContext ctxt) {
        super(ctxt);
        this.jsp = new File(ctxt.getJspFile());
        this.outputDir = ctxt.getOptions().getScratchDir().getAbsolutePath();
        this.packageName = ctxt.getServletPackageName();
        if (this.packageName == null) {
            this.packageName = "";
        }
        this.pkgName = this.packageName;
        this.setMangler(this);
        this.className = this.getBaseClassName();
        if (ctxt.isOutputInDirs()) {
            String tmpDir = String.valueOf(this.outputDir) + File.separatorChar + this.pkgName.replace('.', File.separatorChar);
            File f = new File(tmpDir);
            if (!f.exists()) {
                if (f.mkdirs()) {
                    this.outputDir = tmpDir;
                }
            } else {
                this.outputDir = tmpDir;
            }
        }
        this.computeClassFileName();
        this.computeJavaFileName();
    }

    void computeClassFileName() {
        this.classFileName = String.valueOf(this.getBaseClassName()) + ".class";
        if (this.outputDir != null && !this.outputDir.equals("")) {
            this.classFileName = String.valueOf(this.outputDir) + File.separatorChar + this.classFileName;
        }
    }

    public final void computeJavaFileName() {
        this.javaFileName = String.valueOf(this.ctxt.getServletClassName()) + ".java";
        if ("null.java".equals(this.javaFileName)) {
            this.javaFileName = String.valueOf(this.getBaseClassName()) + ".java";
        }
        if (this.outputDir != null && !this.outputDir.equals("")) {
            this.javaFileName = String.valueOf(this.outputDir) + File.separatorChar + this.javaFileName;
        }
    }

    private final String getBaseClassName() {
        String className = this.ctxt.getServletClassName();
        if (className == null) {
            className = this.jsp.getName().endsWith(".jsp") ? this.jsp.getName().substring(0, this.jsp.getName().length() - 4) : this.jsp.getName();
        }
        int i = 0;
        while (i < keywords.length) {
            if (className.equals(keywords[i])) {
                className = String.valueOf(className) + "%";
            }
            ++i;
        }
        StringBuffer modifiedClassName = new StringBuffer();
        int i2 = 0;
        while (i2 < className.length()) {
            if (Character.isLetterOrDigit(className.charAt(i2))) {
                modifiedClassName.append(className.substring(i2, i2 + 1));
            } else {
                modifiedClassName.append(CommandLineCompiler.mangleChar(className.charAt(i2)));
            }
            ++i2;
        }
        return modifiedClassName.toString();
    }

    public final String getClassFileName() {
        return this.classFileName;
    }

    public final String getClassName() {
        return this.className;
    }

    private final String getInitialClassName() {
        return this.getBaseClassName();
    }

    public final String getJavaFileName() {
        return this.javaFileName;
    }

    public final String getPackageName() {
        return this.packageName;
    }

    public boolean isOutDated() {
        return true;
    }

    private static final String mangleChar(char ch) {
        if (ch == File.separatorChar) {
            ch = (char)47;
        }
        String s = Integer.toHexString(ch);
        int nzeros = 5 - s.length();
        char[] result = new char[6];
        result[0] = 95;
        int i = 1;
        while (i <= nzeros) {
            result[i] = 48;
            ++i;
        }
        int i2 = nzeros + 1;
        int j = 0;
        while (i2 < 6) {
            result[i2] = s.charAt(j);
            ++i2;
            ++j;
        }
        return new String(result);
    }
}

