/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import org.apache.tools.ant.util.FileNameMapper;

public class GlobPatternMapper
implements FileNameMapper {
    protected String fromPrefix = null;
    protected String fromPostfix = null;
    protected int prefixLength;
    protected int postfixLength;
    protected String toPrefix = null;
    protected String toPostfix = null;

    protected String extractVariablePart(String name) {
        return name.substring(this.prefixLength, name.length() - this.postfixLength);
    }

    public String[] mapFileName(String sourceFileName) {
        if (this.fromPrefix == null || !sourceFileName.startsWith(this.fromPrefix) || !sourceFileName.endsWith(this.fromPostfix)) {
            return null;
        }
        return new String[]{String.valueOf(this.toPrefix) + this.extractVariablePart(sourceFileName) + this.toPostfix};
    }

    public void setFrom(String from) {
        int index = from.lastIndexOf("*");
        if (index == -1) {
            this.fromPrefix = from;
            this.fromPostfix = "";
        } else {
            this.fromPrefix = from.substring(0, index);
            this.fromPostfix = from.substring(index + 1);
        }
        this.prefixLength = this.fromPrefix.length();
        this.postfixLength = this.fromPostfix.length();
    }

    public void setTo(String to) {
        int index = to.lastIndexOf("*");
        if (index == -1) {
            this.toPrefix = to;
            this.toPostfix = "";
        } else {
            this.toPrefix = to.substring(0, index);
            this.toPostfix = to.substring(index + 1);
        }
    }
}

