/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.util.Hashtable;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.TagCache;

public class TagLibraries {
    private Hashtable tagLibInfos = new Hashtable();
    private Hashtable tagCaches = new Hashtable();
    private ClassLoader cl;

    public TagLibraries(ClassLoader cl) {
        this.cl = cl;
    }

    public void addTagLibrary(String prefix, TagLibraryInfo tli) {
        this.tagLibInfos.put(prefix, tli);
    }

    public TagCache getTagCache(String prefix, String shortTagName) {
        return (TagCache)this.tagCaches.get(new TagID(prefix, shortTagName));
    }

    public TagLibraryInfo getTagLibInfo(String prefix) {
        return (TagLibraryInfo)this.tagLibInfos.get(prefix);
    }

    public boolean isUserDefinedTag(String prefix, String shortTagName) throws JasperException {
        TagLibraryInfo tli = (TagLibraryInfo)this.tagLibInfos.get(prefix);
        if (tli == null) {
            return false;
        }
        if (tli.getTag(shortTagName) != null) {
            return true;
        }
        throw new JasperException(Constants.getString("jsp.error.bad_tag", new Object[]{shortTagName, prefix}));
    }

    public void putTagCache(String prefix, String shortTagName, TagCache tc) {
        this.tagCaches.put(new TagID(prefix, shortTagName), tc);
    }

    private static class TagID {
        private String prefix;
        private String shortTagName;

        public TagID(String prefix, String shortTagName) {
            this.prefix = prefix;
            this.shortTagName = shortTagName;
        }

        public boolean equals(Object obj) {
            return this.prefix.equals(((TagID)obj).prefix) && this.shortTagName.equals(((TagID)obj).shortTagName);
        }

        public int hashCode() {
            return this.prefix.hashCode() + this.shortTagName.hashCode();
        }
    }
}

