/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.perforce;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Exec;

public class P4sync
extends Exec {
    private String p4user;
    private String p4port;
    private String directory;
    private boolean force;
    private String date;
    private String label;
    private String revision;
    private String changenum;
    private String error = "";

    public void execute() throws BuildException {
        String prefix;
        StringBuffer cmdline = new StringBuffer();
        String RevisionString = "";
        int nRevisions = 0;
        cmdline.append("p4");
        cmdline.append(" -s");
        if (this.p4user != null) {
            cmdline.append(" -u");
            cmdline.append(" " + this.p4user);
        }
        if (this.p4port != null) {
            cmdline.append(" -p");
            cmdline.append(" " + this.p4port);
        }
        cmdline.append(" sync");
        if (this.force) {
            cmdline.append(" -f");
        }
        if (this.directory == null) {
            throw new BuildException("dir= not specified for 'p4sync'");
        }
        if (this.label != null) {
            prefix = "";
            if (!this.label.startsWith("@")) {
                prefix = "@";
            }
            RevisionString = String.valueOf(prefix) + this.label;
            ++nRevisions;
        }
        if (this.changenum != null) {
            prefix = "";
            if (!this.changenum.startsWith("@")) {
                prefix = "@";
            }
            RevisionString = String.valueOf(prefix) + this.changenum;
            ++nRevisions;
        }
        if (this.date != null) {
            prefix = "";
            if (!this.date.startsWith("@")) {
                prefix = "@";
            }
            RevisionString = String.valueOf(prefix) + this.date;
            ++nRevisions;
        }
        if (this.revision != null) {
            RevisionString = this.revision.startsWith("#") ? this.revision : "#" + this.revision;
            ++nRevisions;
        }
        if (nRevisions > 1) {
            throw new BuildException("date/revision/label/changenumber are mutually exclusive - specify only one.");
        }
        cmdline.append(" " + this.directory + RevisionString);
        String command = cmdline.toString();
        System.out.println("executing: " + command);
        this.run(command);
        if (this.error.length() != 0) {
            throw new BuildException(this.error);
        }
    }

    protected void outputLog(String line, int messageLevel) {
        if (line.startsWith("error: ") && !line.endsWith("file(s) up-to-date.")) {
            this.error = String.valueOf(this.error) + line.substring(7);
        }
        super.outputLog(line, messageLevel);
    }

    public void setChange(String changenum) {
        this.changenum = changenum;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setLocalpath(String directory) {
        this.directory = directory;
    }

    public void setP4port(String p4port) {
        this.p4port = p4port;
    }

    public void setP4user(String p4user) {
        this.p4user = p4user;
    }

    public void setPort(String p4port) {
        this.p4port = p4port;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public void setUser(String p4user) {
        this.p4user = p4user;
    }

    public void setVersion(String revision) {
        this.revision = revision;
    }
}

