/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.request;

import java.io.File;
import java.util.Enumeration;
import java.util.Locale;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.request.DirHandler;
import org.apache.tomcat.request.FileHandler;
import org.apache.tomcat.util.FileUtil;
import org.apache.tomcat.util.RequestUtil;

public class StaticInterceptor
extends BaseInterceptor {
    int realFileNote = -1;
    int NONE_LOC = 0;
    int FILE_LOC = 1;
    int DOCB_LOC = 2;
    int localization = this.NONE_LOC;
    public static final String FILE_LOCALIZATION = "file";
    public static final String DOCBASE_LOCALIZATION = "docbase";
    public static final String NO_LOCALIZATION = "none";
    public static final String LOCALIZATION_PROPERTY = "localization";
    private boolean suppress = false;

    private static String concatPath(String s1, String s2) {
        if (s1.endsWith("/")) {
            if (s2.startsWith("/")) {
                return String.valueOf(s1) + s2.substring(1);
            }
            return String.valueOf(s1) + s2;
        }
        if (s2.startsWith("/")) {
            return String.valueOf(s1) + s2;
        }
        return String.valueOf(s1) + "/" + s2;
    }

    public void contextInit(Context ctx) throws TomcatException {
        FileHandler fileHandler = new FileHandler();
        DirHandler dirHandler = new DirHandler();
        fileHandler.setNoteId(this.realFileNote);
        dirHandler.setNoteId(this.realFileNote);
        this.debug = 0;
        ctx.addServlet(fileHandler);
        ctx.addServlet(dirHandler);
        fileHandler.setDebug(this.debug);
        dirHandler.setDebug(this.debug);
    }

    public void engineInit(ContextManager cm) throws TomcatException {
        super.engineInit(cm);
        try {
            this.realFileNote = cm.getNoteId(2, "static.realFile");
        }
        catch (TomcatException ex) {
            ex.printStackTrace();
            throw new RuntimeException("Invalid state ");
        }
    }

    public String getLocalization() {
        return this.localization == this.FILE_LOC ? FILE_LOCALIZATION : (this.localization == this.DOCB_LOC ? DOCBASE_LOCALIZATION : NO_LOCALIZATION);
    }

    public boolean getSuppress() {
        return this.suppress;
    }

    private String getWelcomeFile(Context context, File dir) {
        Enumeration enumeration = context.getWelcomeFiles();
        while (enumeration.hasMoreElements()) {
            String fileName = (String)enumeration.nextElement();
            File f = new File(dir, fileName);
            if (!f.exists()) continue;
            return fileName;
        }
        return null;
    }

    private String getWelcomeFile(Context context, File dir, Locale loc, Locale fbloc) {
        Enumeration enumeration = context.getWelcomeFiles();
        while (enumeration.hasMoreElements()) {
            String fileName = (String)enumeration.nextElement();
            int ftype = fileName.lastIndexOf(46);
            String fbasen = ftype != -1 ? fileName.substring(0, ftype) : fileName;
            String fPath = String.valueOf(dir.getAbsolutePath()) + File.separatorChar + fileName;
            String retPath = FileUtil.getLocalizedResource(fPath, loc, fbloc);
            if (!new File(retPath).exists()) continue;
            int pathPos = retPath.lastIndexOf(fbasen);
            return retPath.substring(pathPos);
        }
        return null;
    }

    public int requestMap(Request req) {
        File file;
        if (req.getWrapper() != null) {
            return 0;
        }
        Context ctx = req.getContext();
        String pathInfo = req.getServletPath();
        if (pathInfo == null) {
            pathInfo = "";
        }
        String absPath = null;
        absPath = this.localization == this.FILE_LOC ? ctx.getRealPath(pathInfo, RequestUtil.getLocale(req), Locale.getDefault()) : ctx.getRealPath(pathInfo);
        if (absPath == null) {
            return 0;
        }
        String requestURI = req.getRequestURI();
        if (this.debug > 0) {
            this.log("Requested: " + absPath);
        }
        if ((file = new File(absPath)).isFile()) {
            if (this.debug > 0) {
                this.log("Setting handler to file " + absPath);
            }
            req.setNote(this.realFileNote, absPath);
            req.setWrapper(ctx.getServletByName("tomcat.fileHandler"));
            return 0;
        }
        if (!file.isDirectory()) {
            if (this.debug > 0) {
                this.log("No file and no directory");
            }
            return 0;
        }
        String welcomeFile = null;
        welcomeFile = this.localization == this.FILE_LOC ? this.getWelcomeFile(ctx, file, RequestUtil.getLocale(req), Locale.getDefault()) : this.getWelcomeFile(ctx, file);
        if (this.debug > 0) {
            this.log("DefaultServlet: welcome file: " + welcomeFile);
        }
        if (welcomeFile == null) {
            if (this.suppress) {
                return 404;
            }
            req.setWrapper(ctx.getServletByName("tomcat.dirHandler"));
            if (this.debug > 0) {
                this.log("Dir handler");
            }
            return 0;
        }
        String redirectURI = null;
        redirectURI = StaticInterceptor.concatPath(requestURI, welcomeFile);
        req.setAttribute("javax.servlet.error.message", redirectURI);
        if (this.debug > 0) {
            this.log("Redirect " + redirectURI);
        }
        return 302;
    }

    public void setLocalization(String s) {
        if (FILE_LOCALIZATION.equals(s)) {
            this.localization = this.FILE_LOC;
        } else if (DOCBASE_LOCALIZATION.equals(s)) {
            this.localization = this.DOCB_LOC;
        }
    }

    public void setSuppress(boolean suppress) {
        this.suppress = suppress;
    }
}

