/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.request;

import java.io.File;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.ServletWrapper;
import org.apache.tomcat.util.RequestUtil;
import org.apache.tomcat.util.StringManager;

class DirHandler
extends ServletWrapper {
    private static final String datePattern = "EEE, dd MMM yyyyy HH:mm z";
    int realFileNote;

    DirHandler() {
        this.initialized = true;
        this.internal = true;
        this.name = "tomcat.dirHandler";
    }

    void displaySize(StringBuffer buf, int filesize) {
        int leftside = filesize / 1024;
        int rightside = filesize % 1024 / 103;
        if (leftside == 0 && rightside == 0 && filesize != 0) {
            rightside = 1;
        }
        buf.append(leftside).append(".").append(rightside);
        buf.append(" KB");
    }

    public void doService(Request req, Response res) throws Exception {
        PrintWriter out;
        String relPath;
        String relPathU;
        Locale locale = RequestUtil.getLocale(req);
        StringManager sm = StringManager.getManager("org.apache.tomcat.resources", locale);
        SimpleDateFormat dateFormat = new SimpleDateFormat(datePattern, locale);
        boolean inInclude = req.getChild() != null;
        Request subReq = req;
        if (inInclude) {
            subReq = req.getChild();
        }
        Context ctx = req.getContext();
        String pathInfo = subReq.getServletPath();
        if (pathInfo == null) {
            pathInfo = "";
        }
        String absPath = ctx.getRealPath(pathInfo);
        File file = new File(absPath);
        String requestURI = subReq.getRequestURI();
        String base = ctx.getAbsolutePath();
        if (absPath.length() > base.length() && ((relPathU = (relPath = absPath.substring(base.length() + 1)).toUpperCase()).startsWith("WEB-INF") || relPathU.startsWith("META-INF"))) {
            this.context.getContextManager().handleStatus(req, res, 404);
            return;
        }
        StringBuffer buf = new StringBuffer();
        if (!inInclude) {
            res.setContentType("text/html");
            buf.append("<html>\r\n");
            buf.append("<head>\r\n");
            buf.append("<title>").append(sm.getString("defaultservlet.directorylistingfor")).append(requestURI);
            buf.append("</title>\r\n</head><body bgcolor=white>\r\n");
        }
        buf.append("<table width=90% cellspacing=0 ");
        buf.append("cellpadding=5 align=center>");
        buf.append("<tr><td colspan=3><font size=+2><strong>");
        buf.append(sm.getString("defaultservlet.directorylistingfor")).append(requestURI);
        buf.append("</strong></td></tr>\r\n");
        if (!pathInfo.equals("/")) {
            buf.append("<tr><td colspan=3 bgcolor=#ffffff>");
            String toPath = requestURI;
            if (toPath.endsWith("/")) {
                toPath = toPath.substring(0, toPath.length() - 1);
            }
            if ((toPath = toPath.substring(0, toPath.lastIndexOf("/"))).length() == 0) {
                toPath = "/";
            }
            buf.append("<a href=\"" + toPath + "\"><tt>" + sm.getString("defaultservlet.upto") + toPath);
            buf.append("</tt></a></td></tr>\r\n");
        }
        String slashedRequestURI = null;
        slashedRequestURI = requestURI.endsWith("/") ? requestURI : String.valueOf(requestURI) + "/";
        String[] fileNames = file.list();
        boolean dirsHead = true;
        boolean shaderow = false;
        int i = 0;
        while (i < fileNames.length) {
            File f;
            String fileName = fileNames[i];
            if ((pathInfo.length() != 0 && !"/".equals(pathInfo) || !"WEB-INF".equalsIgnoreCase(fileName)) && !"META-INF".equalsIgnoreCase(fileName) && (f = new File(file, fileName)).isDirectory()) {
                if (dirsHead) {
                    dirsHead = false;
                    buf.append("<tr><td colspan=3 bgcolor=#cccccc>");
                    buf.append("<font size=+2><strong>").append(sm.getString("defaultservlet.subdirectories")).append("</strong>\r\n");
                    buf.append("</font></td></tr>\r\n");
                }
                String fileN = f.getName();
                buf.append("<tr");
                if (shaderow) {
                    buf.append(" bgcolor=#eeeeee");
                }
                shaderow ^= true;
                buf.append("><td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                buf.append("<tt><a href=\"").append(slashedRequestURI).append(fileN).append("\">").append(fileN).append("/</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;").append("</tt>\r\n");
                buf.append("</td><td><tt>&nbsp;&nbsp;</tt></td>");
                buf.append("<td align=right><tt>");
                buf.append(dateFormat.format(new Date(f.lastModified())));
                buf.append("</tt></td></tr>\r\n");
            }
            ++i;
        }
        shaderow = false;
        buf.append("<tr><td colspan=3 bgcolor=#ffffff>&nbsp;</td></tr>");
        boolean fileHead = true;
        int i2 = 0;
        while (i2 < fileNames.length) {
            File f = new File(file, fileNames[i2]);
            if (f.isFile()) {
                String fileN = f.getName();
                if (fileHead) {
                    fileHead = false;
                    buf.append("<tr><td colspan=4 bgcolor=#cccccc>");
                    buf.append("<font size=+2><strong>").append(sm.getString("defaultservlet.files")).append("</strong></font></td></tr>");
                }
                buf.append("<tr");
                if (shaderow) {
                    buf.append(" bgcolor=#eeeeee");
                }
                shaderow ^= true;
                buf.append("><td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n");
                buf.append("<tt><a href=\"").append(slashedRequestURI).append(fileN).append("\">").append(fileN).append("</a>");
                buf.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</tt>");
                buf.append("</td>\r\n");
                buf.append("<td align=right><tt>");
                this.displaySize(buf, (int)f.length());
                buf.append("</tt></td>");
                buf.append("<td align=right><tt>");
                buf.append(dateFormat.format(new Date(f.lastModified())));
                buf.append("</tt></td></tr>\r\n");
            }
            buf.append("\r\n");
            ++i2;
        }
        buf.append("<tr><td colspan=3 bgcolor=#ffffff>&nbsp;</td></tr>");
        buf.append("<tr><td colspan=3 bgcolor=#cccccc>");
        buf.append("<font size=-1>");
        buf.append("Tomcat Web Server");
        buf.append(" v");
        buf.append("3.2.1");
        buf.append("</font></td></tr></table>");
        if (!inInclude) {
            buf.append("</body></html>\r\n");
        }
        if (res.isUsingWriter()) {
            out = res.getWriter();
            out.print(buf);
        } else {
            out = res.getOutputStream();
            out.print(buf.toString());
        }
    }

    public void setNoteId(int n) {
        this.realFileNote = n;
    }
}

