/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ejb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.optional.ejb.DescriptorHandler;
import org.apache.tools.ant.taskdefs.optional.ejb.GenericDeploymentTool;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;

public class WeblogicDeploymentTool
extends GenericDeploymentTool {
    public static final String PUBLICID_EJB = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN";
    public static final String PUBLICID_WEBLOGIC = "-//BEA Systems, Inc.//DTD WebLogic 5.1.0 EJB//EN";
    protected static final String WL_DD = "weblogic-ejb-jar.xml";
    protected static final String WL_CMP_DD = "weblogic-cmp-rdbms-jar.xml";
    protected static final String DEFAULT_EJB_DTD_LOCATION = "/weblogic/ejb/deployment/xml/ejb-jar.dtd";
    protected static final String DEFAULT_WL_DTD_LOCATION = "/weblogic/ejb/deployment/xml/weblogic-ejb-jar.dtd";
    private String jarSuffix = ".jar";
    private String weblogicDTD;
    private String ejbDTD;
    private boolean keepgenerated = false;
    private String additionalArgs = "";
    private boolean keepGeneric = false;
    private String compiler = null;
    private boolean alwaysRebuild = true;
    private boolean oldCMP = true;

    protected void addVendorFiles(Hashtable ejbFiles, String baseName) {
        String ddPrefix = this.usingBaseJarName() ? "" : String.valueOf(baseName) + this.getBaseNameTerminator();
        File weblogicDD = new File(this.getDescriptorDir(), String.valueOf(ddPrefix) + WL_DD);
        if (!weblogicDD.exists()) {
            return;
        }
        ejbFiles.put("META-INF/weblogic-ejb-jar.xml", weblogicDD);
        if (this.oldCMP) {
            this.log("The old method for locating CMP files has been DEPRECATED.", 2);
            this.log("Please adjust your weblogic descriptor and set oldCMP=\"false\" to use the new CMP descriptor inclusion mechanism. ", 2);
            File weblogicCMPDD = new File(this.getDescriptorDir(), String.valueOf(ddPrefix) + WL_CMP_DD);
            if (weblogicCMPDD.exists()) {
                ejbFiles.put("META-INF/weblogic-cmp-rdbms-jar.xml", weblogicCMPDD);
            }
        } else {
            try {
                File ejbDescriptor = (File)ejbFiles.get("META-INF/ejb-jar.xml");
                SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
                saxParserFactory.setValidating(true);
                SAXParser saxParser = saxParserFactory.newSAXParser();
                DescriptorHandler handler = this.getWebglogicDescriptorHandler(ejbDescriptor.getParentFile());
                saxParser.parse(new InputSource(new FileInputStream(weblogicDD)), (HandlerBase)handler);
                Hashtable ht = handler.getFiles();
                Enumeration e = ht.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    ejbFiles.put(key, ht.get(key));
                }
            }
            catch (Exception e) {
                String msg = "Exception while adding Vendor specific files: " + e.toString();
                throw new BuildException(msg, e);
            }
        }
    }

    private void buildWeblogicJar(File sourceJar, File destJar) {
        Java javaTask = null;
        try {
            String args = this.additionalArgs;
            if (this.keepgenerated) {
                args = String.valueOf(args) + " -keepgenerated";
            }
            if (this.compiler != null) {
                args = String.valueOf(args) + " -compiler " + this.compiler;
            }
            args = String.valueOf(args) + " -noexit " + sourceJar.getPath() + " " + destJar.getPath();
            javaTask = (Java)this.getTask().getProject().createTask("java");
            javaTask.setClassname("weblogic.ejbc");
            Commandline.Argument arguments = javaTask.createArg();
            arguments.setLine(args);
            Path classpath = this.getClasspath();
            if (classpath != null) {
                javaTask.setClasspath(classpath);
                javaTask.setFork(true);
            } else {
                javaTask.setFork(false);
            }
            this.log("Calling weblogic.ejbc for " + sourceJar.toString(), 3);
            javaTask.execute();
        }
        catch (Exception e) {
            String msg = "Exception while calling ejbc. Details: " + e.toString();
            throw new BuildException(msg, e);
        }
    }

    protected ClassLoader getClassLoaderFromJar(File classjar) throws IOException {
        Path lookupPath = new Path(this.getTask().getProject());
        lookupPath.setLocation(classjar);
        Path classpath = this.getClasspath();
        if (classpath != null) {
            lookupPath.append(classpath);
        }
        return new AntClassLoader(this.getTask().getProject(), lookupPath);
    }

    protected DescriptorHandler getDescriptorHandler(File srcDir) {
        DescriptorHandler handler = new DescriptorHandler(srcDir);
        this.registerDTD(handler, PUBLICID_EJB, this.ejbDTD == null ? DEFAULT_EJB_DTD_LOCATION : this.ejbDTD);
        return handler;
    }

    File getVendorOutputJarFile(String baseName) {
        return new File(this.getDestDir(), String.valueOf(baseName) + this.jarSuffix);
    }

    protected DescriptorHandler getWebglogicDescriptorHandler(File srcDir) {
        DescriptorHandler handler = new DescriptorHandler(srcDir){

            protected void processElement() {
                if (this.currentElement.equals("type-storage")) {
                    String fileNameWithMETA = this.currentText;
                    String fileName = fileNameWithMETA.substring("META-INF/".length(), fileNameWithMETA.length());
                    File descriptorFile = new File(WeblogicDeploymentTool.this.getDescriptorDir(), fileName);
                    this.ejbFiles.put(fileNameWithMETA, descriptorFile);
                }
            }
        };
        this.registerDTD(handler, PUBLICID_WEBLOGIC, this.weblogicDTD == null ? DEFAULT_WL_DTD_LOCATION : this.weblogicDTD);
        return handler;
    }

    protected boolean isRebuildRequired(File genericJarFile, File weblogicJarFile) {
        ZipOutputStream newJarStream;
        File newWLJarFile;
        ZipFile wlJar;
        boolean rebuild;
        block36: {
            rebuild = false;
            ZipFile genericJar = null;
            wlJar = null;
            newWLJarFile = null;
            newJarStream = null;
            try {
                try {
                    this.log("Checking if weblogic Jar needs to be rebuilt for jar " + weblogicJarFile.getName(), 3);
                    if (genericJarFile.exists() && genericJarFile.isFile() && weblogicJarFile.exists() && weblogicJarFile.isFile()) {
                        genericJar = new JarFile(genericJarFile);
                        wlJar = new JarFile(weblogicJarFile);
                        Hashtable<String, JarEntry> genericEntries = new Hashtable<String, JarEntry>();
                        Hashtable<String, JarEntry> wlEntries = new Hashtable<String, JarEntry>();
                        Hashtable<String, JarEntry> replaceEntries = new Hashtable<String, JarEntry>();
                        Enumeration<JarEntry> e = ((JarFile)genericJar).entries();
                        while (e.hasMoreElements()) {
                            JarEntry je = e.nextElement();
                            genericEntries.put(je.getName().replace('\\', '/'), je);
                        }
                        Enumeration<JarEntry> e2 = ((JarFile)wlJar).entries();
                        while (e2.hasMoreElements()) {
                            JarEntry je = e2.nextElement();
                            wlEntries.put(je.getName(), je);
                        }
                        ClassLoader genericLoader = this.getClassLoaderFromJar(genericJarFile);
                        Enumeration e3 = genericEntries.keys();
                        while (e3.hasMoreElements()) {
                            String filepath = (String)e3.nextElement();
                            if (wlEntries.containsKey(filepath)) {
                                JarEntry genericEntry = (JarEntry)genericEntries.get(filepath);
                                JarEntry wlEntry = (JarEntry)wlEntries.get(filepath);
                                if (genericEntry.getCrc() == wlEntry.getCrc() && genericEntry.getSize() == wlEntry.getSize()) continue;
                                if (genericEntry.getName().endsWith(".class")) {
                                    String classname = genericEntry.getName().replace(File.separatorChar, '.');
                                    Class<?> genclass = genericLoader.loadClass(classname = classname.substring(0, classname.lastIndexOf(".class")));
                                    if (genclass.isInterface()) {
                                        this.log("Interface " + genclass.getName() + " has changed", 3);
                                        rebuild = true;
                                        break;
                                    }
                                    replaceEntries.put(filepath, genericEntry);
                                    continue;
                                }
                                this.log("Non class file " + genericEntry.getName() + " has changed", 3);
                                rebuild = true;
                                break;
                            }
                            this.log("File " + filepath + " not present in weblogic jar", 3);
                            rebuild = true;
                            break;
                        }
                        if (!rebuild) {
                            this.log("No rebuild needed - updating jar", 3);
                            newWLJarFile = new File(String.valueOf(weblogicJarFile.getAbsolutePath()) + ".temp");
                            if (newWLJarFile.exists()) {
                                newWLJarFile.delete();
                            }
                            newJarStream = new JarOutputStream(new FileOutputStream(newWLJarFile));
                            Enumeration e4 = wlEntries.elements();
                            while (e4.hasMoreElements()) {
                                int bytesRead;
                                InputStream is;
                                byte[] buffer = new byte[1024];
                                JarEntry je = (JarEntry)e4.nextElement();
                                if (replaceEntries.containsKey(je.getName())) {
                                    this.log("Updating Bean class from generic Jar " + je.getName(), 3);
                                    je = (JarEntry)replaceEntries.get(je.getName());
                                    is = ((JarFile)genericJar).getInputStream(je);
                                } else {
                                    is = ((JarFile)wlJar).getInputStream(je);
                                }
                                ((JarOutputStream)newJarStream).putNextEntry(new JarEntry(je.getName()));
                                while ((bytesRead = is.read(buffer)) != -1) {
                                    newJarStream.write(buffer, 0, bytesRead);
                                }
                                is.close();
                            }
                        } else {
                            this.log("Weblogic Jar rebuild needed due to changed interface or XML", 3);
                        }
                    } else {
                        rebuild = true;
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    String cnfmsg = "ClassNotFoundException while processing ejb-jar file. Details: " + cnfe.getMessage();
                    throw new BuildException(cnfmsg, cnfe);
                }
                catch (IOException ioe) {
                    String msg = "IOException while processing ejb-jar file . Details: " + ioe.getMessage();
                    throw new BuildException(msg, ioe);
                }
                Object var9_25 = null;
                if (genericJar == null) break block36;
            }
            catch (Throwable throwable) {
                Object var9_26 = null;
                if (genericJar != null) {
                    try {
                        genericJar.close();
                    }
                    catch (IOException iOException) {}
                }
                if (wlJar != null) {
                    try {
                        wlJar.close();
                    }
                    catch (IOException iOException) {}
                }
                if (newJarStream != null) {
                    try {
                        newJarStream.close();
                    }
                    catch (IOException iOException) {}
                    weblogicJarFile.delete();
                    newWLJarFile.renameTo(weblogicJarFile);
                    if (!weblogicJarFile.exists()) {
                        rebuild = true;
                    }
                }
                throw throwable;
            }
            try {
                genericJar.close();
            }
            catch (IOException iOException) {}
        }
        if (wlJar != null) {
            try {
                wlJar.close();
            }
            catch (IOException iOException) {}
        }
        if (newJarStream != null) {
            try {
                newJarStream.close();
            }
            catch (IOException iOException) {}
            weblogicJarFile.delete();
            newWLJarFile.renameTo(weblogicJarFile);
            if (!weblogicJarFile.exists()) {
                rebuild = true;
            }
        }
        return rebuild;
    }

    private void registerDTD(DescriptorHandler handler, String publicId, String dtdLocation) {
        File dtdFile = new File(dtdLocation);
        if (dtdFile.exists()) {
            handler.registerFileDTD(publicId, dtdFile);
        } else {
            handler.registerResourceDTD(publicId, dtdLocation);
        }
    }

    public void setArgs(String args) {
        this.additionalArgs = args;
    }

    public void setCompiler(String compiler) {
        this.compiler = compiler;
    }

    public void setEJBdtd(String inString) {
        this.ejbDTD = inString;
    }

    public void setKeepgenerated(String inValue) {
        this.keepgenerated = Boolean.valueOf(inValue);
    }

    public void setKeepgeneric(boolean inValue) {
        this.keepGeneric = inValue;
    }

    public void setOldCMP(boolean oldCMP) {
        this.oldCMP = oldCMP;
    }

    public void setRebuild(boolean rebuild) {
        this.alwaysRebuild = rebuild;
    }

    public void setSuffix(String inString) {
        this.jarSuffix = inString;
    }

    public void setWeblogicdtd(String inString) {
        this.weblogicDTD = inString;
    }

    public void validateConfigured() throws BuildException {
        super.validateConfigured();
    }

    protected void writeJar(String baseName, File jarFile, Hashtable files) throws BuildException {
        File genericJarFile = super.getVendorOutputJarFile(baseName);
        super.writeJar(baseName, genericJarFile, files);
        if (this.alwaysRebuild || this.isRebuildRequired(genericJarFile, jarFile)) {
            this.buildWeblogicJar(genericJarFile, jarFile);
        }
        if (!this.keepGeneric) {
            this.log("deleting generic jar " + genericJarFile.toString(), 3);
            genericJarFile.delete();
        }
    }
}

