/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.dotnet;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.optional.dotnet.NetCommand;

public class Ilasm
extends MatchingTask {
    protected static final String exe_name = "ilasm";
    protected static final String file_ext = "il";
    protected static final String file_pattern = "**/*.il";
    protected static final String exe_title = "ilasm";
    private File _srcDir;
    protected String _targetType;
    protected String _owner;
    protected boolean _verbose;
    protected boolean _listing;
    protected String _outputFile;
    protected File _resourceFile;
    protected boolean _failOnError;
    protected boolean _debug;
    protected String _extraOptions;

    public Ilasm() {
        this.Clear();
        this.setIncludes(file_pattern);
    }

    public void Clear() {
        this._targetType = null;
        this._srcDir = null;
        this._listing = false;
        this._verbose = false;
        this._debug = true;
        this._owner = null;
        this._outputFile = null;
        this._failOnError = true;
        this._resourceFile = null;
        this._owner = null;
        this._extraOptions = null;
    }

    public void execute() throws BuildException {
        if (this._srcDir == null) {
            this._srcDir = this.project.resolveFile(".");
        }
        DirectoryScanner scanner = super.getDirectoryScanner(this._srcDir);
        String[] dependencies = scanner.getIncludedFiles();
        this.log("assembling " + dependencies.length + " file" + (dependencies.length == 1 ? "" : "s"));
        String baseDir = scanner.getBasedir().toString();
        int i = 0;
        while (i < dependencies.length) {
            String targetFile = dependencies[i];
            targetFile = String.valueOf(baseDir) + File.separator + targetFile;
            this.executeOneFile(targetFile);
            ++i;
        }
    }

    public void executeOneFile(String targetFile) throws BuildException {
        NetCommand command = new NetCommand(this, "ilasm", "ilasm");
        command.setFailOnError(this.getFailFailOnError());
        command.setTraceCommandLine(true);
        command.addArgument(this.getDebugParameter());
        command.addArgument(this.getTargetTypeParameter());
        command.addArgument(this.getListingParameter());
        command.addArgument(this.getOutputFileParameter());
        command.addArgument(this.getOwnerParameter());
        command.addArgument(this.getResourceFileParameter());
        command.addArgument(this.getVerboseParameter());
        command.addArgument(this.getExtraOptionsParameter());
        command.addArgument(targetFile);
        command.runCommand();
    }

    public boolean getDebug() {
        return this._debug;
    }

    protected String getDebugParameter() {
        return this._debug ? "/debug" : null;
    }

    public String getExtraOptions() {
        return this._extraOptions;
    }

    protected String getExtraOptionsParameter() {
        if (this._extraOptions != null && this._extraOptions.length() != 0) {
            return this._extraOptions;
        }
        return null;
    }

    public boolean getFailFailOnError() {
        return this._failOnError;
    }

    protected String getListingParameter() {
        return this._listing ? "/listing" : "/nolisting";
    }

    protected String getOutputFileParameter() {
        if (this._outputFile == null || this._outputFile.length() == 0) {
            return null;
        }
        File f = this.project.resolveFile(this._outputFile);
        return "/output=" + f.toString();
    }

    protected String getOwnerParameter() {
        if (this.notEmpty(this._owner)) {
            return "/owner=" + this._owner;
        }
        return null;
    }

    protected String getResourceFileParameter() {
        if (this._resourceFile != null) {
            return "/resource=" + this._resourceFile.toString();
        }
        return null;
    }

    public String getTargetType() {
        return this._targetType;
    }

    protected String getTargetTypeParameter() {
        if (!this.notEmpty(this._targetType)) {
            return null;
        }
        if (this._targetType.equals("exe")) {
            return "/exe";
        }
        if (this._targetType.equals("library")) {
            return "/dll";
        }
        return null;
    }

    protected String getVerboseParameter() {
        return this._verbose ? null : "/quiet";
    }

    protected boolean notEmpty(String s) {
        return s != null && s.length() != 0;
    }

    public void setDebug(boolean f) {
        this._debug = f;
    }

    public void setExtraOptions(String extraOptions) {
        this._extraOptions = extraOptions;
    }

    public void setFailOnError(boolean b) {
        this._failOnError = b;
    }

    public void setListing(boolean b) {
        this._listing = b;
    }

    public void setOutputFile(String params) {
        this._outputFile = params;
    }

    public void setOwner(String s) {
        this._owner = s;
    }

    public void setResourceFile(String fileName) {
        this._resourceFile = this.project.resolveFile(fileName);
    }

    public void setSrcDir(String srcDirName) {
        this._srcDir = this.project.resolveFile(srcDirName);
    }

    public void setTargetType(String targetType) throws BuildException {
        if (!(targetType = targetType.toLowerCase()).equals("exe") && !targetType.equals("library")) {
            throw new BuildException("targetType " + targetType + " is not a valid type");
        }
        this._targetType = targetType;
    }

    public void setVerbose(boolean b) {
        this._verbose = b;
    }
}

