/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.clearcase;

import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.Commandline;

public abstract class ClearCase
extends Task {
    private String m_ClearToolDir = "";
    private String m_viewPath = null;
    private static final String CLEARTOOL_EXE = "cleartool";
    public static final String COMMAND_UPDATE = "update";
    public static final String COMMAND_CHECKOUT = "checkout";
    public static final String COMMAND_CHECKIN = "checkin";
    public static final String COMMAND_UNCHECKOUT = "uncheckout";

    protected final String getClearToolCommand() {
        String toReturn = this.m_ClearToolDir;
        if (!toReturn.equals("") && !toReturn.endsWith("/")) {
            toReturn = String.valueOf(toReturn) + "/";
        }
        toReturn = String.valueOf(toReturn) + CLEARTOOL_EXE;
        return toReturn;
    }

    public String getViewPath() {
        return this.m_viewPath;
    }

    protected int run(Commandline cmd) {
        try {
            Project aProj = this.getProject();
            Execute exe = new Execute(new LogStreamHandler(this, 2, 1));
            exe.setAntRun(aProj);
            exe.setWorkingDirectory(aProj.getBaseDir());
            exe.setCommandline(cmd.getCommandline());
            return exe.execute();
        }
        catch (IOException e) {
            throw new BuildException(e, this.location);
        }
    }

    public final void setClearToolDir(String dir) {
        this.m_ClearToolDir = Project.translatePath(dir);
    }

    public final void setViewPath(String viewPath) {
        this.m_viewPath = viewPath;
    }
}

