/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.apache.tools.ant.util.SourceFileScanner;
import sun.rmi.rmic.Main;

public class Rmic
extends MatchingTask {
    private File baseDir;
    private String classname;
    private File sourceBase;
    private String stubVersion;
    private Path compileClasspath;
    private boolean verify = false;
    private boolean filtering = false;
    private boolean iiop = false;
    private String iiopopts;
    private boolean idl = false;
    private String idlopts;
    private boolean debug = false;
    private Vector compileList = new Vector();
    private ClassLoader loader = null;

    public void setBase(File file) {
        this.baseDir = file;
    }

    public void setClassname(String string) {
        this.classname = string;
    }

    public void setSourceBase(File file) {
        this.sourceBase = file;
    }

    public void setStubVersion(String string) {
        this.stubVersion = string;
    }

    public void setFiltering(boolean bl) {
        this.filtering = bl;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void setClasspath(Path path) {
        if (this.compileClasspath == null) {
            this.compileClasspath = path;
        } else {
            this.compileClasspath.append(path);
        }
    }

    public Path createClasspath() {
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.project);
        }
        return this.compileClasspath.createPath();
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public void setVerify(boolean bl) {
        this.verify = bl;
    }

    public void setIiop(boolean bl) {
        this.iiop = bl;
    }

    public void setIiopopts(String string) {
        this.iiopopts = string;
    }

    public void setIdl(boolean bl) {
        this.idl = bl;
    }

    public void setIdlopts(String string) {
        this.idlopts = string;
    }

    public void execute() throws BuildException {
        int n;
        int n2;
        Main main;
        Object object;
        if (this.baseDir == null) {
            throw new BuildException("base attribute must be set!", this.location);
        }
        if (!this.baseDir.exists()) {
            throw new BuildException("base does not exist!", this.location);
        }
        if (this.verify) {
            this.log("Verify has been turned on.", 2);
        }
        if (this.iiop) {
            this.log("IIOP has been turned on.", 2);
            if (this.iiopopts != null) {
                this.log("IIOP Options: " + this.iiopopts, 2);
            }
        }
        if (this.idl) {
            this.log("IDL has been turned on.", 2);
            if (this.idlopts != null) {
                this.log("IDL Options: " + this.idlopts, 2);
            }
        }
        Path path = this.getCompileClasspath(this.baseDir);
        this.loader = new AntClassLoader(this.project, path);
        if (this.classname == null) {
            object = this.getDirectoryScanner(this.baseDir);
            main = ((DirectoryScanner)object).getIncludedFiles();
            this.scanDir(this.baseDir, (String[])main);
        } else {
            this.scanDir(this.baseDir, new String[]{this.classname.replace('.', File.separatorChar) + ".class"});
        }
        object = new LogOutputStream(this, 1);
        main = new Main((OutputStream)object, "rmic");
        Commandline commandline = new Commandline();
        commandline.createArgument().setValue("-d");
        commandline.createArgument().setFile(this.baseDir);
        commandline.createArgument().setValue("-classpath");
        commandline.createArgument().setPath(path);
        if (null != this.stubVersion) {
            if ("1.1".equals(this.stubVersion)) {
                commandline.createArgument().setValue("-v1.1");
            } else if ("1.2".equals(this.stubVersion)) {
                commandline.createArgument().setValue("-v1.2");
            } else {
                commandline.createArgument().setValue("-vcompat");
            }
        }
        if (null != this.sourceBase) {
            commandline.createArgument().setValue("-keepgenerated");
        }
        if (this.iiop) {
            commandline.createArgument().setValue("-iiop");
            if (this.iiopopts != null) {
                commandline.createArgument().setValue(this.iiopopts);
            }
        }
        if (this.idl) {
            commandline.createArgument().setValue("-idl");
            if (this.idlopts != null) {
                commandline.createArgument().setValue(this.idlopts);
            }
        }
        if (this.debug) {
            commandline.createArgument().setValue("-g");
        }
        if ((n2 = this.compileList.size()) > 0) {
            this.log("RMI Compiling " + n2 + " class" + (n2 > 1 ? "es" : "") + " to " + this.baseDir, 2);
            n = 0;
            while (n < n2) {
                commandline.createArgument().setValue((String)this.compileList.elementAt(n));
                ++n;
            }
            this.log("Compilation args: " + commandline.toString(), 3);
            main.compile(commandline.getArguments());
        }
        if (null != this.sourceBase) {
            n = 0;
            while (n < n2) {
                this.moveGeneratedFile(this.baseDir, this.sourceBase, (String)this.compileList.elementAt(n));
                ++n;
            }
        }
        this.compileList.removeAllElements();
    }

    private void moveGeneratedFile(File file, File file2, String string) throws BuildException {
        String string2 = string.replace('.', File.separatorChar) + "_Stub.java";
        File file3 = new File(file, string2);
        File file4 = new File(file2, string2);
        try {
            this.project.copyFile(file3, file4, this.filtering);
            file3.delete();
        }
        catch (IOException iOException) {
            String string3 = "Failed to copy " + file3 + " to " + file4 + " due to " + iOException.getMessage();
            throw new BuildException(string3, iOException, this.location);
        }
        if (!"1.2".equals(this.stubVersion)) {
            String string4 = string.replace('.', '/') + "_Skel.java";
            File file5 = new File(file, string4);
            File file6 = new File(file2, string4);
            try {
                this.project.copyFile(file5, file6, this.filtering);
                file5.delete();
            }
            catch (IOException iOException) {
                String string5 = "Failed to copy " + file5 + " to " + file6 + " due to " + iOException.getMessage();
                throw new BuildException(string5, iOException, this.location);
            }
        }
    }

    protected void scanDir(File file, String[] stringArray) {
        SourceFileScanner sourceFileScanner = new SourceFileScanner(this);
        String[] stringArray2 = sourceFileScanner.restrict(stringArray, file, file, new RmicFileNameMapper());
        int n = 0;
        while (n < stringArray2.length) {
            String string = stringArray2[n].replace(File.separatorChar, '.');
            string = string.substring(0, string.indexOf(".class"));
            this.compileList.addElement(string);
            ++n;
        }
    }

    private Path getCompileClasspath(File file) {
        String string;
        Path path = new Path(this.project, file.getAbsolutePath());
        if (this.compileClasspath == null) {
            path.addExisting(Path.systemClasspath);
        } else {
            path.addExisting(this.compileClasspath.concatSystemClasspath());
        }
        if (Project.getJavaVersion().startsWith("1.2") && (string = System.getProperty("sun.boot.class.path")) != null) {
            path.addExisting(new Path(this.project, string));
        }
        return path;
    }

    private class RmicFileNameMapper
    implements FileNameMapper {
        private GlobPatternMapper stubMapper = new GlobPatternMapper();
        private GlobPatternMapper skelMapper;
        static /* synthetic */ Class class$java$rmi$Remote;

        RmicFileNameMapper() {
            this.stubMapper.setFrom("*.class");
            this.stubMapper.setTo("*_Stub.class");
            if (!"1.2".equals(Rmic.this.stubVersion)) {
                this.skelMapper = new GlobPatternMapper();
                this.skelMapper.setFrom("*.class");
                this.skelMapper.setTo("*_Skel.class");
            }
        }

        public void setFrom(String string) {
        }

        public void setTo(String string) {
        }

        public String[] mapFileName(String string) {
            String[] stringArray = this.stubMapper.mapFileName(string);
            if (stringArray == null || string.endsWith("_Stub.class") || string.endsWith("_Skel.class")) {
                return null;
            }
            String string2 = string.replace(File.separatorChar, '.');
            string2 = string2.substring(0, string2.indexOf(".class"));
            if (Rmic.this.verify) {
                try {
                    Class<?> clazz = Rmic.this.loader.loadClass(string2);
                    if (clazz.isInterface() || !this.isValidRmiRemote(clazz)) {
                        return null;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Rmic.this.log("Unable to verify class " + string2 + ". It could not be found.", 1);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    Rmic.this.log("Unable to verify class " + string2 + ". It is not defined.", 1);
                }
            }
            if (this.skelMapper != null) {
                return new String[]{stringArray[0], this.skelMapper.mapFileName(string)[0]};
            }
            return stringArray;
        }

        private boolean isValidRmiRemote(Class clazz) {
            Class clazz2;
            Class clazz3 = clazz2 = class$java$rmi$Remote == null ? (class$java$rmi$Remote = RmicFileNameMapper.class$("java.rmi.Remote")) : class$java$rmi$Remote;
            if (clazz2.equals(clazz)) {
                return true;
            }
            Class<?>[] classArray = clazz.getInterfaces();
            if (classArray != null) {
                int n = 0;
                while (n < classArray.length) {
                    if (clazz2.equals(classArray[n])) {
                        return true;
                    }
                    if (this.isValidRmiRemote(classArray[n])) {
                        return true;
                    }
                    ++n;
                }
            }
            return false;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

