/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.ant;

import fr.jayasoft.ivy.DefaultModuleDescriptor;
import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.ModuleId;
import fr.jayasoft.ivy.ModuleRevisionId;
import fr.jayasoft.ivy.ant.IvyTask;
import fr.jayasoft.ivy.filter.FilterHelper;
import fr.jayasoft.ivy.report.ResolveReport;
import fr.jayasoft.ivy.report.XmlReportOutputter;
import fr.jayasoft.ivy.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.XSLTProcess;

public class IvyRepositoryReport
extends IvyTask {
    private String _organisation = "*";
    private String _module;
    private String _branch;
    private String _revision = "latest.integration";
    private File _cache;
    private String _matcher = "exactOrRegexp";
    private File _todir = new File(".");
    private boolean _graph = false;
    private boolean _dot = false;
    private boolean _xml = true;
    private boolean _xsl = false;
    private String _xslFile;
    private String _outputname = "ivy-repository-report";
    private String _xslext = "html";
    private List _params = new ArrayList();

    public void execute() throws BuildException {
        Ivy ivy = this.getIvyInstance();
        if (this._cache == null) {
            this._cache = ivy.getDefaultCache();
        }
        if (this._xsl && this._xslFile == null) {
            throw new BuildException("xsl file is mandatory when using xsl generation");
        }
        if (this._module == null && "exact".equals(this._matcher)) {
            throw new BuildException("no module name provided for ivy repository graph task: It can either be set explicitely via the attribute 'module' or via 'ivy.module' property or a prior call to <resolve/>");
        }
        if (this._module == null && !"exact".equals(this._matcher)) {
            this._module = "*";
        }
        ModuleRevisionId mrid = ModuleRevisionId.newInstance(this._organisation, this._module, this._revision);
        try {
            ModuleId[] mids = ivy.listModules(new ModuleId(this._organisation, this._module), ivy.getMatcher(this._matcher));
            ModuleRevisionId[] mrids = new ModuleRevisionId[mids.length];
            for (int i = 0; i < mrids.length; ++i) {
                mrids[i] = this._branch != null ? new ModuleRevisionId(mids[i], this._branch, this._revision) : new ModuleRevisionId(mids[i], this._revision);
            }
            DefaultModuleDescriptor md = DefaultModuleDescriptor.newCallerInstance(mrids, true, false);
            ResolveReport report = ivy.resolve(md, new String[]{"*"}, this._cache, null, this.doValidate(ivy), false, true, false, false, FilterHelper.NO_FILTER);
            new XmlReportOutputter().output(report, this._cache);
            if (this._graph) {
                this.gengraph(this._cache, md.getModuleRevisionId().getOrganisation(), md.getModuleRevisionId().getName());
            }
            if (this._dot) {
                this.gendot(this._cache, md.getModuleRevisionId().getOrganisation(), md.getModuleRevisionId().getName());
            }
            if (this._xml) {
                FileUtil.copy(new File(this._cache, XmlReportOutputter.getReportFileName(md.getModuleRevisionId().getModuleId(), "default")), new File(this._todir, this._outputname + ".xml"), null);
            }
            if (this._xsl) {
                this.genreport(this._cache, md.getModuleRevisionId().getOrganisation(), md.getModuleRevisionId().getName());
            }
        }
        catch (Exception e) {
            throw new BuildException("impossible to generate graph for " + mrid + ": " + e, (Throwable)e);
        }
    }

    private void genreport(File cache, String organisation, String module) throws IOException {
        XSLTProcess xslt = new XSLTProcess();
        xslt.setTaskName(this.getTaskName());
        xslt.setProject(this.getProject());
        xslt.init();
        xslt.setIn(new File(cache, XmlReportOutputter.getReportFileName(new ModuleId(organisation, module), "default")));
        xslt.setOut(new File(this._todir, this._outputname + "." + this._xslext));
        xslt.setStyle(this._xslFile);
        XSLTProcess.Param param = xslt.createParam();
        param.setName("extension");
        param.setExpression(this._xslext);
        Iterator it = this._params.iterator();
        while (it.hasNext()) {
            param = (XSLTProcess.Param)it.next();
            XSLTProcess.Param realParam = xslt.createParam();
            realParam.setName(param.getName());
            realParam.setExpression(param.getExpression());
        }
        xslt.execute();
    }

    private void gengraph(File cache, String organisation, String module) throws IOException {
        this.gen(cache, organisation, module, this.getGraphStylePath(cache), "graphml");
    }

    private String getGraphStylePath(File cache) throws IOException {
        File style = new File(cache, "ivy-report-graph-all.xsl");
        FileUtil.copy(XmlReportOutputter.class.getResourceAsStream("ivy-report-graph-all.xsl"), style, null);
        return style.getAbsolutePath();
    }

    private void gendot(File cache, String organisation, String module) throws IOException {
        this.gen(cache, organisation, module, this.getDotStylePath(cache), "dot");
    }

    private String getDotStylePath(File cache) throws IOException {
        File style = new File(cache, "ivy-report-dot-all.xsl");
        FileUtil.copy(XmlReportOutputter.class.getResourceAsStream("ivy-report-dot-all.xsl"), style, null);
        return style.getAbsolutePath();
    }

    private void gen(File cache, String organisation, String module, String style, String ext) throws IOException {
        XSLTProcess xslt = new XSLTProcess();
        xslt.setTaskName(this.getTaskName());
        xslt.setProject(this.getProject());
        xslt.init();
        xslt.setIn(new File(cache, XmlReportOutputter.getReportFileName(new ModuleId(organisation, module), "default")));
        xslt.setOut(new File(this._todir, this._outputname + "." + ext));
        xslt.setBasedir(cache);
        xslt.setStyle(style);
        xslt.execute();
    }

    public File getTodir() {
        return this._todir;
    }

    public void setTodir(File todir) {
        this._todir = todir;
    }

    public boolean isGraph() {
        return this._graph;
    }

    public void setGraph(boolean graph) {
        this._graph = graph;
    }

    public String getXslfile() {
        return this._xslFile;
    }

    public void setXslfile(String xslFile) {
        this._xslFile = xslFile;
    }

    public boolean isXml() {
        return this._xml;
    }

    public void setXml(boolean xml) {
        this._xml = xml;
    }

    public boolean isXsl() {
        return this._xsl;
    }

    public void setXsl(boolean xsl) {
        this._xsl = xsl;
    }

    public String getXslext() {
        return this._xslext;
    }

    public void setXslext(String xslext) {
        this._xslext = xslext;
    }

    public XSLTProcess.Param createParam() {
        XSLTProcess.Param result = new XSLTProcess.Param();
        this._params.add(result);
        return result;
    }

    public String getOutputname() {
        return this._outputname;
    }

    public void setOutputname(String outputpattern) {
        this._outputname = outputpattern;
    }

    public File getCache() {
        return this._cache;
    }

    public void setCache(File cache) {
        this._cache = cache;
    }

    public String getMatcher() {
        return this._matcher;
    }

    public void setMatcher(String matcher) {
        this._matcher = matcher;
    }

    public String getModule() {
        return this._module;
    }

    public void setModule(String module) {
        this._module = module;
    }

    public String getOrganisation() {
        return this._organisation;
    }

    public void setOrganisation(String organisation) {
        this._organisation = organisation;
    }

    public String getRevision() {
        return this._revision;
    }

    public void setRevision(String revision) {
        this._revision = revision;
    }

    public String getBranch() {
        return this._branch;
    }

    public void setBranch(String branch) {
        this._branch = branch;
    }

    public boolean isDot() {
        return this._dot;
    }

    public void setDot(boolean dot) {
        this._dot = dot;
    }
}

