/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.repository.file;

import fr.jayasoft.ivy.repository.Resource;
import fr.jayasoft.ivy.repository.file.FileRepository;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileResource
implements Resource {
    private File _file;
    private FileRepository _repository;

    public FileResource(FileRepository repository, File f) {
        this._repository = repository;
        this._file = f;
    }

    public String getName() {
        return this._file.getPath();
    }

    public Resource clone(String cloneName) {
        return new FileResource(this._repository, new File(cloneName));
    }

    public long getLastModified() {
        return this._file.lastModified();
    }

    public long getContentLength() {
        return this._file.length();
    }

    public boolean exists() {
        return this._file.exists();
    }

    public String toString() {
        return this.getName();
    }

    public File getFile() {
        return this._file;
    }

    public FileRepository getRepository() {
        return this._repository;
    }

    public boolean isLocal() {
        return this._repository.isLocal();
    }

    public InputStream openStream() throws IOException {
        return new FileInputStream(this._file);
    }
}

