/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.ant;

import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.ModuleId;
import fr.jayasoft.ivy.ant.IvyResolve;
import fr.jayasoft.ivy.ant.IvyTask;
import fr.jayasoft.ivy.filter.Filter;
import fr.jayasoft.ivy.filter.FilterHelper;
import fr.jayasoft.ivy.report.ResolveReport;
import fr.jayasoft.ivy.util.Message;
import fr.jayasoft.ivy.util.StringUtils;
import java.io.File;
import org.apache.tools.ant.BuildException;

public abstract class IvyPostResolveTask
extends IvyTask {
    private String _conf;
    private boolean _haltOnFailure = true;
    private boolean _transitive = true;
    private boolean _inline = false;
    private File _cache;
    private String _organisation;
    private String _module;
    private String _revision = "latest.integration";
    private String _type;
    private Filter _artifactFilter = null;
    private boolean useOrigin = false;

    public boolean isUseOrigin() {
        return this.useOrigin;
    }

    public void setUseOrigin(boolean useOrigin) {
        this.useOrigin = useOrigin;
    }

    protected void prepareAndCheck() {
        Ivy ivy = this.getIvyInstance();
        this._organisation = this.getProperty(this._organisation, ivy, "ivy.organisation");
        this._module = this.getProperty(this._module, ivy, "ivy.module");
        if (this.isInline()) {
            String string = this._conf = this._conf == null ? "*" : this._conf;
            if (this._organisation == null) {
                throw new BuildException("no organisation provided for ivy cache task in inline mode: It can either be set explicitely via the attribute 'organisation' or via 'ivy.organisation' property");
            }
            if (this._module == null) {
                throw new BuildException("no module name provided for ivy cache task in inline mode: It can either be set explicitely via the attribute 'module' or via 'ivy.module' property");
            }
            Object[] toResolve = this.getConfsToResolve(this.getOrganisation(), this.getModule() + "-caller", this._conf, true);
            if (toResolve.length > 0) {
                Message.verbose("using inline mode to resolve " + this.getOrganisation() + " " + this.getModule() + " " + this.getRevision() + " (" + StringUtils.join(toResolve, ", ") + ")");
                IvyResolve resolve = this.createResolve(this.isHaltonfailure(), this.isUseOrigin());
                resolve.setOrganisation(this.getOrganisation());
                resolve.setModule(this.getModule());
                resolve.setRevision(this.getRevision());
                resolve.setInline(true);
                resolve.setConf(this._conf);
                resolve.execute();
            } else {
                Message.verbose("inline resolve already done for " + this.getOrganisation() + " " + this.getModule() + " " + this.getRevision() + " (" + this._conf + ")");
            }
            if ("*".equals(this._conf)) {
                this._conf = StringUtils.join(this.getResolvedConfigurations(this.getOrganisation(), this.getModule() + "-caller", true), ", ");
            }
        } else {
            Message.debug("using standard ensure resolved");
            this.ensureResolved(this.isHaltonfailure(), this.isUseOrigin(), this.isTransitive(), this.getOrganisation(), this.getModule(), this.getProperty(this._conf, ivy, "ivy.resolved.configurations"));
            this._conf = this.getProperty(this._conf, ivy, "ivy.resolved.configurations");
            if ("*".equals(this._conf)) {
                this._conf = this.getProperty(ivy, "ivy.resolved.configurations");
                if (this._conf == null) {
                    throw new BuildException("bad conf provided for ivy cache task: * can only be used with a prior call to <resolve/>");
                }
            }
        }
        this._organisation = this.getProperty(this._organisation, ivy, "ivy.organisation");
        this._module = this.getProperty(this._module, ivy, "ivy.module");
        if (this._organisation == null) {
            throw new BuildException("no organisation provided for ivy cache task: It can either be set explicitely via the attribute 'organisation' or via 'ivy.organisation' property or a prior call to <resolve/>");
        }
        if (this._module == null) {
            throw new BuildException("no module name provided for ivy cache task: It can either be set explicitely via the attribute 'module' or via 'ivy.module' property or a prior call to <resolve/>");
        }
        if (this._conf == null) {
            throw new BuildException("no conf provided for ivy cache task: It can either be set explicitely via the attribute 'conf' or via 'ivy.resolved.configurations' property or a prior call to <resolve/>");
        }
        if (this._cache == null) {
            this._cache = ivy.getDefaultCache();
        }
        this._artifactFilter = FilterHelper.getArtifactTypeFilter(this._type);
    }

    protected ModuleId getResolvedModuleId() {
        return this.isInline() ? new ModuleId(this.getOrganisation(), this.getModule() + "-caller") : new ModuleId(this.getOrganisation(), this.getModule());
    }

    protected ResolveReport getResolvedReport() {
        return this.getResolvedReport(this.getOrganisation(), this.isInline() ? this.getModule() + "-caller" : this.getModule());
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
    }

    public String getConf() {
        return this._conf;
    }

    public void setConf(String conf) {
        this._conf = conf;
    }

    public String getModule() {
        return this._module;
    }

    public void setModule(String module) {
        this._module = module;
    }

    public String getOrganisation() {
        return this._organisation;
    }

    public void setOrganisation(String organisation) {
        this._organisation = organisation;
    }

    public boolean isHaltonfailure() {
        return this._haltOnFailure;
    }

    public void setHaltonfailure(boolean haltOnFailure) {
        this._haltOnFailure = haltOnFailure;
    }

    public File getCache() {
        return this._cache;
    }

    public void setCache(File cache) {
        this._cache = cache;
    }

    public String getRevision() {
        return this._revision;
    }

    public void setRevision(String rev) {
        this._revision = rev;
    }

    public Filter getArtifactFilter() {
        return this._artifactFilter;
    }

    public boolean isTransitive() {
        return this._transitive;
    }

    public void setTransitive(boolean transitive) {
        this._transitive = transitive;
    }

    public boolean isInline() {
        return this._inline;
    }

    public void setInline(boolean inline) {
        this._inline = inline;
    }
}

