/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.methods;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpState;
import org.apache.webdav.lib.methods.XMLResponseMethodBase;
import org.apache.webdav.lib.util.XMLPrinter;

public class PropPatchMethod
extends XMLResponseMethodBase {
    protected Hashtable toSet = new Hashtable();
    protected Hashtable toRemove = new Hashtable();

    public PropPatchMethod() {
    }

    public PropPatchMethod(String path) {
        super(path);
    }

    public void addPropertyToSet(String name, String value) {
        this.checkNotUsed();
        Property propertyToSet = new Property();
        if (name != null) {
            propertyToSet.name = name;
            propertyToSet.value = value != null ? value : "";
            this.toSet.put(name, propertyToSet);
        }
    }

    public void addPropertyToSet(String name, String value, String namespace, String namespaceInfo) {
        this.checkNotUsed();
        Property propertyToSet = new Property();
        if (name != null) {
            propertyToSet.name = name;
            propertyToSet.value = value != null ? value : "";
            propertyToSet.namespace = namespace;
            propertyToSet.namespaceInfo = namespaceInfo;
            this.toSet.put(namespaceInfo + name, propertyToSet);
        }
    }

    public void addPropertyToRemove(String name) {
        this.checkNotUsed();
        Property propertyToRemove = new Property();
        if (name != null) {
            propertyToRemove.name = name;
            this.toRemove.put(name, propertyToRemove);
        }
    }

    public void addPropertyToRemove(String name, String namespace, String namespaceInfo) {
        this.checkNotUsed();
        Property propertyToRemove = new Property();
        if (name != null) {
            propertyToRemove.name = name;
            propertyToRemove.namespace = namespace;
            propertyToRemove.namespaceInfo = namespaceInfo;
            this.toRemove.put(namespaceInfo + name, propertyToRemove);
        }
    }

    public String getName() {
        return "PROPPATCH";
    }

    public void addRequestHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        if (this.getRequestHeader("Content-Type") == null) {
            super.setRequestHeader("Content-Type", "text/xml; charset=utf-8");
        }
        super.addRequestHeaders(state, conn);
    }

    protected String generateRequestBody() {
        Property current;
        XMLPrinter printer = new XMLPrinter();
        printer.writeXMLHeader();
        printer.writeElement("D", "DAV:", "propertyupdate", 0);
        if (this.toSet.size() > 0) {
            printer.writeElement("D", null, "set", 0);
            Enumeration toSetList = this.toSet.elements();
            printer.writeElement("D", null, "prop", 0);
            while (toSetList.hasMoreElements()) {
                current = (Property)toSetList.nextElement();
                if ("DAV:".equals(current.namespaceInfo)) {
                    printer.writeProperty("D", null, current.name, current.value);
                    continue;
                }
                printer.writeProperty(current.namespace, current.namespaceInfo, current.name, current.value);
            }
            printer.writeElement("D", null, "prop", 1);
            printer.writeElement("D", null, "set", 1);
        }
        if (this.toRemove.size() > 0) {
            printer.writeElement("D", null, "remove", 0);
            Enumeration toRemoveList = this.toRemove.elements();
            printer.writeElement("D", null, "prop", 0);
            while (toRemoveList.hasMoreElements()) {
                current = (Property)toRemoveList.nextElement();
                printer.writeElement(current.namespace, current.namespaceInfo, current.name, 2);
            }
            printer.writeElement("D", null, "prop", 1);
            printer.writeElement("D", null, "remove", 1);
        }
        printer.writeElement("D", "propertyupdate", 1);
        return printer.toString();
    }

    public void parseResponse(InputStream input, HttpState state, HttpConnection conn) throws IOException, HttpException {
        try {
            int code = this.getStatusLine().getStatusCode();
            if (code == 409 || code == 207 || code == 403) {
                this.parseXMLResponse(input);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private class Property {
        public String name = "";
        public String namespace;
        public String namespaceInfo;
        public String value;

        private Property() {
        }
    }
}

