/*
  "ish.c"            Version 1.11

  ish file converter for Human68K

	   (C) Pekin
      Public Domain Software

  1987.11.11      ken Miyazaki(ken)
  1987.11.28        O Imaizumi(Gigo)
  1987.12.05 Bug Fix
  1987.12.06 OS9Ext support.
  1988.01.31 V.1.11
  1988.02.06 for Human68K(Gigo)
  1988.05.10 for UNIX (kondo)
  1990.07.12 non-kana (keizo)

  special thanks for M.ishizuka(ish)
*/

#include <errno.h>
#include <fcntl.h>
#include <ctype.h>
#define MAIN
#include "ish.h"

#ifdef SysV
#define	rindex	strrchr
#endif

#ifdef __TURBOC__
#define	rindex	strrchr
#endif

extern int errno;
extern char *rindex();

void help(), puttitle();

enum EncDecMode edmode = JIS7;
short int jis = JIS7_L,  esc = OFF, title = 50, mode = RESNEW;
#ifdef __TURBOC__
short int os = MS_DOS;
#else
short int os = UNIX;
#endif
int  path = 0, size;
long lsize;
char *filename = "file.ish";

FILE *opath = stdout;
FILE *ipath;
char name[NAMLEN];

unsigned char buff[LBUFLEN];
unsigned char obuf[LBUFLEN];
unsigned char tatesum[LBUFLEN];
unsigned char yokosum[LBUFLEN];
unsigned char atrb;

static int ishargc=0;
static char *ishargv[32];

void main(argc, argv)
int argc;
char **argv;
{
    int i, oflg = 0, n = 0, fc = 0;
    char *p;
    FILE *fopen();

    if (argc < 2)
	help();
    while(--argc > 0) {
	if (**++argv == '-') {
	    switch(isalpha(argv[0][1])?toupper(argv[0][1]):argv[0][1]) {
	    case 'S' :
		switch(isalpha(argv[0][2])?toupper(argv[0][2]):argv[0][2]) {
		case '\0':
		case '8':
		    jis = JIS8_L;
		    edmode = JIS8;
		    break;
		case '7':
		    jis = JIS7_L;
		    edmode = JIS7;
		    break;
		case 'S':
		    jis = SJIS_L;
		    edmode = SJIS;
		    break;
		case 'N':
		    jis = NJIS_L;
		    edmode = NJIS;
		    break;
		default:
		    help();
		}
		mode = CREISH;
		break;
	    case 'O':
		jis = OJIS;
		printf("\nSorry, -o not supported.\n\n");
		exit(225); /* bad para err */
	    case 'M':
		os = MS_DOS;
		break;
	    case 'C':
		os = CP_M;
		break;
	    case '9':
		os = OS_9;
		break;
	    case 'K':
		os = OS_9EXT;
		break;
	    case 'U':
		os = UNIX;
		break;
	    case '?':
		os = OTHER;
		break;
	    case '*':
		os = ALL_OS;
		break;
	    case 'N':
		esc = OFF;
		break;
	    case 'E':
		esc = ON;
		break;
	    case 'T':
		title = atoi(&argv[0][2]);
		break;
	    case 'R':
		mode = RESNEW;
		break;
	    case 'A':
		mode = RESALL;
		break;
	    case 'Q':
		mode = RESASK;
		break;
	    case 'F':
		if (argv[0][2] == '=') {
		    oflg = -1;
		    strcpy(name, &argv[0][3]);
		}
		else
		    oflg = 1;
		break;
	    default:
		help();
	    }
	}
	else
	    ishargv[ishargc++] = filename = argv[0];
    }
    if (p = rindex(filename, '.'))
	if (tolower(*++p) == 'i' && tolower(*++p) == 's' 
	    && tolower(*++p) == 'h' && *++p == '\0' && mode == CREISH)
	    mode = RESNEW;
    if (mode == CREISH) {
	puttitle();
	n = 0;
	if (oflg != 1) {
	    if (ishargc) {
		if (oflg != -1)
		    strcat(name, ishargv[0]);
		if ((p = rindex(name, '.')) != 0 
		    && tolower(*++p) == 'i' 
		    && tolower(*++p) == 's'
		    && tolower(*++p) == 'h'
		    && *++p == '\0' ) {
		    if (oflg != -1)
			n++;
		}
		else {
		    if(p = rindex(name, '.'))
			strcpy(p, ".ish");
		    else
			strcat(name, ".ish");
		}
		if ((filename = rindex(name, '/')) == 0)
		    filename = name;
		else
		    filename++;
		if ((opath=fopen(filename, "w")) == NULL)
		    exit(errno);
		fprintf(stderr, "< Create to %s >\n", filename);
	    }
	}
	clearerr(opath);
	for (; ishargc > 0; --ishargc, ++n) {
#ifdef __TURBOC__
	    if ((path = open(ishargv[n], O_RDONLY | O_BINARY)) == ERR)
#else
	    if ((path = open(ishargv[n], O_RDONLY)) == ERR)
#endif
		if (n)
		    exit(errno);
		else
		    continue;
	    if ((filename = rindex(ishargv[n],'/')) == 0)
		filename = ishargv[n];
	    else
		filename++;
	    if(encode() == ERR)
		exit(errno);
	    close(path);
	    fc++;
	}
	if (fc == 0)
	    fprintf(stderr, "\nNone of terget file(s)\n\n");
    }
    else {            /* Restore */
	if ((ipath = fopen(filename, "r")) == NULL) {
	    strcpy(name, filename);
	    strcat(name, ".ish");
	    if ((ipath = fopen(name, "r")) == NULL) {
#ifdef __TURBOC__
		fprintf(stderr, "%s not found.\n", filename);
#endif
		exit(errno);
	    }
	}
	puttitle();
	fprintf(stderr, "< Restore from %s >\n", filename);
	if (decode() == 0)
	    fprintf(stderr, "ish: can't find ish header.\n");
    }
}

void help()
{
    printf("\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n\n",
    "Restore : ish <path> [-{r|a|q}] [-{m|c|9|k|u|?|*}]",
    "Store   : ish <path> {-s[8|s|n|7]} [-{m|c|9|k|u|?|*}] [-{n|e}] [-tn]\n",
    "-r : restore new file(s)                -a : restore all file(s)",
    "-q : restore with question",
    "-s : store a JIS8 format ish file       -s8: same as -s",
    "-ss: store a shift JIS format ish file  -s7: store a JIS7 format ish file",
	"-sn: store a shift JIS non-kana format ish file",
    "-m : MS-DOS & Human68K                  -? : other OS(s)",
    "-c : CP/M and/or MSX-DOS                -9 : OS-9",
    "-k : OS-9/68000 and/or OS-9Ext          -u : UNIX,",
    "-* : all OS(s)",
    "-n : no ESC sequence in TITLE line      -e : ESC sequence in TITLE line",
    "-tn: title in n line(default 50 line)   -f=<path> : Output to <path>"
	);
    exit(0);
}

void puttitle()
{
    fprintf(stderr, "ish file converter for UNIX Ver2.01\n");
    fprintf(stderr, "original sources are Human68K Ver1.11\n");
    fprintf(stderr, "original idea By M.ishizuka(for MS-DOS)\n");
    fprintf(stderr, "copyright 1988 - Pekin - (by Ken+Gigo)\n");
	fprintf(stderr, "     non-kana by keizo   July 12, 1990\n\n");
}
