/*
  utils.c - Some useful things
  
  (c) 1999 Robert Cheramy <tibob@via.ecp.fr>
  (c) 2000 Samuel Hocevar <sam@via.ecp.fr>

  200010xx : sam : makedirname & pid file handling
 */

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <string.h>
#include <stdio.h>
#include <time.h>
/* #include <db.h> */
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <fcntl.h>
#include <unistd.h>
#include <signal.h>
#include <errno.h>

#include "utils.h"


char *timefile(char *filemask, time_t when) {
  char s_temp[FILENAME_MAX];
  char *s_cpy;
  struct tm *p_time;
  
  p_time = localtime(&when);
  strftime(s_temp, FILENAME_MAX, filemask, p_time);

  s_cpy = strdup(s_temp);
  return (s_cpy);
}

int makedirname(char *filename) {
  static struct stat statbuf;
  char *s_temp = filename;
  char *s_slash = NULL;

  /* check in which directory `filename' is going to be,
   * so that we can get /foo/bar from /foo/bar/baz */
  while (*s_temp) {
    if('/' == *s_temp) {
      s_slash = s_temp;
    }
    s_temp++;
  }

  if (NULL == s_slash || s_slash == filename) {
    /* either `filename' is a relative path (pwd is a dir), or
     * `filename' is directly in /, which is a directory as well.
     * In both cases, return OK */
    return(0);
  }
  /* /foo/bar/baz becomes /foo/bar and we check if /foo/bar is a
   * directory, which is required to create baz afterwards */
  *s_slash = '\0';
  /* Check if /foo/bar is already a directory */
  if (-1 != stat(filename, &statbuf)) {
    if (S_ISDIR(statbuf.st_mode)) {
      *s_slash = '/';
      return(0);
    }
  }
  /* Check if we can create /foo/bar (recursive call to check /foo) */
  if (-1 != makedirname (filename)) {
    if (-1 != mkdir(filename, DEFAULT_DIR_MODE)) {
      *s_slash = '/';
      return(0);
    }
  }
  /* Everything failed, we give up */
  *s_slash = '/';
  return(-1);
}

/*
  Borrowed from IPPL by Hugo Haas and Etienne Bernard
  http://pltplp.net/ippl/
*/
int check_pid (char *pidfile)
{
  int pid = read_pid(pidfile);

  if ((!pid) || (pid == getpid ()))
    return 0;

  if (kill(pid, 0) && (ESRCH == errno)) {
    return 0;
  }

  return pid;
}

int read_pid (char *pidfile)
{
  FILE *f;
  int pid;

  if (!(f = fopen(pidfile,"r"))) {
    return 0;
  }
  fscanf (f, "%d", &pid);
  fclose (f);

  return pid;
}

int write_pid (char *pidfile)
{
  FILE *f;
  int fd;
  int pid;

  if (-1 == ((fd = open(pidfile, O_RDWR | O_CREAT, 0644)))
       || (NULL == (f = fdopen(fd, "r+"))) ) {
    fprintf (stderr, "Can't open or create %s.\n", pidfile);
    return 0;
  }

  if (-1 == flock(fd, LOCK_EX|LOCK_NB)) {
    fscanf (f, "%d", &pid);
    fclose (f);
    printf ("Can't lock, lock is held by pid %d.\n", pid);
    return 0;
  }

  pid = getpid();
  if (!fprintf(f, "%d\n", pid)) {
    printf ("Can't write pid , %s.\n", strerror(errno));
    close (fd);
    return 0;
  }
  fflush(f);

  if (-1 == flock(fd, LOCK_UN)) {
    printf ("Can't unlock pidfile %s, %s.\n", pidfile, strerror(errno));
    close (fd);
    return 0;
  }
  close (fd);

  return pid;
}

int remove_pid (char *pidfile)
{
  return unlink (pidfile);
}

