.\" -*-nroff-*-
.\"
.\"     Copyright (C) 1999 Robert CHERAMY <tibob@via.ecp.fr>
.\"
.\"     This program is free software; you can redistribute it and/or modify
.\"     it under the terms of the GNU General Public License as published by
.\"     the Free Software Foundation; either version 2 of the License, or
.\"     (at your option) any later version.
.\"
.\"     This program is distributed in the hope that it will be useful,
.\"     but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"     GNU General Public License for more details.
.\"
.\"     You should have received a copy of the GNU General Public License
.\"     along with this program; if not, write to the Free Software
.\"     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.\"
.TH IPFM.CONF 5 "Last change: 12 July 1999"

.SH NAME
ipfm.conf \- IP Flow Meter configuration file

.SH DESCRIPTION
.B ipfm.conf
is
.BR ipfm (8)
configuration file.

A hash mark (``#'') indicates that the end of the line is a comment
and it will be ignored.

The configuration rules will be interpreted from the end, and the first
matching rule will be used, unless specified here.

.BR IPFM
uses local and global variables, so it can manage muliple logs (different time delay, different hosts, different log filemane ...) in the same time.

.SH GLOBLAL VARIABLES
.SS
.I NETWORK DEVICE
.B Syntax :
DEVICE <device-name>
.TP
<device-name>
is the device on witch ipfm will log packets.

.SS
.I NEW LOG
.B Syntax :
NEWLOG

This creates a new log entry, where you can define new local variables.

.SH LOCAL VARIABLES
.SS
.I HOSTS TO LOG
.BR ipfm
logs only specified hosts.

.B Syntax:
LOG [[NONE|FROM|TO|BOTH] <host>] [[NOT] WITH <host>]
.TP
NONE
do not log anything from or to this <host>
.TP
FROM
do log packets from this <host>
.TP
TO
do log packets to this <host>
.TP
BOTH
(default) do log packets from and to this <host>
.TP
<host> can be :
x.x.x.x           : an IP.
x.x.x.x/x.x.x.x : an IP followed by a subnet mask.
.TP
WITH
specifies if the packet is ignored (NOT WITH) or logged (WITH), in function of the second IP present in the packet.
.TP
.B Examples :
LOG 10.10.10.0/255.255.255.0 NOT WITH 10.10.10.1
 will log any packets from or to hosts in subnet 10.10.10.0/255.255.255.0, except packets involving host 10.10.10.1 .

LOG WITH 10.10.10.23
 will log any packets in relation with host 10.10.10.23

LOG
 will log everything.

.SS
.I OUTPUT TIME DELAY
.B ipfm
outputs its statistics every fixed period.

.B Syntax:
TIME <time>
.TP
<time> is composed of :
 <number> second
 <number> minute
 <number> hour
 <number> day
.TP
.B Example:
TIME 1 hour 30 minute 12 second

.SS
.I LOG FILENAME
Every delay,
.B ipfm
writes its output into a file, which name is specified by the rule
.I FILEMANE

.B Syntax:
FILENAME <filemask>
.TP
<filemask>
is a string that is parsed using
.BR strftime(3)
syntax.
.TP
Default FILENAME is __LOGFILE
NOTE : The file will be overwritten without any check.

.SS
.I REVERSE DNS
You can use or desactivate reverse DNS in the output file.

.B Syntax :
[RESOLVE|NORESOLVE]
.TP
Default is RESOLVE

.SS
.I SORT OUTPUT FILE
.B ipfm
can sort output file depending on IN, OUT or TOTAL.

.B Syntax :
SORT IN|OUT|TOTAL
.TP
Default is to sort nothing.

.SH SEE ALSO
.BR strftime(3),
.BR ipfm(8)

.SH AUTHORS
 Robert CHERAMY <tibob@via.ecp.fr>
 Andres KRAPF   <dae@via.ecp.fr>
