/*-
 * Copyright (c) 2001, 2003 Lev Walkin <vlm@lionet.info>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: init-psrc.c,v 1.7 2004/03/19 08:12:31 vlm Exp $
 */

#include "ipcad.h"
#include "opt.h"
#include "sf_lite.h"

static unsigned ifIndexes;
static slist *ifIndex2Name;

packet_source_t *
create_packet_source(char *ifname, int iflags, char *filter) {
	packet_source_t *ps;

	ps = calloc(1, sizeof *ps);
	if(ps == NULL) return NULL;
	if(ifIndex2Name == NULL) {
		ifIndex2Name = sinit();
		if(ifIndex2Name == NULL) { free(ps); return NULL; }
	}

	/*
	 * Initialize packet source descriptors.
	 */
        if(strncasecmp(ifname, "ulog", 5) == 0) {
#ifndef	NETLINK_NFLOG
		fprintf(stderr, "Linux ULOG is not supported\n");
		free(ps);
		errno = EINVAL;
		return NULL;
#else
		extern void *loop_ulog(void *);
		ps->loop_ptr = loop_ulog;
		ps->print_stats = print_stats_ulog;

		ps->iface_type = IFACE_ULOG;
		ps->iface.ulog.fd = -1; /* Linux iptables ULOG */
		ps->iface.ulog.groupmask = 0;
		ps->iface.ulog.buf = NULL;
		ps->iface.ulog.bufsize = 0;
#endif
        } else {

#ifdef	PSRC_bpf
		extern void *loop_bpf(void *);
		ps->loop_ptr = loop_bpf;
		ps->print_stats = print_stats_bpf;

		ps->iface_type = IFACE_BPF;
		ps->iface.bpf.fd = -1;
		ps->iface.bpf.buf = NULL;
		ps->iface.bpf.bufsize = 0;
#endif	/* PSRC_bpf */
#ifdef	PSRC_pcap
		extern void *loop_pcap(void *);
		ps->loop_ptr = loop_pcap;
		ps->print_stats = print_stats_pcap;
		
    		ps->iface_type = IFACE_PCAP;
		ps->iface.pcap.dev = NULL;
		if(pthread_mutex_init(&ps->iface.pcap.dev_mutex, NULL) == -1) {
			free(ps);
			return NULL;
		}
#endif	/* PSRC_pcap */
	}

	strncpy( ps->ifName, ifname, sizeof(ps->ifName) );
	ps->ifName[sizeof(ps->ifName) - 1] = 0;
	ps->iflags = iflags;
	ps->custom_filter = filter;
	ps->ifIndex = ++ifIndexes;

	ps->avg_period = 300;   /* 5 minutes */
	ps->bytes_lp = -1;	/* Initial value */
	ps->packets_lp = -1;	/* Initial value */

	ps->state = PST_EMBRYONIC;

	(void)sadd(ifIndex2Name, ps->ifName);
	assert(ifIndex2Name->count == ifIndexes);

	return ps;
}


char *
IFNameByIndex(int ifIndex) {
	if(ifIndex > 0 && (unsigned)ifIndex <= ifIndex2Name->count) {
		return ifIndex2Name->list[ifIndex - 1];
	}
	return "<?>";
}
