/* A Bison parser, made from cfg.y, by GNU bison 1.75.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON	1

/* Pure parsers.  */
#define YYPURE	0

/* Using locations.  */
#define YYLSP_NEEDED 0

/* If NAME_PREFIX is specified substitute the variables and functions
   names.  */
#define yyparse ipcacfgparse
#define yylex   ipcacfglex
#define yyerror ipcacfgerror
#define yylval  ipcacfglval
#define yychar  ipcacfgchar
#define yydebug ipcacfgdebug
#define yynerrs ipcacfgnerrs


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     TOK_STRING = 258,
     TOK_INTEGER = 259,
     ERROR = 260,
     EQ = 261,
     AT = 262,
     SEMICOLON = 263,
     SLASH = 264,
     IFACE = 265,
     ULOG = 266,
     GROUP = 267,
     INONLY = 268,
     PROMISC = 269,
     NETFLOW_SAMPLED = 270,
     NETFLOW_DISABLE = 271,
     FILTER = 272,
     CAPTURE_PORTS = 273,
     MEMSIZE = 274,
     BUFFERS = 275,
     RSH = 276,
     DUMP = 277,
     CHROOT = 278,
     UID = 279,
     GID = 280,
     AGGR = 281,
     STRIP = 282,
     INTO = 283,
     DENY = 284,
     ALLOW = 285,
     TIMEOUT = 286,
     TTL = 287,
     PIDFILE = 288,
     ADMIN = 289,
     BACKUP = 290,
     DEFAULT = 291,
     VIEW_ONLY = 292,
     NETFLOW = 293,
     EXPORT = 294,
     DESTINATION = 295,
     VERSION = 296,
     ACTIVE = 297,
     INACTIVE = 298,
     SAMPLING_MODE = 299,
     PACKET_INTERVAL = 300
   };
#endif
#define TOK_STRING 258
#define TOK_INTEGER 259
#define ERROR 260
#define EQ 261
#define AT 262
#define SEMICOLON 263
#define SLASH 264
#define IFACE 265
#define ULOG 266
#define GROUP 267
#define INONLY 268
#define PROMISC 269
#define NETFLOW_SAMPLED 270
#define NETFLOW_DISABLE 271
#define FILTER 272
#define CAPTURE_PORTS 273
#define MEMSIZE 274
#define BUFFERS 275
#define RSH 276
#define DUMP 277
#define CHROOT 278
#define UID 279
#define GID 280
#define AGGR 281
#define STRIP 282
#define INTO 283
#define DENY 284
#define ALLOW 285
#define TIMEOUT 286
#define TTL 287
#define PIDFILE 288
#define ADMIN 289
#define BACKUP 290
#define DEFAULT 291
#define VIEW_ONLY 292
#define NETFLOW 293
#define EXPORT 294
#define DESTINATION 295
#define VERSION 296
#define ACTIVE 297
#define INACTIVE 298
#define SAMPLING_MODE 299
#define PACKET_INTERVAL 300




/* Copy the first part of user declarations.  */
#line 1 "cfg.y"


#include "headers.h"
#include "cfgvar.h"
#include "servers.h"
#include "rsh.h"
#include "opt.h"
#include "storage.h"

int yylex();
int yyerror();

extern int ipcacfglineno;



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#ifndef YYSTYPE
#line 20 "cfg.y"
typedef union {
	int tv_int;
	char *tv_char;
	struct in_addr tv_ip;
	struct { 
		int is_ip_aggr;
		char *s1;
		char *s2;
		char *s3;
	} tv_aggr;
} yystype;
/* Line 193 of /usr/local/share/bison/yacc.c.  */
#line 200 "y.tab.c"
# define YYSTYPE yystype
# define YYSTYPE_IS_TRIVIAL 1
#endif

#ifndef YYLTYPE
typedef struct yyltype
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
} yyltype;
# define YYLTYPE yyltype
# define YYLTYPE_IS_TRIVIAL 1
#endif

/* Copy the second part of user declarations.  */


/* Line 213 of /usr/local/share/bison/yacc.c.  */
#line 221 "y.tab.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYLTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAX (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAX)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];	\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAX;	\
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  40
#define YYLAST   110

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  48
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  15
/* YYNRULES -- Number of rules. */
#define YYNRULES  56
/* YYNRULES -- Number of states. */
#define YYNSTATES  113

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   300

#define YYTRANSLATE(X) \
  ((unsigned)(X) <= YYMAXUTOK ? yytranslate[X] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,    46,    47,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned char yyprhs[] =
{
       0,     0,     3,     5,     8,    12,    13,    15,    16,    18,
      20,    22,    24,    26,    28,    30,    32,    34,    36,    39,
      40,    42,    45,    48,    53,    57,    61,    66,    71,    75,
      78,    81,    85,    89,    94,    98,   103,   109,   114,   118,
     120,   124,   128,   132,   136,   140,   144,   149,   154,   157,
     158,   161,   163,   169,   174,   179,   184
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const yysigned_char yyrhs[] =
{
      49,     0,    -1,    50,    -1,    58,    51,    -1,    50,    58,
      51,    -1,    -1,     8,    -1,    -1,    34,    -1,    35,    -1,
      36,    -1,    37,    -1,    29,    -1,    13,    -1,    14,    -1,
      15,    -1,    16,    -1,    53,    -1,    54,    53,    -1,    -1,
      54,    -1,    17,     3,    -1,    12,     4,    -1,    57,    46,
      12,     4,    -1,    33,     6,     3,    -1,    10,     3,    55,
      -1,    10,     3,    55,    56,    -1,    10,    11,    57,    55,
      -1,    22,     6,     3,    -1,    18,    30,    -1,    18,    29,
      -1,    21,    30,    60,    -1,    21,    29,    60,    -1,    21,
      31,     6,     3,    -1,    21,     3,    52,    -1,    21,     7,
       3,    52,    -1,    21,     3,     7,     3,    52,    -1,    21,
      32,     6,     3,    -1,    32,     6,     3,    -1,    62,    -1,
      23,     6,     3,    -1,    24,     6,     3,    -1,    25,     6,
       3,    -1,    19,     6,     3,    -1,    20,     6,     3,    -1,
      26,     3,    59,    -1,     9,     3,    27,     3,    -1,    47,
       3,    28,     3,    -1,    28,     3,    -1,    -1,     7,     3,
      -1,     3,    -1,    38,    39,    40,    61,     4,    -1,    38,
      39,    41,     4,    -1,    38,    31,    42,     4,    -1,    38,
      31,    43,     4,    -1,    38,    44,    45,     4,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,    95,    95,    98,    99,   102,   103,   105,   107,   108,
     109,   110,   111,   114,   116,   117,   118,   121,   123,   126,
     128,   131,   135,   139,   144,   150,   154,   158,   165,   170,
     173,   176,   182,   186,   196,   200,   204,   208,   212,   219,
     220,   225,   232,   240,   278,   313,   333,   339,   344,   351,
     353,   360,   368,   377,   383,   389,   395
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "TOK_STRING", "TOK_INTEGER", "ERROR", "EQ", 
  "AT", "SEMICOLON", "SLASH", "IFACE", "ULOG", "GROUP", "INONLY", 
  "PROMISC", "NETFLOW_SAMPLED", "NETFLOW_DISABLE", "FILTER", 
  "CAPTURE_PORTS", "MEMSIZE", "BUFFERS", "RSH", "DUMP", "CHROOT", "UID", 
  "GID", "AGGR", "STRIP", "INTO", "DENY", "ALLOW", "TIMEOUT", "TTL", 
  "PIDFILE", "ADMIN", "BACKUP", "DEFAULT", "VIEW_ONLY", "NETFLOW", 
  "EXPORT", "DESTINATION", "VERSION", "ACTIVE", "INACTIVE", 
  "SAMPLING_MODE", "PACKET_INTERVAL", "','", "'-'", "$accept", "cfg_file", 
  "sequence", "ps", "privlevel", "IFlag", "IFlags", "optIFlags", 
  "IFilter", "ulog_gmask", "block", "aggr_values", "at_ip", "ip_addr", 
  "NetFlow", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,    44,    45
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,    48,    49,    50,    50,    51,    51,    52,    52,    52,
      52,    52,    52,    53,    53,    53,    53,    54,    54,    55,
      55,    56,    57,    57,    58,    58,    58,    58,    58,    58,
      58,    58,    58,    58,    58,    58,    58,    58,    58,    58,
      58,    58,    58,    58,    58,    58,    59,    59,    59,    60,
      60,    61,    62,    62,    62,    62,    62
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     2,     3,     0,     1,     0,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     0,
       1,     2,     2,     4,     3,     3,     4,     4,     3,     2,
       2,     3,     3,     4,     3,     4,     5,     4,     3,     1,
       3,     3,     3,     3,     3,     3,     4,     4,     2,     0,
       2,     1,     5,     4,     4,     4,     4
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char yydefact[] =
{
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     2,     5,    39,    19,     0,
      30,    29,     0,     0,     7,     0,    49,    49,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       1,     5,     6,     3,    13,    14,    15,    16,    17,    20,
      25,     0,    19,    43,    44,     0,    12,     8,     9,    10,
      11,    34,     7,     0,    32,    31,     0,     0,    28,    40,
      41,    42,     0,     0,     0,    45,    38,    24,     0,     0,
       0,     0,     0,     4,    18,     0,    26,    22,     0,    27,
       7,    35,    50,    33,    37,     0,    48,     0,    54,    55,
      51,     0,    53,    56,    21,     0,    36,     0,     0,    52,
      23,    46,    47
};

/* YYDEFGOTO[NTERM-NUM]. */
static const yysigned_char yydefgoto[] =
{
      -1,    14,    15,    43,    61,    48,    49,    50,    86,    52,
      16,    75,    64,   101,    17
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -58
static const yysigned_char yypact[] =
{
      38,     3,   -13,    19,    26,    15,    30,    31,    33,    43,
       9,    44,    45,   -24,    52,    38,    46,   -58,    -5,    41,
     -58,   -58,    62,    63,     6,    64,    48,    48,    66,    67,
      65,    71,    72,    74,    -9,    75,    76,   -19,   -10,    24,
     -58,    46,   -58,   -58,   -58,   -58,   -58,   -58,   -58,    -5,
      68,    77,   -12,   -58,   -58,    79,   -58,   -58,   -58,   -58,
     -58,   -58,    -8,    80,   -58,   -58,    81,    83,   -58,   -58,
     -58,   -58,    84,    85,    86,   -58,   -58,   -58,    87,    88,
      90,    91,    92,   -58,   -58,    94,   -58,   -58,    78,   -58,
      -8,   -58,   -58,   -58,   -58,    53,   -58,    70,   -58,   -58,
     -58,    95,   -58,   -58,   -58,    96,   -58,    98,    99,   -58,
     -58,   -58,   -58
};

/* YYPGOTO[NTERM-NUM].  */
static const yysigned_char yypgoto[] =
{
     -58,   -58,   -58,    69,   -57,    54,   -58,    42,   -58,   -58,
      89,   -58,    82,   -58,   -58
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, parse error.  */
#define YYTABLE_NINF -1
static const unsigned char yytable[] =
{
      72,    44,    45,    46,    47,    91,    18,    37,    44,    45,
      46,    47,    34,    55,    19,    38,    20,    21,    24,    73,
      39,    56,    25,    78,    79,    22,    57,    58,    59,    60,
      80,    81,    23,   106,    88,    56,    30,    31,    74,    32,
      57,    58,    59,    60,    26,    27,    28,    29,     1,    33,
      35,    36,    40,    51,    42,    63,     2,     3,     4,     5,
       6,     7,     8,     9,    10,    53,    54,    62,    68,    82,
      11,    12,    66,    67,    69,    70,    13,    71,    76,    77,
     107,    87,    90,    92,    93,    85,    94,    95,    96,    97,
     105,    98,    99,   100,    89,   102,   103,   104,   108,   109,
     110,   111,   112,    84,    41,     0,     0,     0,     0,    65,
      83
};

static const yysigned_char yycheck[] =
{
       9,    13,    14,    15,    16,    62,     3,    31,    13,    14,
      15,    16,     3,     7,    11,    39,    29,    30,     3,    28,
      44,    29,     7,    42,    43,     6,    34,    35,    36,    37,
      40,    41,     6,    90,    46,    29,     6,     6,    47,     6,
      34,    35,    36,    37,    29,    30,    31,    32,    10,     6,
       6,     6,     0,    12,     8,     7,    18,    19,    20,    21,
      22,    23,    24,    25,    26,     3,     3,     3,     3,    45,
      32,    33,     6,     6,     3,     3,    38,     3,     3,     3,
      27,     4,     3,     3,     3,    17,     3,     3,     3,     3,
      12,     4,     4,     3,    52,     4,     4,     3,    28,     4,
       4,     3,     3,    49,    15,    -1,    -1,    -1,    -1,    27,
      41
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char yystos[] =
{
       0,    10,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    32,    33,    38,    49,    50,    58,    62,     3,    11,
      29,    30,     6,     6,     3,     7,    29,    30,    31,    32,
       6,     6,     6,     6,     3,     6,     6,    31,    39,    44,
       0,    58,     8,    51,    13,    14,    15,    16,    53,    54,
      55,    12,    57,     3,     3,     7,    29,    34,    35,    36,
      37,    52,     3,     7,    60,    60,     6,     6,     3,     3,
       3,     3,     9,    28,    47,    59,     3,     3,    42,    43,
      40,    41,    45,    51,    53,    17,    56,     4,    46,    55,
       3,    52,     3,     3,     3,     3,     3,     3,     4,     4,
       3,    61,     4,     4,     3,    12,    52,    27,    28,     4,
       4,     3,     3
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrlab1

/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");			\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)           \
  Current.first_line   = Rhs[1].first_line;      \
  Current.first_column = Rhs[1].first_column;    \
  Current.last_line    = Rhs[N].last_line;       \
  Current.last_column  = Rhs[N].last_column;
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#define YYLEX	yylex ()

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)
# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)
/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
#endif /* !YYDEBUG */

/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*-----------------------------.
| Print this symbol on YYOUT.  |
`-----------------------------*/

static void
#if defined (__STDC__) || defined (__cplusplus)
yysymprint (FILE* yyout, int yytype, YYSTYPE yyvalue)
#else
yysymprint (yyout, yytype, yyvalue)
    FILE* yyout;
    int yytype;
    YYSTYPE yyvalue;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvalue;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyout, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyout, yytoknum[yytype], yyvalue);
# endif
    }
  else
    YYFPRINTF (yyout, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyout, ")");
}
#endif /* YYDEBUG. */


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
#if defined (__STDC__) || defined (__cplusplus)
yydestruct (int yytype, YYSTYPE yyvalue)
#else
yydestruct (yytype, yyvalue)
    int yytype;
    YYSTYPE yyvalue;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvalue;

  switch (yytype)
    {
      default:
        break;
    }
}



/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
#  define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#  define YYPARSE_PARAM_DECL
# else
#  define YYPARSE_PARAM_ARG YYPARSE_PARAM
#  define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
# endif
#else /* !YYPARSE_PARAM */
# define YYPARSE_PARAM_ARG
# define YYPARSE_PARAM_DECL
#endif /* !YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
# ifdef YYPARSE_PARAM
int yyparse (void *);
# else
int yyparse (void);
# endif
#endif


/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of parse errors so far.  */
int yynerrs;


int
yyparse (YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yychar1 = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with.  */

  if (yychar <= 0)		/* This means end of input.  */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more.  */

      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yychar1 = YYTRANSLATE (yychar);

      /* We have to keep this `#if YYDEBUG', since we use variables
	 which are defined only if `YYDEBUG' is set.  */
      YYDPRINTF ((stderr, "Next token is "));
      YYDSYMPRINT ((stderr, yychar1, yylval));
      YYDPRINTF ((stderr, "\n"));
    }

  /* If the proper action on seeing token YYCHAR1 is to reduce or to
     detect an error, take that action.  */
  yyn += yychar1;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yychar1)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %d (%s), ",
	      yychar, yytname[yychar1]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];



#if YYDEBUG
  /* We have to keep this `#if YYDEBUG', since we use variables which
     are defined only if `YYDEBUG' is set.  */
  if (yydebug)
    {
      int yyi;

      YYFPRINTF (stderr, "Reducing via rule %d (line %d), ",
		 yyn - 1, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (yyi = yyprhs[yyn]; yyrhs[yyi] >= 0; yyi++)
	YYFPRINTF (stderr, "%s ", yytname[yyrhs[yyi]]);
      YYFPRINTF (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif
  switch (yyn)
    {
        case 7:
#line 106 "cfg.y"
    { yyval.tv_int = 2; }
    break;

  case 8:
#line 107 "cfg.y"
    { yyval.tv_int = 5; }
    break;

  case 9:
#line 108 "cfg.y"
    { yyval.tv_int = 3; }
    break;

  case 10:
#line 109 "cfg.y"
    { yyval.tv_int = 2; }
    break;

  case 11:
#line 110 "cfg.y"
    { yyval.tv_int = 1; }
    break;

  case 12:
#line 111 "cfg.y"
    { yyval.tv_int = 0; }
    break;

  case 13:
#line 115 "cfg.y"
    { yyval.tv_int = IFLAG_INONLY; }
    break;

  case 14:
#line 116 "cfg.y"
    { yyval.tv_int = IFLAG_PROMISC; }
    break;

  case 15:
#line 117 "cfg.y"
    { yyval.tv_int = IFLAG_NF_SAMPLED; }
    break;

  case 16:
#line 118 "cfg.y"
    { yyval.tv_int = IFLAG_NF_DISABLE; }
    break;

  case 17:
#line 122 "cfg.y"
    { yyval.tv_int = yyvsp[0].tv_int; }
    break;

  case 18:
#line 123 "cfg.y"
    { yyval.tv_int = yyvsp[-1].tv_int | yyvsp[0].tv_int; }
    break;

  case 19:
#line 127 "cfg.y"
    { yyval.tv_int = 0; }
    break;

  case 20:
#line 128 "cfg.y"
    { yyval.tv_int = yyvsp[0].tv_int; }
    break;

  case 21:
#line 132 "cfg.y"
    { yyval.tv_char = yyvsp[0].tv_char; }
    break;

  case 22:
#line 136 "cfg.y"
    {
		yyval.tv_int = (1 << (yyvsp[0].tv_int - 1));
	}
    break;

  case 23:
#line 139 "cfg.y"
    {
		yyval.tv_int = yyvsp[-3].tv_int | (1 << (yyvsp[0].tv_int - 1));
	}
    break;

  case 24:
#line 145 "cfg.y"
    {
		if(conf->pidfile)
			return yyerror("Pidfile already defined");
		conf->pidfile = yyvsp[0].tv_char;
	}
    break;

  case 25:
#line 150 "cfg.y"
    {
		cfg_add_iface(yyvsp[-1].tv_char, yyvsp[0].tv_int, NULL);
		free(yyvsp[-1].tv_char);
	}
    break;

  case 26:
#line 154 "cfg.y"
    {
		cfg_add_iface(yyvsp[-2].tv_char, yyvsp[-1].tv_int, yyvsp[0].tv_char);
		free(yyvsp[-2].tv_char);
	}
    break;

  case 27:
#line 158 "cfg.y"
    {
		char *p;
		p = malloc(16);
		assert(p);
		snprintf(p, 16, "%u", yyvsp[-1].tv_int);
		cfg_add_iface("ulog", yyvsp[0].tv_int, p);
	}
    break;

  case 28:
#line 165 "cfg.y"
    {
		if( conf->dump_table_file )
			free(conf->dump_table_file);
		conf->dump_table_file = yyvsp[0].tv_char;
	}
    break;

  case 29:
#line 170 "cfg.y"
    {
		conf->capture_ports = 1;
	}
    break;

  case 30:
#line 173 "cfg.y"
    {
		conf->capture_ports = 0;
	}
    break;

  case 31:
#line 176 "cfg.y"
    {
		if(add_server(rsh_server, "RSH Server", &(yyvsp[0].tv_ip), 514))
			return yyerror("Failed to install RSH server");
		fprintf(stderr, "Configured RSH Server listening at %s\n",
			inet_ntoa(yyvsp[0].tv_ip));
	}
    break;

  case 32:
#line 182 "cfg.y"
    {
		fprintf(stderr, "Warning: Option at line %d has no effect\n",
			ipcacfglineno);
	}
    break;

  case 33:
#line 186 "cfg.y"
    {
		int to_ms;
		to_ms = atoi(yyvsp[0].tv_char);
		free(yyvsp[0].tv_char);
		if(to_ms < 0)
			to_ms = -1;	/* INFTIM */
		else
			to_ms = to_ms * 1000;
		rsh_rw_timeout = to_ms;
	}
    break;

  case 34:
#line 196 "cfg.y"
    {
		cfg_add_rsh_host("", yyvsp[-1].tv_char, yyvsp[0].tv_int);
		free(yyvsp[-1].tv_char);
	}
    break;

  case 35:
#line 200 "cfg.y"
    {
		cfg_add_rsh_host("", yyvsp[-1].tv_char, yyvsp[0].tv_int);
		free(yyvsp[-1].tv_char);
	}
    break;

  case 36:
#line 204 "cfg.y"
    {
		cfg_add_rsh_host(yyvsp[-3].tv_char, yyvsp[-1].tv_char, yyvsp[0].tv_int);
		free(yyvsp[-3].tv_char); free(yyvsp[-1].tv_char);
	}
    break;

  case 37:
#line 208 "cfg.y"
    {
		conf->rsh_ttl = atoi(yyvsp[0].tv_char);
		free(yyvsp[0].tv_char);
	}
    break;

  case 38:
#line 212 "cfg.y"
    {
		fprintf(stderr, "WARNING: \"ttl = %s;\" at line %d: "
			"Obsolete syntax. Please use \"rsh ttl = %s;\"\n",
			yyvsp[0].tv_char, ipcacfglineno, yyvsp[0].tv_char);
		conf->rsh_ttl = atoi(yyvsp[0].tv_char);
		free(yyvsp[0].tv_char);
	}
    break;

  case 40:
#line 220 "cfg.y"
    {
		if(conf->chroot_to)
			free(conf->chroot_to);
		conf->chroot_to = yyvsp[0].tv_char;
	}
    break;

  case 41:
#line 225 "cfg.y"
    {
		int id = yyvsp[0].tv_char ? atoi(yyvsp[0].tv_char) : -1;
		free(yyvsp[0].tv_char);
		if(id < 0 || id > 65535)
			return yyerror("Inappropriate UID value");
		conf->set_uid = id;
	}
    break;

  case 42:
#line 232 "cfg.y"
    {
		int id = yyvsp[0].tv_char ? atoi(yyvsp[0].tv_char) : -1;
		free(yyvsp[0].tv_char);
		if(id < 0 || id > 65535)
			return yyerror("Inappropriate UID value");
		conf->set_gid = id;
	}
    break;

  case 43:
#line 240 "cfg.y"
    {
		char *p = yyvsp[0].tv_char;

		conf->memsize = atoi(yyvsp[0].tv_char);
		if(conf->memsize <= 0) {
			free(yyvsp[0].tv_char);
			return yyerror("Invalid memory limit");
		}
		while(*++p) {
			switch(*p) {
			case '0': case '1': case '2': case '3': case '4':
			case '5': case '6': case '7': case '8': case '9':
				continue;
			case ' ':
				break;
			case 'k':
				conf->memsize *= 1024;
				break;
			case 'm':
				conf->memsize *= 1024 * 1024;
				break;
			case 'g':
				conf->memsize *= 1024 * 1024 * 1024;
				break;
			case 'e':
				conf->memsize *= sizeof(flow_el_t);
				break;
			default:
				fprintf(stderr,
					"Invalid memory limit at line %d "
					"near '%c': %s\n",
					*p, ipcacfglineno, yyvsp[0].tv_char);
				return -1;
			}
		}
		free(yyvsp[0].tv_char);
	}
    break;

  case 44:
#line 278 "cfg.y"
    {
		char *p = yyvsp[0].tv_char;

		conf->bufsize = atoi(yyvsp[0].tv_char);
		if(conf->bufsize <= 0) {
			free(yyvsp[0].tv_char);
			return yyerror("Invalid buffers size");
		}
		while(*++p) {
			switch(*p) {
			case '0': case '1': case '2': case '3': case '4':
			case '5': case '6': case '7': case '8': case '9':
				continue;
			case ' ':
				break;
			case 'k':
				conf->bufsize *= 1024;
				break;
			case 'm':
				conf->bufsize *= 1024 * 1024;
				break;
			case 'g':
				conf->bufsize *= 1024 * 1024 * 1024;
				break;
			default:
				fprintf(stderr,
					"Invalid buffers size at line %d "
					"near '%c': %s\n",
					*p, ipcacfglineno, yyvsp[0].tv_char);
				return -1;
			}
		}
		free(yyvsp[0].tv_char);
	}
    break;

  case 45:
#line 313 "cfg.y"
    {
		int ret;
		yyvsp[0].tv_aggr.s1 = yyvsp[-1].tv_char;
		if(yyvsp[0].tv_aggr.is_ip_aggr) {
			ret = cfg_add_atable(yyvsp[0].tv_aggr.s1, yyvsp[0].tv_aggr.s2, yyvsp[0].tv_aggr.s3);
		} else {
			ret = cfg_add_aggregate_ports_table(
				atoi(yyvsp[0].tv_aggr.s1),
				atoi(yyvsp[0].tv_aggr.s2?yyvsp[0].tv_aggr.s2:yyvsp[0].tv_aggr.s1),
				atoi(yyvsp[0].tv_aggr.s3));
		}

		if(yyvsp[0].tv_aggr.s1) free(yyvsp[0].tv_aggr.s1);
		if(yyvsp[0].tv_aggr.s2) free(yyvsp[0].tv_aggr.s2);
		if(yyvsp[0].tv_aggr.s3) free(yyvsp[0].tv_aggr.s3);
		if(ret)
			return yyerror("Parse error");
	}
    break;

  case 46:
#line 334 "cfg.y"
    {
		yyval.tv_aggr.is_ip_aggr = 1;
		yyval.tv_aggr.s2 = yyvsp[-2].tv_char;
		yyval.tv_aggr.s3 = yyvsp[0].tv_char;
	}
    break;

  case 47:
#line 339 "cfg.y"
    {
		yyval.tv_aggr.is_ip_aggr = 0;
		yyval.tv_aggr.s2 = yyvsp[-2].tv_char;
		yyval.tv_aggr.s3 = yyvsp[0].tv_char;
	}
    break;

  case 48:
#line 344 "cfg.y"
    {
		yyval.tv_aggr.is_ip_aggr = 0;
		yyval.tv_aggr.s2 = NULL;
		yyval.tv_aggr.s3 = yyvsp[0].tv_char;
	}
    break;

  case 49:
#line 352 "cfg.y"
    { yyval.tv_ip.s_addr = INADDR_ANY; }
    break;

  case 50:
#line 353 "cfg.y"
    {
		if(inet_aton(yyvsp[0].tv_char, &(yyval.tv_ip)) != 1)
			return yyerror("IP address expected");
		free(yyvsp[0].tv_char);
	}
    break;

  case 51:
#line 361 "cfg.y"
    {
		if(inet_aton(yyvsp[0].tv_char, &(yyval.tv_ip)) != 1)
			return yyerror("IP address expected");
		free(yyvsp[0].tv_char);
	}
    break;

  case 52:
#line 369 "cfg.y"
    {
		conf->netflow_enabled = 1;
		if(add_server(netflow_exporter,
				"NetFlow destination", &(yyvsp[-1].tv_ip), yyvsp[0].tv_int))
			return yyerror("Failed to install NetFlow destination");
		fprintf(stderr, "Configured NetFlow destination at %s:%d\n",
			inet_ntoa(yyvsp[-1].tv_ip), yyvsp[0].tv_int);
	}
    break;

  case 53:
#line 377 "cfg.y"
    {
		if(yyvsp[0].tv_int != 5 && yyvsp[0].tv_int != 1)
			yyerror("NetFlow version: "
				"only versions 1 and 5 are supported");
		conf->netflow_version = yyvsp[0].tv_int;
	}
    break;

  case 54:
#line 383 "cfg.y"
    {
		if(yyvsp[0].tv_int < 1 || yyvsp[0].tv_int > 60)
			return yyerror("Netflow active timeout "
				"out of range 1..60");
		conf->netflow_timeout_active = yyvsp[0].tv_int * 60;
	}
    break;

  case 55:
#line 389 "cfg.y"
    {
		if(yyvsp[0].tv_int < 1 || yyvsp[0].tv_int > 600)
			return yyerror("Netflow active timeout "
				"out of range 1..600");
		conf->netflow_timeout_inactive = yyvsp[0].tv_int;
	}
    break;

  case 56:
#line 395 "cfg.y"
    {
		if(yyvsp[0].tv_int < 10 || yyvsp[0].tv_int > 16382)
			return yyerror("Netflow packet interval "
				"out of range 10..16382");
		conf->netflow_packet_interval = yyvsp[0].tv_int;
	}
    break;


    }

/* Line 1016 of /usr/local/share/bison/yacc.c.  */
#line 1591 "y.tab.c"

  yyvsp -= yylen;
  yyssp -= yylen;


#if YYDEBUG
  if (yydebug)
    {
      short *yyssp1 = yyss - 1;
      YYFPRINTF (stderr, "state stack now");
      while (yyssp1 != yyssp)
	YYFPRINTF (stderr, " %d", *++yyssp1);
      YYFPRINTF (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  int yytype = YYTRANSLATE (yychar);
	  char *yymsg;
	  int yyx, yycount;

	  yycount = 0;
	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  for (yyx = yyn < 0 ? -yyn : 0;
	       yyx < (int) (sizeof (yytname) / sizeof (char *)); yyx++)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      yysize += yystrlen (yytname[yyx]) + 15, yycount++;
	  yysize += yystrlen ("parse error, unexpected ") + 1;
	  yysize += yystrlen (yytname[yytype]);
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "parse error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yycount = 0;
		  for (yyx = yyn < 0 ? -yyn : 0;
		       yyx < (int) (sizeof (yytname) / sizeof (char *));
		       yyx++)
		    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			const char *yyq = ! yycount ? ", expecting " : " or ";
			yyp = yystpcpy (yyp, yyq);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yycount++;
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror ("parse error");
    }
  goto yyerrlab1;


/*----------------------------------------------------.
| yyerrlab1 -- error raised explicitly by an action.  |
`----------------------------------------------------*/
yyerrlab1:
  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      /* Return failure if at end of input.  */
      if (yychar == YYEOF)
        {
	  /* Pop the error token.  */
          YYPOPSTACK;
	  /* Pop the rest of the stack.  */
	  while (yyssp > yyss)
	    {
	      YYDPRINTF ((stderr, "Error: popping "));
	      YYDSYMPRINT ((stderr,
			    yystos[*yyssp],
			    *yyvsp));
	      YYDPRINTF ((stderr, "\n"));
	      yydestruct (yystos[*yyssp], *yyvsp);
	      YYPOPSTACK;
	    }
	  YYABORT;
        }

      YYDPRINTF ((stderr, "Discarding token %d (%s).\n",
		  yychar, yytname[yychar1]));
      yydestruct (yychar1, yylval);
      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */

  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      YYDPRINTF ((stderr, "Error: popping "));
      YYDSYMPRINT ((stderr,
		    yystos[*yyssp], *yyvsp));
      YYDPRINTF ((stderr, "\n"));

      yydestruct (yystos[yystate], *yyvsp);
      yyvsp--;
      yystate = *--yyssp;


#if YYDEBUG
      if (yydebug)
	{
	  short *yyssp1 = yyss - 1;
	  YYFPRINTF (stderr, "Error: state stack now");
	  while (yyssp1 != yyssp)
	    YYFPRINTF (stderr, " %d", *++yyssp1);
	  YYFPRINTF (stderr, "\n");
	}
#endif
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;


  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 403 "cfg.y"


int
yyerror(char *s) {
	fprintf(stderr,
		"Config parse error near line %d: %s\n",
		ipcacfglineno, s);
	return -1;
};


