/*-
 * Copyright (c) 2001, 2002 Lev Walkin <vlm@spelio.net.ru>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: rsh.c,v 1.8 2002/03/25 04:04:03 vlm Exp $
 */

#include "ipcad.h"
#include "got.h"
#include "servers.h"
#include "opt.h"


/* Checkpoint list variables */
struct ipstream *checkpoint = NULL;
size_t checkpoint_entries = 0;
time_t checkpoint_time = 0;

void *prr_handler();
int process_rsh_request(int sock);

int
check_rsh_request(int sock, struct sockaddr_in *srem) {
	if( ntohs(srem->sin_port) > 1023 )
		return -1;
	return 0;
}

int fork_rsh_request(int client);

void *
rsh_server(void *srvp) {
	struct sockaddr_in sin;
	struct sockaddr_in srem;
	server *srv = (server *)srvp;
	size_t	addrlen;
	int lcmd = 0;	/* Listening socket at "shell" (514) */
	int client;
	socklen_t on = 1;
	sigset_t set, oset;

	if((lcmd = socket(PF_INET, SOCK_STREAM, 6)) == -1) {
		fprintf(stderr, "Can't create socket for %s.\n",
			srv->name);
		return NULL;
	};

	setsockopt(lcmd, SOL_SOCKET, SO_REUSEADDR, &on, sizeof(on));

	memset(&sin, 0, sizeof(sin));

	*(char *)&sin = sizeof(sin);
	sin.sin_family = PF_INET;
	sin.sin_addr = srv->listen_ip;
	sin.sin_port = htons(514);

	if( bind(lcmd, (struct sockaddr *)&sin, sizeof(sin)) == -1) {
		fprintf(stderr, "Can't bind socket for %s.\n",
			srv->name);
		return NULL;
	};

	if( listen(lcmd, 5) == -1 ) {
		fprintf(stderr, "Can't set %s socket to listen state.\n",
			srv->name);
		return NULL;
	};

	/* Flag for parent thread */
	srv->started_ok = 1;

	sigemptyset(&set);
	sigaddset(&set, SIGALRM);

	while(1) {

		if(signoff_now)
			break;

		/* Unblock SIGALRM */
		sigprocmask(SIG_UNBLOCK, &set, &oset);

		addrlen = sizeof(srem);
		client = accept(lcmd, (struct sockaddr *)&srem, &addrlen);

		/* Block SIGARLM */
		sigprocmask(SIG_SETMASK, &oset, NULL);

		if(signoff_now)
			break;

		if(client == -1)
			continue;

		if(addrlen != sizeof(srem)) {
			close(client);
			continue;
		};

		if( check_rsh_request(client, &srem) ) {
			write(client, "Permission denied.\n",
				sizeof("Permission denied.\n"));
			close(client);
			continue;
		}

		fork_rsh_request(client);

	};

	/* Impossible thing */
	return NULL;
};

int
fork_rsh_request(int client) {
	pthread_t thid;
	void *argp;

	if(max_clients <= 0) {
		write(client, "Too many clients.\n",
			sizeof("Too many clients.\n"));
		close(client);
	}

	argp = malloc(sizeof(client));
	if(!argp) {
		close(client);
		return -1;
	}
	*((int *)argp) = client;

	if( pthread_create(&thid, &thread_attr_detach, prr_handler, argp) ) {
		free(argp);
		close(client);
		return -1;
	};

	return 0;
}

void *
prr_handler(void *argp) {
	int client = *(int *)argp;

	free(argp);

	pthread_mutex_lock(&max_clients_lock);
	max_clients--;
	pthread_mutex_unlock(&max_clients_lock);

	process_rsh_request(client);
	close(client);

	pthread_mutex_lock(&max_clients_lock);
	max_clients++;
	pthread_mutex_unlock(&max_clients_lock);

	return NULL;
};


