/*-
 * Copyright (c) 2001 Lev Walkin <vlm@spelio.net.ru>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: ppl-pcap.c,v 1.10 2001/11/29 14:02:10 vlm Exp $
 */

#include "ipcad.h"
#include "opt.h"

void *
pps_loop(void *psp) {
	packet_source *ps = (packet_source *)psp;
	int pdr;
	struct pollfd pfd;
	sigset_t set, oset;

	sigemptyset(&set);
	sigaddset(&set, SIGALRM);
	
	while(1) {

		if(signoff_now)
			break;

		/*
		 * TODO: add longjump on SIGALRM inside dispatch.
		 */

		sigprocmask(SIG_UNBLOCK, &set, &oset);
		pdr = pcap_dispatch(ps->dev, 0,
			process_packet_data, (unsigned char *)ps);
		sigprocmask(SIG_SETMASK, &oset, NULL);

		/* Timeout */
		if(pdr == 0) {
			pfd.fd = pcap_fileno(ps->dev);
			pfd.events = POLLIN;
			sigprocmask(SIG_UNBLOCK, &set, &oset);
			poll(&pfd, 1, -1);
			sigprocmask(SIG_SETMASK, &oset, NULL);
			continue;
		}

		/* Device error */
		if(pdr == -1) {
			pcap_close(ps->dev);
			reopen_packet_source(ps, 1);
		}

	}

	return NULL;
};
