/*-
 * Copyright (c) 2001 Lev Walkin <vlm@spelio.net.ru>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: ipcad.h,v 1.19 2001/08/30 08:40:24 vlm Exp $
 */

#ifndef	__IPCAD_H__
#define	__IPCAD_H__

#define	IPCAD_VERSION_NUMBER	"2.6"
#define	IPCAD_VERSION	"IP Accounting Daemon for BPF/PCAP. ipcad Version " IPCAD_VERSION_NUMBER
#define	IPCAD_COPYRIGHT "Copyright (c) 2001 Lev Walkin <vlm@spelio.net.ru>"

#include "headers.h"

typedef struct _packet_source {
#ifdef	PSRC_bpf
	int fd;
	char *buf;
	size_t bufsize;
#else
	pcap_t *dev;
#endif
	char ifname[IFNAMSIZ];
	unsigned int dlt;
	unsigned int iflags;
	pthread_t thid;
	struct _packet_source *next;

	/* Statistics */
	unsigned long bytes_prev;  /* Bytes per previous second, estimated */
	unsigned long bytes_cur;   /* Current bytecount */
	unsigned long packets_prev;  /* Packets per previous second, estimated */
	unsigned long packets_cur;   /* Current packets count */

	long long bytes_lp; /* Bytes per long period */
	unsigned long bps_lp;      /* Bytes per second per long period */

	long long packets_lp; /* Packets per long period */
	unsigned long pps_lp;      /* Bytes per second per long period */

	unsigned long period;  /* Period in milliseconds */
} packet_source;


packet_source *init_packet_source(char *ifname, int iflags);
packet_source *init_packet_source_common(char *ifname, int iflags);

int reopen_packet_source(packet_source *psrc, int loop);

int process_packet_sources(packet_source *sources);

#ifdef	PSRC_bpf
	void process_packet_data(unsigned char *psp,
    	const struct bpf_hdr *bh,
    	const unsigned char *packet);
#else
	void process_packet_data(unsigned char *psp,
		    const struct pcap_pkthdr *ph,
    	const unsigned char *packet);
#endif

void *pps_loop(void *ps);

struct ipstream {
	struct in_addr src;
	struct in_addr dst;
	size_t packets;
	struct ipstream *next;
	unsigned long long bytes;
};

extern struct ipstream *ipstream;
extern size_t ipstream_entries;
extern time_t ipstream_time;
extern struct ipstream *checkpoint;
extern size_t checkpoint_entries;
extern time_t checkpoint_time;

void print_ip(FILE *, struct in_addr);
void print_aligned_ip(FILE *, struct in_addr);
int display(FILE *, int ischeckpoint);
int if_stat(FILE *, char *iface);
void system_uptime(FILE *);
void ipcad_uptime(FILE *);
void display_uptime(FILE *, time_t uptime);

void usage();
void show_stats( FILE *f );
void show_version( FILE *f );

int cfgread(const char *);

extern time_t current_time;
extern struct timeval self_started;

struct ipstream *fast_get_table();

/* Hack against RedHat distribution */
#ifndef	SHUT_RDWR
#define	SHUT_RDWR	2
#endif

int ifst_preopen();

int display_internal_averages(FILE *, const char *ifname);

#endif
