/*-
 * Copyright (c) 2001 Lev Walkin <vlm@spelio.net.ru>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: headers.h,v 1.11 2002/01/23 18:08:38 vlm Exp $
 */

#ifndef	__HEADERS_H__
#define	__HEADERS_H__

#ifndef	__need_sig_atomic_t
#define	__need_sig_atomic_t	1
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef	HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef	HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifdef	HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#ifdef	HAVE_FCNTL_H
#include <fcntl.h>
#endif

#ifdef	HAVE_SYS_FILE_H
#include <sys/file.h>
#endif

#ifdef	HAVE_SYS_TIME_H
#include <sys/time.h>
#endif

#ifdef	HAVE_SYS_RESOURCE_H
#include <sys/resource.h>
#endif

#ifdef	HAVE_SYS_IOCTL_H
#include <sys/ioctl.h>
#endif

#ifdef	HAVE_SYS_SOCKET_H
#include <sys/socket.h>
#endif

#ifdef HAVE_NET_IF_H
#include <net/if.h>
#endif

#ifdef HAVE_NET_ETHERNET_H
#include <net/ethernet.h>
#endif

#ifdef HAVE_NETINET_IN_SYSTM_H
#include <netinet/in_systm.h>
#endif

#ifdef	HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif

#ifdef	HAVE_NETINET_IP_H
#include <netinet/ip.h>
#endif

#ifdef	HAVE_ARPA_INET_H
#include <arpa/inet.h>
#endif

#ifdef HAVE_NETINET_IF_ETHER_H
#include <netinet/if_ether.h>
#endif

#ifdef	HAVE_NETDB_H
#include <netdb.h>
#endif

#ifdef	HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif

#ifdef	HAVE_SYSEXITS_H
#include <sysexits.h>
#endif

#ifdef	HAVE_ERRNO_H
#include <errno.h>
#endif

#ifdef	HAVE_PTHREAD_H
#include <pthread.h>
#endif


#if defined(HAVE_NET_BPF_H) && ( defined(__FreeBSD__) || defined(__OpenBSD__) )
#include <net/bpf.h>
#else	/* #ifdef HAVE_NET_BPF_H */
#ifdef	HAVE_PCAP_H
#include <pcap.h>
#else	/* #ifdef HAVE_PCAP_H */
#ifdef	HAVE_PCAP_PCAP_H
#include <pcap/pcap.h>
#else	/* #ifdef HAVE_PCAP_PCAP_H */
#error	No BPF or PCAP installed. Aborting.
#endif	/* #ifdef HAVE_PCAP_PCAP_H */
#endif	/* #ifdef HAVE_PCAP_H */
#endif	/* #ifdef HAVE_NET_BPF_H */

#include <poll.h>
#include <signal.h>

#ifndef HAVE_SOCKLEN_T
typedef size_t	socklen_t;
#endif

#endif
