/*-
 * Copyright (c) 2001 Lev Walkin <vlm@spelio.net.ru>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: cfgvar.h,v 1.5 2001/05/23 12:42:44 vlm Exp $
 */

#ifndef	__CFGVAR_H__
#define	__CFGVAR_H__

#include "ipcad.h"

extern char *cfg_dump_file;

extern size_t memsize;
extern size_t used_memory;

extern packet_source *packet_sources_head;

extern time_t ex_current_stalled;
extern size_t ex_current_packets;
extern size_t ex_current_bytes;

extern time_t ex_checkpoint_stalled;
extern size_t ex_checkpoint_packets;
extern size_t ex_checkpoint_bytes;

int cfg_add_iface(char *, int iflags);
int cfg_add_rsh_host(char *ru, char *rh, int privlevel);
int cfg_check_rsh(char *ru, struct in_addr *);

extern char *chroot_to;

struct atable {
	struct in_addr ip;
	struct in_addr mask;
	struct in_addr strip;
	struct atable *next;
};

extern struct atable *atable;

int cfg_add_atable(char *ip, char *mask, char *strip);

int make_dump(char *, FILE *);
int import_table(char *, FILE *, int clear);

#endif
