%{

#include "headers.h"
#include "cfgy.h"

int ipcacfglineno = 1;

%}

%option never-interactive
%option noinput nounput
%option noyywrap stack
%option caseless 8bit

%pointer

%x comment
%x string
%x ifname
%x rshdef
%x ipmask

%%

<*>"/*"		yy_push_state(comment);
<comment>{
	[^*/\n]		/* Eat */
	"*/"	yy_pop_state();
	\n		ipcacfglineno++;
	.	/* Eat */
}

<*>";"	{ while(YY_START) yy_pop_state(); return SEMICOLON; }
"="		{ yy_push_state(string); return EQ; }

#[^\n]*[\n]?	{
		if(yytext[yyleng-1] == '\n')
			ipcacfglineno++;
	}

ttl		{ return TTL; }

interface|iface		{
		yy_push_state(ifname);
		return IFACE;
	}
<ifname>{
	input[a-z_-]*	return INONLY;
	prom[a-z]*		return PROMISC;
	[a-z]+[0-9]+\.[0-9]+	{
		ipcacfglval.tv_char = strdup(yytext);
		return TOK_STRING;
	}
	[a-z]+[0-9]*	{
		ipcacfglval.tv_char = strdup(yytext);
		return TOK_STRING;
	}
}

rsh|rcmd	{ yy_push_state(rshdef); return RSH; }

<rshdef>{
	"@"		return AT;
	at		return AT;
	timeout				{ yy_pop_state(); return TIMEOUT; }

	deny|off|disable|no		return DENY;
	allow|on|enable|yes		return ALLOW;
	view[a-z-]*		return VIEW_ONLY;
	default		return DEFAULT;
	backup		return BACKUP;
	admin		return ADMIN;

	[a-z0-9._]+	{
		ipcacfglval.tv_char = strdup(yytext);
		return TOK_STRING;
	}
}


mem[a-z_-]*		return MEMSIZE;
chroot		return CHROOT;
dump[a-z]*	return DUMP;

aggr[a-z]*	{ yy_push_state(ipmask); return AGGR; }
<ipmask>{
	[0-9.]+	{
		ipcacfglval.tv_char = strdup(yytext);
		return TOK_STRING;
	}
	"/"		return SLASH;
	strip	return STRIP;
}

<string>[a-z0-9./-]+	{
		ipcacfglval.tv_char = strdup(yytext);
		return TOK_STRING;
	}

<*>[[:space:]]	{
		if(*yytext == '\n')
			ipcacfglineno++;
	}

<*>.	{ return ERROR; }

<*><<EOF>>	{ yyterminate(); }

%%
