#ifndef _HASH_H
#define _HASH_H

/*
------------------------------------------------------------------------
Type Definitions
------------------------------------------------------------------------
*/
typedef struct hlist_s {
	struct hlist_s *next;
	u_char *key;
	int    nkey;
	u_char *data;
	int    ndata;
	}
	hlist_t;

/*
------------------------------------------------------------------------
Function Prototypes
------------------------------------------------------------------------
*/
hlist_t **init_htable (int ntable) ;
int       finddata    (hlist_t **ha, u_char *key, int nkey, u_char **data, int *ndata) ;
int       addnode     (hlist_t **ha, u_char *key, int nkey, u_char *data, int ndata) ;
void      getfirst    (hlist_t **ha);
hlist_t  *getnext     (hlist_t **ha);
int       getcount    (void);

#endif
